/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.sdk.config;

import io.arconia.core.config.adapter.PropertyAdapter;
import io.arconia.opentelemetry.autoconfigure.sdk.config.OpenTelemetrySdkPropertyConverters;
import java.util.HashMap;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class OpenTelemetrySdkPropertyAdapters {
    OpenTelemetrySdkPropertyAdapters() {
    }

    static PropertyAdapter general(ConfigurableEnvironment environment) {
        Assert.notNull((Object)environment, (String)"environment cannot be null");
        return PropertyAdapter.builder((ConfigurableEnvironment)environment).mapProperty("otel.sdk.disabled", "arconia.otel.enabled", value -> !Boolean.parseBoolean(value.toLowerCase())).mapInteger("otel.attribute.value.length.limit", "arconia.otel.logs.log-limits.max-attribute-value-length").mapInteger("otel.attribute.value.length.limit", "arconia.otel.traces.span-limits.max-attribute-value-length").mapInteger("otel.attribute.count.limit", "arconia.otel.logs.log-limits.max-number-of-attributes").mapInteger("otel.attribute.count.limit", "arconia.otel.traces.span-limits.max-number-of-attributes").mapEnum("otel.propagators", "management.tracing.propagation.produce", OpenTelemetrySdkPropertyConverters::propagationType).build();
    }

    static PropertyAdapter resource(ConfigurableEnvironment environment) {
        Assert.notNull((Object)environment, (String)"environment cannot be null");
        return PropertyAdapter.builder((ConfigurableEnvironment)environment).mapString("otel.service.name", "arconia.otel.resource.service-name").mapMap("otel.resource.attributes", "arconia.otel.resource.attributes").mapProperty("otel.resource.disabled.keys", "arconia.otel.resource.enable", value -> {
            HashMap<String, Boolean> disabledKeys = new HashMap<String, Boolean>();
            for (String key : value.trim().split("\\s*,\\s*")) {
                if (!StringUtils.hasText((String)key)) continue;
                disabledKeys.put(key.trim(), false);
            }
            return disabledKeys;
        }).build();
    }

    static PropertyAdapter logs(ConfigurableEnvironment environment) {
        Assert.notNull((Object)environment, (String)"environment cannot be null");
        return PropertyAdapter.builder((ConfigurableEnvironment)environment).mapDuration("otel.blrp.schedule.delay", "arconia.otel.logs.processor.schedule-delay").mapInteger("otel.blrp.max.queue.size", "arconia.otel.logs.processor.max-queue-size").mapInteger("otel.blrp.max.export.batch.size", "arconia.otel.logs.processor.max-export-batch-size").mapDuration("otel.blrp.export.timeout", "arconia.otel.logs.processor.exporter-timeout").build();
    }

    static PropertyAdapter metrics(ConfigurableEnvironment environment) {
        Assert.notNull((Object)environment, (String)"environment cannot be null");
        return PropertyAdapter.builder((ConfigurableEnvironment)environment).mapDuration("otel.metric.export.interval", "arconia.otel.metrics.interval").mapEnum("otel.metrics.exemplar.filter", "arconia.otel.metrics.exemplar-filter", OpenTelemetrySdkPropertyConverters::exemplarFilter).mapInteger("otel.java.metrics.cardinality.limit", "arconia.otel.metrics.cardinality-limit").build();
    }

    static PropertyAdapter traces(ConfigurableEnvironment environment) {
        Assert.notNull((Object)environment, (String)"environment cannot be null");
        return PropertyAdapter.builder((ConfigurableEnvironment)environment).mapDuration("otel.bsp.schedule.delay", "arconia.otel.traces.processor.schedule-delay").mapInteger("otel.bsp.max.queue.size", "arconia.otel.traces.processor.max-queue-size").mapInteger("otel.bsp.max.export.batch.size", "arconia.otel.traces.processor.max-export-batch-size").mapDuration("otel.bsp.export.timeout", "arconia.otel.traces.processor.exporter-timeout").mapEnum("otel.tracer.sampler", "arconia.otel.traces.sampling.strategy", OpenTelemetrySdkPropertyConverters::samplingStrategy).mapDouble("otel.tracer.sampler.arg", "management.tracing.sampling.probability").mapInteger("otel.span.attribute.value.length.limit", "arconia.otel.traces.span-limits.max-attribute-value-length").mapInteger("otel.span.attribute.count.limit", "arconia.otel.traces.span-limits.max-number-of-attributes").mapInteger("otel.span.event.count.limit", "arconia.otel.traces.span-limits.max-number-of-events").mapInteger("otel.span.link.count.limit", "arconia.otel.traces.span-limits.max-number-of-links").build();
    }

    static PropertyAdapter exporters(ConfigurableEnvironment environment) {
        Assert.notNull((Object)environment, (String)"environment cannot be null");
        return PropertyAdapter.builder((ConfigurableEnvironment)environment).mapEnum("otel.logs.exporter", "arconia.otel.logs.exporter.type", OpenTelemetrySdkPropertyConverters::exporterType).mapEnum("otel.metrics.exporter", "arconia.otel.metrics.exporter.type", OpenTelemetrySdkPropertyConverters::exporterType).mapEnum("otel.traces.exporter", "arconia.otel.traces.exporter.type", OpenTelemetrySdkPropertyConverters::exporterType).mapString("otel.java.exporter.memory_mode", "arconia.otel.exporter.memoryMode").mapEnum("otel.exporter.otlp.protocol", "arconia.otel.exporter.otlp.protocol", OpenTelemetrySdkPropertyConverters::protocol).mapString("otel.exporter.otlp.endpoint", "arconia.otel.exporter.otlp.endpoint").mapMap("otel.exporter.otlp.headers", "arconia.otel.exporter.otlp.headers").mapEnum("otel.exporter.otlp.compression", "arconia.otel.exporter.otlp.compression", OpenTelemetrySdkPropertyConverters::compression).mapDuration("otel.exporter.otlp.timeout", "arconia.otel.exporter.otlp.timeout").mapEnum("otel.exporter.otlp.logs.protocol", "arconia.otel.logs.exporter.otlp.protocol", OpenTelemetrySdkPropertyConverters::protocol).mapString("otel.exporter.otlp.logs.endpoint", "arconia.otel.logs.exporter.otlp.endpoint").mapMap("otel.exporter.otlp.logs.headers", "arconia.otel.logs.exporter.otlp.headers").mapEnum("otel.exporter.otlp.logs.compression", "arconia.otel.logs.exporter.otlp.compression", OpenTelemetrySdkPropertyConverters::compression).mapDuration("otel.exporter.otlp.logs.timeout", "arconia.otel.logs.exporter.otlp.timeout").mapEnum("otel.exporter.otlp.metrics.protocol", "arconia.otel.metrics.exporter.otlp.protocol", OpenTelemetrySdkPropertyConverters::protocol).mapString("otel.exporter.otlp.metrics.endpoint", "arconia.otel.metrics.exporter.otlp.endpoint").mapMap("otel.exporter.otlp.metrics.headers", "arconia.otel.metrics.exporter.otlp.headers").mapEnum("otel.exporter.otlp.metrics.compression", "arconia.otel.metrics.exporter.otlp.compression", OpenTelemetrySdkPropertyConverters::compression).mapDuration("otel.exporter.otlp.metrics.timeout", "arconia.otel.metrics.exporter.otlp.timeout").mapEnum("otel.exporter.otlp.metrics.default.histogram.aggregation", "arconia.otel.metrics.exporter.histogram-aggregation", OpenTelemetrySdkPropertyConverters::histogramAggregation).mapEnum("otel.exporter.otlp.metrics.temporality.preference", "arconia.otel.metrics.exporter.aggregation-temporality", OpenTelemetrySdkPropertyConverters::aggregationTemporality).mapEnum("otel.exporter.otlp.traces.protocol", "arconia.otel.traces.exporter.otlp.protocol", OpenTelemetrySdkPropertyConverters::protocol).mapString("otel.exporter.otlp.traces.endpoint", "arconia.otel.traces.exporter.otlp.endpoint").mapMap("otel.exporter.otlp.traces.headers", "arconia.otel.traces.exporter.otlp.headers").mapEnum("otel.exporter.otlp.traces.compression", "arconia.otel.traces.exporter.otlp.compression", OpenTelemetrySdkPropertyConverters::compression).mapDuration("otel.exporter.otlp.traces.timeout", "arconia.otel.traces.exporter.otlp.timeout").build();
    }
}

