/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.sdk.config;

import io.arconia.opentelemetry.autoconfigure.sdk.exporter.ExporterType;
import io.arconia.opentelemetry.autoconfigure.sdk.exporter.otlp.Compression;
import io.arconia.opentelemetry.autoconfigure.sdk.exporter.otlp.Protocol;
import io.arconia.opentelemetry.autoconfigure.sdk.metrics.OpenTelemetryMetricsProperties;
import io.arconia.opentelemetry.autoconfigure.sdk.metrics.exporter.AggregationTemporalityStrategy;
import io.arconia.opentelemetry.autoconfigure.sdk.metrics.exporter.HistogramAggregationStrategy;
import io.arconia.opentelemetry.autoconfigure.sdk.traces.OpenTelemetryTracingProperties;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.tracing.TracingProperties;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

class OpenTelemetrySdkPropertyConverters {
    private static final Logger logger = LoggerFactory.getLogger(OpenTelemetrySdkPropertyConverters.class);

    OpenTelemetrySdkPropertyConverters() {
    }

    static Function<String, @Nullable ExporterType> exporterType(String externalKey) {
        Assert.hasText((String)externalKey, (String)"externalKey cannot be null or empty");
        return value -> {
            ExporterType exporterType;
            switch (value.trim().toLowerCase()) {
                case "console": {
                    ExporterType exporterType2 = ExporterType.CONSOLE;
                    break;
                }
                case "none": {
                    ExporterType exporterType2 = ExporterType.NONE;
                    break;
                }
                case "otlp": {
                    ExporterType exporterType2 = ExporterType.OTLP;
                    break;
                }
                default: {
                    ExporterType exporterType2 = exporterType = null;
                }
            }
            if (exporterType == null) {
                logger.warn("Unsupported value for {}: {}", (Object)externalKey, value);
                return null;
            }
            return exporterType;
        };
    }

    static Function<String, @Nullable Protocol> protocol(String externalKey) {
        Assert.hasText((String)externalKey, (String)"externalKey cannot be null or empty");
        return value -> {
            Protocol protocol;
            switch (value.trim().toLowerCase()) {
                case "grpc": {
                    Protocol protocol2 = Protocol.GRPC;
                    break;
                }
                case "http/protobuf": {
                    Protocol protocol2 = Protocol.HTTP_PROTOBUF;
                    break;
                }
                default: {
                    Protocol protocol2 = protocol = null;
                }
            }
            if (protocol == null) {
                logger.warn("Unsupported value for {}: {}", (Object)externalKey, value);
                return null;
            }
            return protocol;
        };
    }

    static Function<String, @Nullable Compression> compression(String externalKey) {
        Assert.hasText((String)externalKey, (String)"externalKey cannot be null or empty");
        return value -> {
            Compression compression;
            switch (value.trim().toLowerCase()) {
                case "gzip": {
                    Compression compression2 = Compression.GZIP;
                    break;
                }
                case "none": {
                    Compression compression2 = Compression.NONE;
                    break;
                }
                default: {
                    Compression compression2 = compression = null;
                }
            }
            if (compression == null) {
                logger.warn("Unsupported value for {}: {}", (Object)externalKey, value);
                return null;
            }
            return compression;
        };
    }

    static Function<String, @Nullable HistogramAggregationStrategy> histogramAggregation(String externalKey) {
        Assert.hasText((String)externalKey, (String)"externalKey cannot be null or empty");
        return value -> {
            HistogramAggregationStrategy histogramAggregation;
            switch (value.trim().toUpperCase()) {
                case "BASE2_EXPONENTIAL_BUCKET_HISTOGRAM": {
                    HistogramAggregationStrategy histogramAggregationStrategy = HistogramAggregationStrategy.BASE2_EXPONENTIAL_BUCKET_HISTOGRAM;
                    break;
                }
                case "EXPLICIT_BUCKET_HISTOGRAM": {
                    HistogramAggregationStrategy histogramAggregationStrategy = HistogramAggregationStrategy.EXPLICIT_BUCKET_HISTOGRAM;
                    break;
                }
                default: {
                    HistogramAggregationStrategy histogramAggregationStrategy = histogramAggregation = null;
                }
            }
            if (histogramAggregation == null) {
                logger.warn("Unsupported value for {}: {}", (Object)externalKey, value);
                return null;
            }
            return histogramAggregation;
        };
    }

    static Function<String, @Nullable AggregationTemporalityStrategy> aggregationTemporality(String externalKey) {
        Assert.hasText((String)externalKey, (String)"externalKey cannot be null or empty");
        return value -> {
            AggregationTemporalityStrategy aggregationTemporality;
            switch (value.trim().toUpperCase()) {
                case "CUMULATIVE": {
                    AggregationTemporalityStrategy aggregationTemporalityStrategy = AggregationTemporalityStrategy.CUMULATIVE;
                    break;
                }
                case "DELTA": {
                    AggregationTemporalityStrategy aggregationTemporalityStrategy = AggregationTemporalityStrategy.DELTA;
                    break;
                }
                case "LOWMEMORY": {
                    AggregationTemporalityStrategy aggregationTemporalityStrategy = AggregationTemporalityStrategy.LOW_MEMORY;
                    break;
                }
                default: {
                    AggregationTemporalityStrategy aggregationTemporalityStrategy = aggregationTemporality = null;
                }
            }
            if (aggregationTemporality == null) {
                logger.warn("Unsupported value for {}: {}", (Object)externalKey, value);
                return null;
            }
            return aggregationTemporality;
        };
    }

    static Function<String,  @Nullable OpenTelemetryTracingProperties.SamplingStrategy> samplingStrategy(String externalKey) {
        Assert.hasText((String)externalKey, (String)"externalKey cannot be null or empty");
        return value -> {
            OpenTelemetryTracingProperties.SamplingStrategy protocol;
            switch (value.toLowerCase().trim()) {
                case "always_on": {
                    OpenTelemetryTracingProperties.SamplingStrategy samplingStrategy = OpenTelemetryTracingProperties.SamplingStrategy.ALWAYS_ON;
                    break;
                }
                case "always_off": {
                    OpenTelemetryTracingProperties.SamplingStrategy samplingStrategy = OpenTelemetryTracingProperties.SamplingStrategy.ALWAYS_OFF;
                    break;
                }
                case "traceidratio": {
                    OpenTelemetryTracingProperties.SamplingStrategy samplingStrategy = OpenTelemetryTracingProperties.SamplingStrategy.TRACE_ID_RATIO;
                    break;
                }
                case "parentbased_always_on": {
                    OpenTelemetryTracingProperties.SamplingStrategy samplingStrategy = OpenTelemetryTracingProperties.SamplingStrategy.PARENT_BASED_ALWAYS_ON;
                    break;
                }
                case "parentbased_always_off": {
                    OpenTelemetryTracingProperties.SamplingStrategy samplingStrategy = OpenTelemetryTracingProperties.SamplingStrategy.PARENT_BASED_ALWAYS_OFF;
                    break;
                }
                case "parentbased_traceidratio": {
                    OpenTelemetryTracingProperties.SamplingStrategy samplingStrategy = OpenTelemetryTracingProperties.SamplingStrategy.PARENT_BASED_TRACE_ID_RATIO;
                    break;
                }
                default: {
                    OpenTelemetryTracingProperties.SamplingStrategy samplingStrategy = protocol = null;
                }
            }
            if (protocol == null) {
                logger.warn("Unsupported value for {}: {}", (Object)externalKey, value);
                return null;
            }
            return protocol;
        };
    }

    static Function<String, @Nullable List<// Could not load outer class - annotation placement on inner may be incorrect
    TracingProperties.Propagation.PropagationType>> propagationType(String externalKey) {
        Assert.hasText((String)externalKey, (String)"externalKey cannot be null or empty");
        return value -> {
            String[] items;
            HashSet<TracingProperties.Propagation.PropagationType> propagators = new HashSet<TracingProperties.Propagation.PropagationType>();
            for (String item : items = value.trim().toLowerCase().split("\\s*,\\s*")) {
                TracingProperties.Propagation.PropagationType propagator;
                switch (item.trim()) {
                    case "baggage": {
                        TracingProperties.Propagation.PropagationType propagationType = TracingProperties.Propagation.PropagationType.W3C;
                        break;
                    }
                    case "tracecontext": {
                        TracingProperties.Propagation.PropagationType propagationType = TracingProperties.Propagation.PropagationType.W3C;
                        break;
                    }
                    case "b3": {
                        TracingProperties.Propagation.PropagationType propagationType = TracingProperties.Propagation.PropagationType.B3;
                        break;
                    }
                    case "b3multi": {
                        TracingProperties.Propagation.PropagationType propagationType = TracingProperties.Propagation.PropagationType.B3_MULTI;
                        break;
                    }
                    default: {
                        TracingProperties.Propagation.PropagationType propagationType = propagator = null;
                    }
                }
                if (propagator == null) {
                    logger.warn("Unsupported value for {}: {}", (Object)externalKey, value);
                    continue;
                }
                propagators.add(propagator);
            }
            List propagatorLists = propagators.stream().toList();
            return CollectionUtils.isEmpty(propagatorLists) ? null : propagatorLists;
        };
    }

    static Function<String,  @Nullable OpenTelemetryMetricsProperties.ExemplarFilter> exemplarFilter(String externalKey) {
        Assert.hasText((String)externalKey, (String)"externalKey cannot be null or empty");
        return value -> {
            OpenTelemetryMetricsProperties.ExemplarFilter exemplarFilter;
            switch (value.trim().toLowerCase()) {
                case "always_on": {
                    OpenTelemetryMetricsProperties.ExemplarFilter exemplarFilter2 = OpenTelemetryMetricsProperties.ExemplarFilter.ALWAYS_ON;
                    break;
                }
                case "always_off": {
                    OpenTelemetryMetricsProperties.ExemplarFilter exemplarFilter2 = OpenTelemetryMetricsProperties.ExemplarFilter.ALWAYS_OFF;
                    break;
                }
                case "trace_based": {
                    OpenTelemetryMetricsProperties.ExemplarFilter exemplarFilter2 = OpenTelemetryMetricsProperties.ExemplarFilter.TRACE_BASED;
                    break;
                }
                default: {
                    OpenTelemetryMetricsProperties.ExemplarFilter exemplarFilter2 = exemplarFilter = null;
                }
            }
            if (exemplarFilter == null) {
                logger.warn("Unsupported value for {}: {}", (Object)externalKey, value);
                return null;
            }
            return exemplarFilter;
        };
    }
}

