/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.sdk.exporter;

import io.arconia.opentelemetry.autoconfigure.sdk.exporter.otlp.Compression;
import io.arconia.opentelemetry.autoconfigure.sdk.exporter.otlp.Protocol;
import io.opentelemetry.sdk.common.export.MemoryMode;
import java.net.URI;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="arconia.otel.exporter")
public class OpenTelemetryExporterProperties {
    public static final String CONFIG_PREFIX = "arconia.otel.exporter";
    private final Otlp otlp = new Otlp();
    private MemoryMode memoryMode = MemoryMode.REUSABLE_DATA;

    public Otlp getOtlp() {
        return this.otlp;
    }

    public MemoryMode getMemoryMode() {
        return this.memoryMode;
    }

    public void setMemoryMode(MemoryMode memoryMode) {
        this.memoryMode = memoryMode;
    }

    public static class Otlp {
        private @Nullable URI endpoint;
        private Duration timeout = Duration.ofSeconds(10L);
        private Duration connectTimeout = Duration.ofSeconds(10L);
        private Protocol protocol = Protocol.HTTP_PROTOBUF;
        private Compression compression = Compression.GZIP;
        private Map<String, String> headers = new HashMap<String, String>();
        private boolean metrics = false;

        public @Nullable URI getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(URI endpoint) {
            this.endpoint = endpoint;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }

        public Duration getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public Protocol getProtocol() {
            return this.protocol;
        }

        public void setProtocol(Protocol protocol) {
            this.protocol = protocol;
        }

        public Compression getCompression() {
            return this.compression;
        }

        public void setCompression(Compression compression) {
            this.compression = compression;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }

        public boolean isMetrics() {
            return this.metrics;
        }

        public void setMetrics(boolean metrics) {
            this.metrics = metrics;
        }
    }
}

