/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.sdk.logs;

import io.arconia.opentelemetry.autoconfigure.sdk.logs.ConditionalOnOpenTelemetryLogging;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

class OnOpenTelemetryLoggingCondition
extends SpringBootCondition {
    OnOpenTelemetryLoggingCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Boolean openTelemetryLogsEnabled = (Boolean)context.getEnvironment().getProperty("arconia.otel.logs.enabled", Boolean.class);
        if (openTelemetryLogsEnabled != null) {
            return new ConditionOutcome(openTelemetryLogsEnabled.booleanValue(), ConditionMessage.forCondition(ConditionalOnOpenTelemetryLogging.class, (Object[])new Object[0]).because("arconia.otel.logs.enabled is " + openTelemetryLogsEnabled));
        }
        return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryLogging.class, (Object[])new Object[0]).because("OpenTelemetry Logs are enabled by default"));
    }
}

