/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.sdk.metrics;

import io.arconia.opentelemetry.autoconfigure.sdk.metrics.ConditionalOnOpenTelemetryMetrics;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

class OnOpenTelemetryMetricsCondition
extends SpringBootCondition {
    OnOpenTelemetryMetricsCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Boolean openTelemetryMetricsEnabled = (Boolean)context.getEnvironment().getProperty("arconia.otel.metrics.enabled", Boolean.class);
        if (openTelemetryMetricsEnabled != null) {
            return new ConditionOutcome(openTelemetryMetricsEnabled.booleanValue(), ConditionMessage.forCondition(ConditionalOnOpenTelemetryMetrics.class, (Object[])new Object[0]).because("arconia.otel.metrics.enabled is " + openTelemetryMetricsEnabled));
        }
        return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryMetrics.class, (Object[])new Object[0]).because("OpenTelemetry Metrics are enabled by default"));
    }
}

