/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.sdk.metrics.exporter.otlp;

import io.arconia.opentelemetry.autoconfigure.sdk.exporter.OpenTelemetryExporterProperties;
import io.arconia.opentelemetry.autoconfigure.sdk.exporter.otlp.Protocol;
import io.arconia.opentelemetry.autoconfigure.sdk.metrics.SdkMeterProviderBuilderCustomizer;
import io.arconia.opentelemetry.autoconfigure.sdk.metrics.exporter.AggregationTemporalityStrategy;
import io.arconia.opentelemetry.autoconfigure.sdk.metrics.exporter.HistogramAggregationStrategy;
import io.arconia.opentelemetry.autoconfigure.sdk.metrics.exporter.OpenTelemetryMetricsExporterProperties;
import io.arconia.opentelemetry.autoconfigure.sdk.metrics.exporter.otlp.OtlpMetricsConnectionDetails;
import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter;
import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporterBuilder;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.ViewBuilder;
import io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import io.opentelemetry.sdk.metrics.internal.view.Base2ExponentialHistogramAggregation;
import io.opentelemetry.sdk.metrics.internal.view.ExplicitBucketHistogramAggregation;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={OtlpHttpMetricExporter.class})
@ConditionalOnProperty(prefix="arconia.otel.metrics.exporter", name={"type"}, havingValue="otlp", matchIfMissing=true)
public class OtlpMetricsExporterConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(OtlpMetricsExporterConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={OtlpMetricsConnectionDetails.class})
    PropertiesOtlpMetricsConnectionDetails otlpMetricsConnectionDetails(OpenTelemetryExporterProperties commonProperties, OpenTelemetryMetricsExporterProperties properties) {
        return new PropertiesOtlpMetricsConnectionDetails(commonProperties, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={OtlpMetricsConnectionDetails.class})
    @ConditionalOnProperty(prefix="arconia.otel.metrics.exporter.otlp", name={"protocol"}, havingValue="http_protobuf", matchIfMissing=true)
    OtlpHttpMetricExporter otlpHttpMetricExporter(OpenTelemetryExporterProperties commonProperties, OpenTelemetryMetricsExporterProperties properties, OtlpMetricsConnectionDetails connectionDetails) {
        OtlpHttpMetricExporterBuilder builder = OtlpHttpMetricExporter.builder().setEndpoint(connectionDetails.getUrl(Protocol.HTTP_PROTOBUF)).setTimeout(properties.getOtlp().getTimeout() != null ? properties.getOtlp().getTimeout() : commonProperties.getOtlp().getTimeout()).setConnectTimeout(properties.getOtlp().getConnectTimeout() != null ? properties.getOtlp().getConnectTimeout() : commonProperties.getOtlp().getConnectTimeout()).setCompression(properties.getOtlp().getCompression() != null ? properties.getOtlp().getCompression().name().toLowerCase(Locale.ROOT) : commonProperties.getOtlp().getCompression().name().toLowerCase(Locale.ROOT)).setAggregationTemporalitySelector(this.getAggregationTemporalitySelector(properties)).setMemoryMode(commonProperties.getMemoryMode());
        commonProperties.getOtlp().getHeaders().forEach((arg_0, arg_1) -> ((OtlpHttpMetricExporterBuilder)builder).addHeader(arg_0, arg_1));
        properties.getOtlp().getHeaders().forEach((arg_0, arg_1) -> ((OtlpHttpMetricExporterBuilder)builder).addHeader(arg_0, arg_1));
        logger.info("Configuring OpenTelemetry HTTP/Protobuf metric exporter with endpoint: {}", (Object)connectionDetails.getUrl(Protocol.HTTP_PROTOBUF));
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={OtlpMetricsConnectionDetails.class})
    @ConditionalOnProperty(prefix="arconia.otel.metrics.exporter.otlp", name={"protocol"}, havingValue="grpc")
    OtlpGrpcMetricExporter otlpGrpcMetricExporter(OpenTelemetryExporterProperties commonProperties, OpenTelemetryMetricsExporterProperties properties, OtlpMetricsConnectionDetails connectionDetails) {
        OtlpGrpcMetricExporterBuilder builder = OtlpGrpcMetricExporter.builder().setEndpoint(connectionDetails.getUrl(Protocol.GRPC)).setTimeout(properties.getOtlp().getTimeout() != null ? properties.getOtlp().getTimeout() : commonProperties.getOtlp().getTimeout()).setConnectTimeout(properties.getOtlp().getConnectTimeout() != null ? properties.getOtlp().getConnectTimeout() : commonProperties.getOtlp().getConnectTimeout()).setCompression(properties.getOtlp().getCompression() != null ? properties.getOtlp().getCompression().name().toLowerCase(Locale.ROOT) : commonProperties.getOtlp().getCompression().name().toLowerCase(Locale.ROOT)).setAggregationTemporalitySelector(this.getAggregationTemporalitySelector(properties)).setMemoryMode(commonProperties.getMemoryMode());
        commonProperties.getOtlp().getHeaders().forEach((arg_0, arg_1) -> ((OtlpGrpcMetricExporterBuilder)builder).addHeader(arg_0, arg_1));
        properties.getOtlp().getHeaders().forEach((arg_0, arg_1) -> ((OtlpGrpcMetricExporterBuilder)builder).addHeader(arg_0, arg_1));
        logger.info("Configuring OpenTelemetry gRPC metric exporter with endpoint: {}", (Object)connectionDetails.getUrl(Protocol.GRPC));
        return builder.build();
    }

    AggregationTemporalitySelector getAggregationTemporalitySelector(OpenTelemetryMetricsExporterProperties properties) {
        return switch (properties.getAggregationTemporality()) {
            default -> throw new MatchException(null, null);
            case AggregationTemporalityStrategy.CUMULATIVE -> AggregationTemporalitySelector.alwaysCumulative();
            case AggregationTemporalityStrategy.DELTA -> AggregationTemporalitySelector.deltaPreferred();
            case AggregationTemporalityStrategy.LOW_MEMORY -> AggregationTemporalitySelector.lowMemory();
        };
    }

    @Bean
    SdkMeterProviderBuilderCustomizer histogramAggregation(OpenTelemetryMetricsExporterProperties properties) {
        return builder -> {
            InstrumentSelector instrumentSelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).build();
            ViewBuilder viewBuilder = View.builder();
            builder.registerView(instrumentSelector, viewBuilder.setAggregation(switch (properties.getHistogramAggregation()) {
                default -> throw new MatchException(null, null);
                case HistogramAggregationStrategy.BASE2_EXPONENTIAL_BUCKET_HISTOGRAM -> Base2ExponentialHistogramAggregation.getDefault();
                case HistogramAggregationStrategy.EXPLICIT_BUCKET_HISTOGRAM -> ExplicitBucketHistogramAggregation.getDefault();
            }).build());
        };
    }

    static class PropertiesOtlpMetricsConnectionDetails
    implements OtlpMetricsConnectionDetails {
        private final OpenTelemetryExporterProperties commonProperties;
        private final OpenTelemetryMetricsExporterProperties properties;

        public PropertiesOtlpMetricsConnectionDetails(OpenTelemetryExporterProperties commonProperties, OpenTelemetryMetricsExporterProperties properties) {
            this.commonProperties = commonProperties;
            this.properties = properties;
        }

        @Override
        public String getUrl(Protocol protocol) {
            Protocol protocolProperty = this.properties.getOtlp().getProtocol() != null ? this.properties.getOtlp().getProtocol() : this.commonProperties.getOtlp().getProtocol();
            Assert.state((protocol == protocolProperty ? 1 : 0) != 0, (String)"Requested protocol %s doesn't match configured protocol %s".formatted(new Object[]{protocol, protocolProperty}));
            String url = this.properties.getOtlp().getEndpoint() != null ? this.properties.getOtlp().getEndpoint().toString() : (this.commonProperties.getOtlp().getEndpoint() != null ? (protocolProperty == Protocol.HTTP_PROTOBUF ? this.commonProperties.getOtlp().getEndpoint().resolve("/v1/metrics").toString() : this.commonProperties.getOtlp().getEndpoint().toString()) : (protocolProperty == Protocol.HTTP_PROTOBUF ? "http://localhost:4318/v1/metrics" : "http://localhost:4317"));
            return url;
        }
    }
}

