/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.sdk.resource.contributor;

import io.arconia.core.support.Internal;
import io.arconia.opentelemetry.autoconfigure.sdk.resource.OpenTelemetryResourceProperties;
import io.arconia.opentelemetry.autoconfigure.sdk.resource.contributor.ResourceContributor;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import io.opentelemetry.semconv.ServiceAttributes;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.SpringBootVersion;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@Internal
public class EnvironmentResourceContributor
implements ResourceContributor {
    public static final AttributeKey<String> SERVICE_INSTANCE_ID = AttributeKey.stringKey((String)"service.instance.id");
    public static final AttributeKey<String> SERVICE_NAMESPACE = AttributeKey.stringKey((String)"service.namespace");
    public static final AttributeKey<String> WEBENGINE_NAME = AttributeKey.stringKey((String)"webengine.name");
    public static final AttributeKey<String> WEBENGINE_VERSION = AttributeKey.stringKey((String)"webengine.version");
    private static final String DEFAULT_SERVICE_INSTANCE_ID = UUID.randomUUID().toString();
    private static final String DEFAULT_SERVICE_NAME = "unknown_service:java";
    private static final String SPRING_BOOT_NAME = "Spring Boot";
    private final Environment environment;
    private final OpenTelemetryResourceProperties properties;

    public EnvironmentResourceContributor(Environment environment, OpenTelemetryResourceProperties properties) {
        this.environment = environment;
        this.properties = properties;
    }

    @Override
    public void contribute(ResourceBuilder builder) {
        builder.putAll(this.computeAttributes());
        builder.put(ServiceAttributes.SERVICE_NAME, (Object)this.computeServiceName());
        String serviceNamespace = this.computeServiceNamespace();
        if (StringUtils.hasText((String)serviceNamespace)) {
            builder.put(SERVICE_NAMESPACE, (Object)serviceNamespace);
        }
        String serviceInstanceId = this.computeServiceInstanceId();
        builder.put(SERVICE_INSTANCE_ID, (Object)serviceInstanceId);
        builder.put(WEBENGINE_NAME, (Object)SPRING_BOOT_NAME);
        builder.put(WEBENGINE_VERSION, (Object)SpringBootVersion.getVersion());
    }

    private Attributes computeAttributes() {
        Map<AttributeKey, String> attributesMap = this.properties.getAttributes().entrySet().stream().map(e -> Map.entry((String)e.getKey(), URLDecoder.decode((String)e.getValue(), StandardCharsets.UTF_8))).collect(Collectors.toMap(e -> AttributeKey.stringKey((String)((String)e.getKey())), Map.Entry::getValue));
        AttributesBuilder attributesBuilder = Attributes.builder();
        attributesMap.forEach((arg_0, arg_1) -> ((AttributesBuilder)attributesBuilder).put(arg_0, arg_1));
        return attributesBuilder.build();
    }

    private String computeServiceName() {
        String serviceName = this.properties.getServiceName();
        if (!StringUtils.hasText((String)serviceName)) {
            serviceName = this.properties.getAttributes().get(ServiceAttributes.SERVICE_NAME.getKey());
        }
        if (!StringUtils.hasText((String)serviceName)) {
            serviceName = this.environment.getProperty("spring.application.name", DEFAULT_SERVICE_NAME);
        }
        return serviceName;
    }

    private @Nullable String computeServiceNamespace() {
        String serviceNamespace = this.properties.getAttributes().get(SERVICE_NAMESPACE.getKey());
        if (!StringUtils.hasText((String)serviceNamespace)) {
            serviceNamespace = this.environment.getProperty("spring.application.group");
        }
        return serviceNamespace;
    }

    private String computeServiceInstanceId() {
        String serviceInstanceId = this.properties.getAttributes().get(SERVICE_INSTANCE_ID.getKey());
        if (!StringUtils.hasText((String)serviceInstanceId)) {
            serviceInstanceId = DEFAULT_SERVICE_INSTANCE_ID;
        }
        return serviceInstanceId;
    }
}

