/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.sdk.resource.contributor;

import io.arconia.core.support.Internal;
import io.arconia.opentelemetry.autoconfigure.sdk.resource.contributor.ResourceContributor;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import org.springframework.boot.info.OsInfo;
import org.springframework.util.StringUtils;

@Internal
public class OsResourceContributor
implements ResourceContributor {
    public static final AttributeKey<String> OS_DESCRIPTION = AttributeKey.stringKey((String)"os.description");
    public static final AttributeKey<String> OS_NAME = AttributeKey.stringKey((String)"os.name");
    public static final AttributeKey<String> OS_TYPE = AttributeKey.stringKey((String)"os.type");
    public static final AttributeKey<String> OS_VERSION = AttributeKey.stringKey((String)"os.version");
    public static final AttributeKey<String> OS_ARCH = AttributeKey.stringKey((String)"os.arch");
    private final OsInfo osInfo = new OsInfo();

    @Override
    public void contribute(ResourceBuilder builder) {
        if (StringUtils.hasText((String)this.osInfo.getArch())) {
            builder.put(OS_ARCH, (Object)this.osInfo.getArch());
        }
        if (StringUtils.hasText((String)this.osInfo.getName())) {
            builder.put(OS_NAME, (Object)this.osInfo.getName());
        }
        if (StringUtils.hasText((String)this.osInfo.getName())) {
            builder.put(OS_TYPE, (Object)this.computeOsType(this.osInfo.getName()));
        }
        if (StringUtils.hasText((String)this.osInfo.getVersion())) {
            builder.put(OS_VERSION, (Object)this.osInfo.getVersion());
        }
        if (StringUtils.hasText((String)this.osInfo.getName()) && StringUtils.hasText((String)this.osInfo.getVersion()) && StringUtils.hasText((String)this.osInfo.getArch())) {
            builder.put(OS_DESCRIPTION, (Object)"%s [Version: %s, Architecture: %s]".formatted(this.osInfo.getName(), this.osInfo.getVersion(), this.osInfo.getArch()));
        } else if (StringUtils.hasText((String)this.osInfo.getName()) && StringUtils.hasText((String)this.osInfo.getVersion())) {
            builder.put(OS_DESCRIPTION, (Object)"%s [Version: %s]".formatted(this.osInfo.getName(), this.osInfo.getVersion()));
        } else if (StringUtils.hasText((String)this.osInfo.getName())) {
            builder.put(OS_DESCRIPTION, (Object)this.osInfo.getName());
        }
    }

    private String computeOsType(String osName) {
        String os = osName.toLowerCase().trim();
        if (os.contains(OsType.AIX.getMatcher())) {
            return OsType.AIX.getValue();
        }
        if (os.contains(OsType.DARWIN.getMatcher())) {
            return OsType.DARWIN.getValue();
        }
        if (os.contains(OsType.DRAGONFLYBSD.getMatcher())) {
            return OsType.DRAGONFLYBSD.getValue();
        }
        if (os.contains(OsType.FREEBSD.getMatcher())) {
            return OsType.FREEBSD.getValue();
        }
        if (os.contains(OsType.HPUX.getMatcher())) {
            return OsType.HPUX.getValue();
        }
        if (os.contains(OsType.LINUX.getMatcher())) {
            return OsType.LINUX.getValue();
        }
        if (os.contains(OsType.NETBSD.getMatcher())) {
            return OsType.NETBSD.getValue();
        }
        if (os.contains(OsType.OPENBSD.getMatcher())) {
            return OsType.OPENBSD.getValue();
        }
        if (os.contains(OsType.SOLARIS.getMatcher())) {
            return OsType.SOLARIS.getValue();
        }
        if (os.contains(OsType.WINDOWS.getMatcher())) {
            return OsType.WINDOWS.getValue();
        }
        if (os.contains(OsType.Z_OS.getMatcher())) {
            return OsType.Z_OS.getValue();
        }
        return osName;
    }

    static enum OsType {
        AIX("aix", "aix"),
        DARWIN("darwin", "mac"),
        DRAGONFLYBSD("dragonflybsd", "dragonfly"),
        FREEBSD("freebsd", "freebsd"),
        HPUX("hpux", "hp-ux"),
        LINUX("linux", "linux"),
        NETBSD("netbsd", "netbsd"),
        OPENBSD("openbsd", "openbsd"),
        SOLARIS("solaris", "solaris"),
        WINDOWS("windows", "windows"),
        Z_OS("z_os", "z/os");

        private final String value;
        private final String matcher;

        private OsType(String value, String matcher) {
            this.value = value;
            this.matcher = matcher;
        }

        public String getValue() {
            return this.value;
        }

        public String getMatcher() {
            return this.matcher;
        }
    }
}

