/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.sdk.resource.contributor;

import io.arconia.core.support.Internal;
import io.arconia.opentelemetry.autoconfigure.sdk.resource.contributor.ResourceContributor;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import org.springframework.boot.info.ProcessInfo;
import org.springframework.util.StringUtils;

@Internal
public class ProcessResourceContributor
implements ResourceContributor {
    public static final AttributeKey<String> PROCESS_OWNER = AttributeKey.stringKey((String)"process.owner");
    public static final AttributeKey<Long> PROCESS_PARENT_PID = AttributeKey.longKey((String)"process.parent_pid");
    public static final AttributeKey<Long> PROCESS_PID = AttributeKey.longKey((String)"process.pid");
    private final ProcessInfo processInfo = new ProcessInfo();

    @Override
    public void contribute(ResourceBuilder builder) {
        if (StringUtils.hasText((String)this.processInfo.getOwner())) {
            builder.put(PROCESS_OWNER, (Object)this.processInfo.getOwner());
        }
        builder.put(PROCESS_PARENT_PID, (Object)this.processInfo.getParentPid());
        builder.put(PROCESS_PID, (Object)this.processInfo.getPid());
    }
}

