/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.sdk.traces;

import io.arconia.opentelemetry.autoconfigure.sdk.traces.ConditionalOnOpenTelemetryTracing;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

class OnOpenTelemetryTracingCondition
extends SpringBootCondition {
    private static final String TRACING_ENABLED_PROPERTY = "management.tracing.enabled";

    OnOpenTelemetryTracingCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Boolean openTelemetryTracesEnabled = (Boolean)context.getEnvironment().getProperty("arconia.otel.traces.enabled", Boolean.class);
        Boolean tracingEnabled = (Boolean)context.getEnvironment().getProperty(TRACING_ENABLED_PROPERTY, Boolean.class);
        if (openTelemetryTracesEnabled != null && tracingEnabled != null) {
            return new ConditionOutcome(openTelemetryTracesEnabled != false && tracingEnabled != false, ConditionMessage.forCondition(ConditionalOnOpenTelemetryTracing.class, (Object[])new Object[0]).because("arconia.otel.traces.enabled is " + openTelemetryTracesEnabled).append("management.tracing.enabled is " + tracingEnabled));
        }
        return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalOnOpenTelemetryTracing.class, (Object[])new Object[0]).because("OpenTelemetry tracing is enabled by default"));
    }
}

