/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.sdk.traces;

import io.arconia.opentelemetry.autoconfigure.sdk.traces.ConditionalOnOpenTelemetryTracing;
import io.arconia.opentelemetry.autoconfigure.sdk.traces.OpenTelemetryTracingProperties;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanLimits;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.actuate.autoconfigure.tracing.SdkTracerProviderBuilderCustomizer;
import org.springframework.boot.actuate.autoconfigure.tracing.TracingProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={org.springframework.boot.actuate.autoconfigure.tracing.OpenTelemetryTracingAutoConfiguration.class})
@ConditionalOnClass(value={SdkTracerProvider.class})
@ConditionalOnOpenTelemetryTracing
@EnableConfigurationProperties(value={OpenTelemetryTracingProperties.class})
public class OpenTelemetryTracingAutoConfiguration {
    public static final String INSTRUMENTATION_SCOPE_NAME = "org.springframework.boot";

    @Bean
    @ConditionalOnMissingBean
    SdkTracerProvider tracerProvider(Clock clock, Resource resource, Sampler sampler, SpanLimits spanLimits, ObjectProvider<SpanProcessor> spanProcessors, ObjectProvider<SdkTracerProviderBuilderCustomizer> customizers) {
        SdkTracerProviderBuilder builder = SdkTracerProvider.builder().setResource(resource).setSampler(sampler).setClock(clock).setSpanLimits(spanLimits);
        spanProcessors.orderedStream().forEach(arg_0 -> ((SdkTracerProviderBuilder)builder).addSpanProcessor(arg_0));
        customizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    Sampler sampler(OpenTelemetryTracingProperties properties, TracingProperties tracingProperties) {
        return switch (properties.getSampling().getStrategy()) {
            default -> throw new MatchException(null, null);
            case OpenTelemetryTracingProperties.SamplingStrategy.ALWAYS_ON -> Sampler.alwaysOn();
            case OpenTelemetryTracingProperties.SamplingStrategy.ALWAYS_OFF -> Sampler.alwaysOff();
            case OpenTelemetryTracingProperties.SamplingStrategy.TRACE_ID_RATIO -> Sampler.traceIdRatioBased((double)tracingProperties.getSampling().getProbability());
            case OpenTelemetryTracingProperties.SamplingStrategy.PARENT_BASED_ALWAYS_ON -> Sampler.parentBased((Sampler)Sampler.alwaysOn());
            case OpenTelemetryTracingProperties.SamplingStrategy.PARENT_BASED_ALWAYS_OFF -> Sampler.parentBased((Sampler)Sampler.alwaysOff());
            case OpenTelemetryTracingProperties.SamplingStrategy.PARENT_BASED_TRACE_ID_RATIO -> Sampler.parentBased((Sampler)Sampler.traceIdRatioBased((double)tracingProperties.getSampling().getProbability()));
        };
    }

    @Bean
    @ConditionalOnMissingBean
    SpanLimits spanLimits(OpenTelemetryTracingProperties properties) {
        return SpanLimits.builder().setMaxNumberOfAttributes(properties.getSpanLimits().getMaxNumberOfAttributes()).setMaxNumberOfEvents(properties.getSpanLimits().getMaxNumberOfEvents()).setMaxNumberOfLinks(properties.getSpanLimits().getMaxNumberOfLinks()).setMaxNumberOfAttributesPerEvent(properties.getSpanLimits().getMaxNumberOfAttributesPerEvent()).setMaxNumberOfAttributesPerLink(properties.getSpanLimits().getMaxNumberOfAttributesPerLink()).setMaxAttributeValueLength(properties.getSpanLimits().getMaxAttributeValueLength()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    ContextPropagators contextPropagators(ObjectProvider<TextMapPropagator> textMapPropagators) {
        return ContextPropagators.create((TextMapPropagator)TextMapPropagator.composite(textMapPropagators.orderedStream().toList()));
    }

    @Bean
    @ConditionalOnMissingBean
    Tracer otelTracer(OpenTelemetry openTelemetry) {
        return openTelemetry.getTracer(INSTRUMENTATION_SCOPE_NAME, SpringBootVersion.getVersion());
    }
}

