/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.opentelemetry.autoconfigure.sdk.traces.exporter.otlp;

import io.arconia.opentelemetry.autoconfigure.sdk.exporter.OpenTelemetryExporterProperties;
import io.arconia.opentelemetry.autoconfigure.sdk.exporter.otlp.Protocol;
import io.arconia.opentelemetry.autoconfigure.sdk.traces.exporter.OpenTelemetryTracingExporterProperties;
import io.arconia.opentelemetry.autoconfigure.sdk.traces.exporter.otlp.OtlpTracingConnectionDetails;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={OtlpHttpSpanExporter.class})
@ConditionalOnProperty(prefix="arconia.otel.traces.exporter", name={"type"}, havingValue="otlp", matchIfMissing=true)
public class OtlpTracingExporterConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(OtlpTracingExporterConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={OtlpTracingConnectionDetails.class})
    PropertiesOtlpTracingConnectionDetails otlpTracingConnectionDetails(OpenTelemetryExporterProperties commonProperties, OpenTelemetryTracingExporterProperties properties) {
        return new PropertiesOtlpTracingConnectionDetails(commonProperties, properties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={OtlpTracingConnectionDetails.class})
    @ConditionalOnProperty(prefix="arconia.otel.traces.exporter.otlp", name={"protocol"}, havingValue="http_protobuf", matchIfMissing=true)
    OtlpHttpSpanExporter otlpHttpSpanExporter(OpenTelemetryExporterProperties commonProperties, OpenTelemetryTracingExporterProperties properties, OtlpTracingConnectionDetails connectionDetails, ObjectProvider<MeterProvider> meterProvider) {
        OtlpHttpSpanExporterBuilder builder;
        block3: {
            block2: {
                builder = OtlpHttpSpanExporter.builder().setEndpoint(connectionDetails.getUrl(Protocol.HTTP_PROTOBUF)).setTimeout(properties.getOtlp().getTimeout() != null ? properties.getOtlp().getTimeout() : commonProperties.getOtlp().getTimeout()).setConnectTimeout(properties.getOtlp().getConnectTimeout() != null ? properties.getOtlp().getConnectTimeout() : commonProperties.getOtlp().getConnectTimeout()).setCompression(properties.getOtlp().getCompression() != null ? properties.getOtlp().getCompression().name().toLowerCase(Locale.ROOT) : commonProperties.getOtlp().getCompression().name().toLowerCase(Locale.ROOT)).setMemoryMode(commonProperties.getMemoryMode());
                commonProperties.getOtlp().getHeaders().forEach((arg_0, arg_1) -> ((OtlpHttpSpanExporterBuilder)builder).addHeader(arg_0, arg_1));
                properties.getOtlp().getHeaders().forEach((arg_0, arg_1) -> ((OtlpHttpSpanExporterBuilder)builder).addHeader(arg_0, arg_1));
                if (properties.getOtlp().isMetrics() != null && Boolean.TRUE.equals(properties.getOtlp().isMetrics())) break block2;
                if (properties.getOtlp().isMetrics() != null || !commonProperties.getOtlp().isMetrics()) break block3;
            }
            meterProvider.ifAvailable(arg_0 -> ((OtlpHttpSpanExporterBuilder)builder).setMeterProvider(arg_0));
        }
        logger.info("Configuring OpenTelemetry HTTP/Protobuf span exporter with endpoint: {}", (Object)connectionDetails.getUrl(Protocol.HTTP_PROTOBUF));
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={OtlpTracingConnectionDetails.class})
    @ConditionalOnProperty(prefix="arconia.otel.traces.exporter.otlp", name={"protocol"}, havingValue="grpc")
    OtlpGrpcSpanExporter otlpGrpcSpanExporter(OpenTelemetryExporterProperties commonProperties, OpenTelemetryTracingExporterProperties properties, OtlpTracingConnectionDetails connectionDetails, ObjectProvider<MeterProvider> meterProvider) {
        OtlpGrpcSpanExporterBuilder builder;
        block3: {
            block2: {
                builder = OtlpGrpcSpanExporter.builder().setEndpoint(connectionDetails.getUrl(Protocol.GRPC)).setTimeout(properties.getOtlp().getTimeout() != null ? properties.getOtlp().getTimeout() : commonProperties.getOtlp().getTimeout()).setConnectTimeout(properties.getOtlp().getConnectTimeout() != null ? properties.getOtlp().getConnectTimeout() : commonProperties.getOtlp().getConnectTimeout()).setCompression(properties.getOtlp().getCompression() != null ? properties.getOtlp().getCompression().name().toLowerCase(Locale.ROOT) : commonProperties.getOtlp().getCompression().name().toLowerCase(Locale.ROOT)).setMemoryMode(commonProperties.getMemoryMode());
                commonProperties.getOtlp().getHeaders().forEach((arg_0, arg_1) -> ((OtlpGrpcSpanExporterBuilder)builder).addHeader(arg_0, arg_1));
                properties.getOtlp().getHeaders().forEach((arg_0, arg_1) -> ((OtlpGrpcSpanExporterBuilder)builder).addHeader(arg_0, arg_1));
                if (properties.getOtlp().isMetrics() != null && Boolean.TRUE.equals(properties.getOtlp().isMetrics())) break block2;
                if (properties.getOtlp().isMetrics() != null || !commonProperties.getOtlp().isMetrics()) break block3;
            }
            meterProvider.ifAvailable(arg_0 -> ((OtlpGrpcSpanExporterBuilder)builder).setMeterProvider(arg_0));
        }
        logger.info("Configuring OpenTelemetry gRPC span exporter with endpoint: {}", (Object)connectionDetails.getUrl(Protocol.GRPC));
        return builder.build();
    }

    static class PropertiesOtlpTracingConnectionDetails
    implements OtlpTracingConnectionDetails {
        private final OpenTelemetryExporterProperties commonProperties;
        private final OpenTelemetryTracingExporterProperties properties;

        public PropertiesOtlpTracingConnectionDetails(OpenTelemetryExporterProperties commonProperties, OpenTelemetryTracingExporterProperties properties) {
            this.commonProperties = commonProperties;
            this.properties = properties;
        }

        @Override
        public String getUrl(Protocol protocol) {
            Protocol protocolProperty = this.properties.getOtlp().getProtocol() != null ? this.properties.getOtlp().getProtocol() : this.commonProperties.getOtlp().getProtocol();
            Assert.state((protocol == protocolProperty ? 1 : 0) != 0, (String)"Requested protocol %s doesn't match configured protocol %s".formatted(new Object[]{protocol, protocolProperty}));
            String url = this.properties.getOtlp().getEndpoint() != null ? this.properties.getOtlp().getEndpoint().toString() : (this.commonProperties.getOtlp().getEndpoint() != null ? (protocolProperty == Protocol.HTTP_PROTOBUF ? this.commonProperties.getOtlp().getEndpoint().resolve("/v1/traces").toString() : this.commonProperties.getOtlp().getEndpoint().toString()) : (protocolProperty == Protocol.HTTP_PROTOBUF ? "http://localhost:4318/v1/traces" : "http://localhost:4317"));
            return url;
        }
    }
}

