/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.boot.env;

import io.arconia.boot.env.ApplicationMode;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.config.ConfigDataEnvironmentPostProcessor;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ProfilesEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(ProfilesEnvironmentPostProcessor.class);

    ProfilesEnvironmentPostProcessor() {
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        Assert.notNull((Object)environment, (String)"environment cannot be null");
        Assert.notNull((Object)application, (String)"application cannot be null");
        Boolean profilesEnabled = (Boolean)environment.getProperty("arconia.config.profiles.enabled", Boolean.class, (Object)true);
        if (!profilesEnabled.booleanValue()) {
            return;
        }
        List currentProfiles = (List)environment.getProperty("spring.profiles.active", List.class, List.of());
        ArrayList<String> additionalProfiles = new ArrayList<String>();
        ApplicationMode mode = ApplicationMode.of(application);
        switch (mode) {
            case DEVELOPMENT: {
                List developmentProfiles = (List)environment.getProperty("arconia.config.profiles.development", List.class, List.of("dev"));
                if (developmentProfiles.isEmpty()) break;
                for (String profile : developmentProfiles) {
                    if (!StringUtils.hasText((String)profile) || currentProfiles.contains(profile)) continue;
                    logger.debug("Adding active profile '{}' for development mode", (Object)profile);
                    additionalProfiles.add(profile);
                }
                break;
            }
            case TEST: {
                List testProfiles = (List)environment.getProperty("arconia.config.profiles.test", List.class, List.of("test"));
                if (testProfiles.isEmpty()) break;
                for (String profile : testProfiles) {
                    if (!StringUtils.hasText((String)profile) || currentProfiles.contains(profile)) continue;
                    logger.debug("Adding active profile '{}' for test mode", (Object)profile);
                    additionalProfiles.add(profile);
                }
                break;
            }
            case PRODUCTION: {
                List productionProfiles = (List)environment.getProperty("arconia.config.profiles.production", List.class, List.of("prod"));
                if (productionProfiles.isEmpty()) break;
                for (String profile : productionProfiles) {
                    if (!StringUtils.hasText((String)profile) || currentProfiles.contains(profile)) continue;
                    logger.debug("Adding active profile '{}' for production mode", (Object)profile);
                    additionalProfiles.add(profile);
                }
                break;
            }
        }
        ConfigDataEnvironmentPostProcessor.applyTo((ConfigurableEnvironment)environment, (ResourceLoader)application.getResourceLoader(), null, additionalProfiles);
    }

    public int getOrder() {
        return -2147483633;
    }
}

