/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.rewrite.spring.ai;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class UseQuestionAnswerAdvisorBuilder
extends Recipe {
    private static final String FQN_QUESTION_ANSWER_ADVISOR = "org.springframework.ai.chat.client.advisor.vectorstore.QuestionAnswerAdvisor";
    private static final String FQN_VECTOR_STORE = "org.springframework.ai.vectorstore.VectorStore";
    private static final MethodMatcher QUESTION_ANSWER_ADVISOR_CONSTRUCTOR_MATCHER = new MethodMatcher("org.springframework.ai.chat.client.advisor.vectorstore.QuestionAnswerAdvisor <constructor>(*)");

    public String getDisplayName() {
        return "Use `QuestionAnswerAdvisor.Builder` instead of constructor";
    }

    public String getDescription() {
        return "Replace `new QuestionAnswerAdvisor(vectorStore)` with `QuestionAnswerAdvisor.builder(vectorStore).build()`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(QUESTION_ANSWER_ADVISOR_CONSTRUCTOR_MATCHER), (TreeVisitor)new QuestionAnswerAdvisorVisitor());
    }

    private static class QuestionAnswerAdvisorVisitor
    extends JavaVisitor<ExecutionContext> {
        private QuestionAnswerAdvisorVisitor() {
        }

        public J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
            J.NewClass nc = (J.NewClass)super.visitNewClass(newClass, (Object)ctx);
            if (!QUESTION_ANSWER_ADVISOR_CONSTRUCTOR_MATCHER.matches((MethodCall)nc)) {
                return nc;
            }
            if (nc.getArguments().size() != 1) {
                return nc;
            }
            Expression arg = (Expression)nc.getArguments().getFirst();
            if (!TypeUtils.isOfClassType((JavaType)arg.getType(), (String)UseQuestionAnswerAdvisorBuilder.FQN_VECTOR_STORE)) {
                return nc;
            }
            this.maybeAddImport(UseQuestionAnswerAdvisorBuilder.FQN_QUESTION_ANSWER_ADVISOR);
            return JavaTemplate.builder((String)"QuestionAnswerAdvisor.builder(#{any(org.springframework.ai.vectorstore.VectorStore)}).build()").imports(new String[]{UseQuestionAnswerAdvisorBuilder.FQN_QUESTION_ANSWER_ADVISOR}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"spring-ai-advisors-vector-store-1.1.+"})).build().apply(this.getCursor(), nc.getCoordinates().replace(), new Object[]{arg});
        }
    }
}

