/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.rewrite.spring.boot.boot4;

import java.util.Comparator;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class AddAutoConfigureTestRestTemplateAnnotation
extends Recipe {
    private static final String AUTO_CONFIGURE_TEST_REST_TEMPLATE = "AutoConfigureTestRestTemplate";
    private static final String FQN_AUTO_CONFIGURE_TEST_REST_TEMPLATE = "org.springframework.boot.resttestclient.autoconfigure.AutoConfigureTestRestTemplate";
    private static final String FQN_SPRING_BOOT_TEST = "org.springframework.boot.test.context.SpringBootTest";
    private static final String FQN_WEB_MVC_TEST = "org.springframework.boot.webmvc.test.autoconfigure.WebMvcTest";
    private static final String FQN_TEST_REST_TEMPLATE = "org.springframework.boot.resttestclient.TestRestTemplate";
    private static final AnnotationMatcher AUTO_CONFIGURE_TEST_REST_TEMPLATE_ANNOTATION_MATCHER = new AnnotationMatcher("@org.springframework.boot.resttestclient.autoconfigure.AutoConfigureTestRestTemplate", Boolean.valueOf(true));
    private static final AnnotationMatcher SPRING_BOOT_TEST_ANNOTATION_MATCHER = new AnnotationMatcher("@org.springframework.boot.test.context.SpringBootTest", Boolean.valueOf(true));
    private static final AnnotationMatcher WEB_MVC_TEST_ANNOTATION_MATCHER = new AnnotationMatcher("@org.springframework.boot.webmvc.test.autoconfigure.WebMvcTest", Boolean.valueOf(true));

    public String getDisplayName() {
        return "Add missing `@AutoConfigureTestRestTemplate` annotation";
    }

    public String getDescription() {
        return "Add missing `@AutoConfigureTestRestTemplate` annotation to classes annotated with `@SpringBootTest` or `@WebMvcTest` that use `TestRestTemplate`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(FQN_TEST_REST_TEMPLATE, Boolean.valueOf(false)), (TreeVisitor)new SpringBootTestVisitor());
    }

    private static class SpringBootTestVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private SpringBootTestVisitor() {
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration c = super.visitClassDeclaration(classDecl, (Object)ctx);
            if (this.isApplicableClass(c)) {
                c = this.addMissingAnnotation(c, ctx);
            }
            return c;
        }

        private J.ClassDeclaration addMissingAnnotation(J.ClassDeclaration c, ExecutionContext ctx) {
            this.maybeAddImport(AddAutoConfigureTestRestTemplateAnnotation.FQN_AUTO_CONFIGURE_TEST_REST_TEMPLATE);
            return (J.ClassDeclaration)JavaTemplate.builder((String)"@AutoConfigureTestRestTemplate").imports(new String[]{AddAutoConfigureTestRestTemplateAnnotation.FQN_AUTO_CONFIGURE_TEST_REST_TEMPLATE}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"spring-boot-resttestclient-4.0.*"})).build().apply(this.getCursor(), c.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
        }

        private boolean isApplicableClass(J.ClassDeclaration classDeclaration) {
            for (J.Annotation annotation : classDeclaration.getLeadingAnnotations()) {
                JavaType.FullyQualified annotationType = TypeUtils.asFullyQualified((JavaType)annotation.getType());
                if (annotationType == null || !AUTO_CONFIGURE_TEST_REST_TEMPLATE_ANNOTATION_MATCHER.matchesAnnotationOrMetaAnnotation(annotationType)) continue;
                return false;
            }
            for (J.Annotation annotation : classDeclaration.getLeadingAnnotations()) {
                JavaType.FullyQualified aType = TypeUtils.asFullyQualified((JavaType)annotation.getType());
                if (aType == null) continue;
                if (SPRING_BOOT_TEST_ANNOTATION_MATCHER.matchesAnnotationOrMetaAnnotation(aType)) {
                    return true;
                }
                if (!WEB_MVC_TEST_ANNOTATION_MATCHER.matchesAnnotationOrMetaAnnotation(aType)) continue;
                return true;
            }
            return false;
        }
    }
}

