/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.rewrite.spring.boot.properties;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.arconia.rewrite.spring.boot.properties.FindSpringBootConfigFiles;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.properties.ChangePropertyValue;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.yaml.tree.Yaml;

public class ChangeSpringBootPropertyValue
extends Recipe {
    @Option(displayName="Property key", description="The property key whose value must change.", example="arconia.dev.services.*.reusable")
    private final String propertyKey;
    @Option(displayName="Old property value", description="The property value to change.", required=false, example="true")
    private final @Nullable String oldPropertyValue;
    @Option(displayName="New property value", description="The new value for the property key.", example="always")
    private final String newPropertyValue;
    @Option(displayName="Use regular expressions to match the old value", description="Treats the old property value as a regular expression for matching.\nWhen enabled, only matching portions are replaced, and capture groups\ncan be referenced in the new value. Defaults to `false`.\n", required=false)
    private final @Nullable Boolean useRegex;
    @Option(displayName="Use relaxed binding", description="Whether to match the property key using Spring Boot relaxed binding rules. Defaults to `true`.", required=false)
    private final @Nullable Boolean relaxedBinding;
    @Option(displayName="Configuration files path matchers", description="Glob expressions to match Spring Boot configuration files to modify.\nDefaults to standard `application.yml`, `application.yaml`, and `application.properties` files (including profile-specific variants).\nMultiple patterns are OR-ed together.\n", required=false)
    private final @Nullable List<String> pathExpressions;

    @JsonCreator
    public ChangeSpringBootPropertyValue(String propertyKey, @Nullable String oldPropertyValue, String newPropertyValue, @Nullable Boolean useRegex, @Nullable Boolean relaxedBinding, @Nullable List<String> pathExpressions) {
        this.propertyKey = propertyKey;
        this.oldPropertyValue = oldPropertyValue;
        this.newPropertyValue = newPropertyValue;
        this.useRegex = useRegex;
        this.relaxedBinding = relaxedBinding;
        this.pathExpressions = pathExpressions;
    }

    public String getDisplayName() {
        return "Change the value of a Spring Boot configuration property key";
    }

    public String getDescription() {
        return "Change the value of a property in Spring Boot configuration files.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new FindSpringBootConfigFiles(this.pathExpressions).getVisitor(), (TreeVisitor)new ChangeSpringBootPropertyValueVisitor(this.propertyKey, this.oldPropertyValue, this.newPropertyValue, this.useRegex, this.relaxedBinding));
    }

    public boolean equals(@Nullable Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChangeSpringBootPropertyValue that = (ChangeSpringBootPropertyValue)((Object)o);
        return Objects.equals(this.propertyKey, that.propertyKey) && Objects.equals(this.oldPropertyValue, that.oldPropertyValue) && Objects.equals(this.newPropertyValue, that.newPropertyValue) && Objects.equals(this.useRegex, that.useRegex) && Objects.equals(this.relaxedBinding, that.relaxedBinding) && Objects.equals(this.pathExpressions, that.pathExpressions);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.propertyKey, this.oldPropertyValue, this.newPropertyValue, this.useRegex, this.relaxedBinding, this.pathExpressions);
    }

    public String toString() {
        return "ChangeSpringBootPropertyValue{propertyKey='" + this.propertyKey + "', oldPropertyValue='" + this.oldPropertyValue + "', newPropertyValue='" + this.newPropertyValue + "', useRegex=" + this.useRegex + ", relaxedBinding=" + this.relaxedBinding + ", pathExpressions=" + String.valueOf(this.pathExpressions) + "}";
    }

    private static class ChangeSpringBootPropertyValueVisitor
    extends TreeVisitor<Tree, ExecutionContext> {
        private final String propertyKey;
        private final @Nullable String oldPropertyValue;
        private final String newPropertyValue;
        private final @Nullable Boolean useRegex;
        private final @Nullable Boolean relaxedBinding;

        public ChangeSpringBootPropertyValueVisitor(String propertyKey, @Nullable String oldPropertyValue, String newPropertyValue, @Nullable Boolean useRegex, @Nullable Boolean relaxedBinding) {
            this.propertyKey = propertyKey;
            this.oldPropertyValue = oldPropertyValue;
            this.newPropertyValue = newPropertyValue;
            this.useRegex = useRegex;
            this.relaxedBinding = relaxedBinding;
        }

        public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree == null) {
                return null;
            }
            Tree tree2 = tree;
            Objects.requireNonNull(tree2);
            Tree tree3 = tree2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Yaml.Documents.class, Properties.File.class}, (Object)tree3, n)) {
                case 0 -> {
                    Yaml.Documents yamlTree = (Yaml.Documents)tree3;
                    yield this.getYamlVisitor().visit((Tree)yamlTree, (Object)ctx);
                }
                case 1 -> {
                    Properties.File propertiesTree = (Properties.File)tree3;
                    yield this.getPropertiesVisitor().visit((Tree)propertiesTree, (Object)ctx);
                }
                default -> tree;
            };
        }

        private TreeVisitor<?, ExecutionContext> getYamlVisitor() {
            org.openrewrite.yaml.ChangePropertyValue yamlRecipe = new org.openrewrite.yaml.ChangePropertyValue(this.propertyKey, this.newPropertyValue, this.oldPropertyValue, this.useRegex, Boolean.valueOf(!Boolean.FALSE.equals(this.relaxedBinding)), null);
            return yamlRecipe.getVisitor();
        }

        private TreeVisitor<?, ExecutionContext> getPropertiesVisitor() {
            ChangePropertyValue propertiesRecipe = new ChangePropertyValue(this.propertyKey, this.newPropertyValue, this.oldPropertyValue, this.useRegex, Boolean.valueOf(!Boolean.FALSE.equals(this.relaxedBinding)));
            return propertiesRecipe.getVisitor();
        }
    }
}

