/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.rewrite.spring.boot.properties;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.arconia.rewrite.spring.boot.properties.FindSpringBootConfigFiles;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.properties.AddPropertyComment;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.yaml.CommentOutProperty;
import org.openrewrite.yaml.tree.Yaml;

public class CommentSpringBootProperty
extends Recipe {
    @Option(displayName="Property key", description="The key for the property to comment.", example="spring.ai.ollama.chat.enabled")
    private final String propertyKey;
    @Option(displayName="Comment", description="The comment to add before the property key.", example="This property is deprecated and will be removed in future versions.")
    private final String comment;
    @Option(displayName="Comment out property", description="Whether to comment out the property. Defaults to `true`.", required=false)
    private final Boolean commentOutProperty;

    @JsonCreator
    public CommentSpringBootProperty(String propertyKey, String comment, @Nullable Boolean commentOutProperty) {
        this.propertyKey = propertyKey;
        this.comment = comment;
        this.commentOutProperty = commentOutProperty != null ? commentOutProperty : true;
    }

    public String getDisplayName() {
        return "Add a comment to a Spring Boot configuration property";
    }

    public String getDescription() {
        return "Add a comment to a property in Spring Boot configuration files. Optionally, comment out the property itself.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new FindSpringBootConfigFiles(null).getVisitor(), (TreeVisitor)new CommentSpringBootPropertyKeyVisitor(this.propertyKey, this.comment, this.commentOutProperty));
    }

    public boolean equals(@Nullable Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CommentSpringBootProperty that = (CommentSpringBootProperty)((Object)o);
        return Objects.equals(this.propertyKey, that.propertyKey) && Objects.equals(this.comment, that.comment) && Objects.equals(this.commentOutProperty, that.commentOutProperty);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.propertyKey, this.comment, this.commentOutProperty);
    }

    public String toString() {
        return "CommentSpringBootProperty{propertyKey='" + this.propertyKey + "', comment='" + this.comment + "', commentOutProperty=" + this.commentOutProperty + "}";
    }

    private static class CommentSpringBootPropertyKeyVisitor
    extends TreeVisitor<Tree, ExecutionContext> {
        private final String propertyKey;
        private final String comment;
        private final Boolean commentOutProperty;

        public CommentSpringBootPropertyKeyVisitor(String propertyKey, String comment, Boolean commentOutProperty) {
            this.propertyKey = propertyKey;
            this.comment = comment;
            this.commentOutProperty = commentOutProperty;
        }

        public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree == null) {
                return null;
            }
            Tree tree2 = tree;
            Objects.requireNonNull(tree2);
            Tree tree3 = tree2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Yaml.Documents.class, Properties.File.class}, (Object)tree3, n)) {
                case 0 -> {
                    Yaml.Documents yamlTree = (Yaml.Documents)tree3;
                    yield this.getYamlVisitor().visit((Tree)yamlTree, (Object)ctx);
                }
                case 1 -> {
                    Properties.File propertiesTree = (Properties.File)tree3;
                    yield this.getPropertiesVisitor().visit((Tree)propertiesTree, (Object)ctx);
                }
                default -> tree;
            };
        }

        private TreeVisitor<?, ExecutionContext> getYamlVisitor() {
            CommentOutProperty yamlRecipe = new CommentOutProperty(this.propertyKey, this.comment, this.commentOutProperty);
            return yamlRecipe.getVisitor();
        }

        private TreeVisitor<?, ExecutionContext> getPropertiesVisitor() {
            AddPropertyComment propertiesRecipe = new AddPropertyComment(this.propertyKey, this.comment, this.commentOutProperty);
            return propertiesRecipe.getVisitor();
        }
    }
}

