/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.rewrite.spring.boot.properties;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.arconia.rewrite.spring.boot.properties.FindSpringBootConfigFiles;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.yaml.DeleteProperty;
import org.openrewrite.yaml.tree.Yaml;

public class DeleteSpringBootProperty
extends Recipe {
    @Option(displayName="Property key", description="The key of the property to delete.", example="arconia.modes.name")
    private final String propertyKey;
    @Option(displayName="Use relaxed binding", description="Whether to match the property key using Spring Boot relaxed binding rules. Defaults to `true`.", required=false)
    private final @Nullable Boolean relaxedBinding;
    @Option(displayName="Configuration files path matchers", description="Glob expressions to match Spring Boot configuration files to modify.\nDefaults to standard `application.yml`, `application.yaml`, and `application.properties` files (including profile-specific variants).\nMultiple patterns are OR-ed together.\n", required=false)
    private final @Nullable List<String> pathExpressions;

    @JsonCreator
    public DeleteSpringBootProperty(String propertyKey, @Nullable Boolean relaxedBinding, @Nullable List<String> pathExpressions) {
        this.propertyKey = propertyKey;
        this.relaxedBinding = relaxedBinding;
        this.pathExpressions = pathExpressions;
    }

    public String getDisplayName() {
        return "Delete a Spring Boot configuration property";
    }

    public String getDescription() {
        return "Delete a property in Spring Boot configuration files.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new FindSpringBootConfigFiles(this.pathExpressions).getVisitor(), (TreeVisitor)new DeleteSpringBootPropertyKeyVisitor(this.propertyKey, this.relaxedBinding));
    }

    public boolean equals(@Nullable Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeleteSpringBootProperty that = (DeleteSpringBootProperty)((Object)o);
        return Objects.equals(this.propertyKey, that.propertyKey) && Objects.equals(this.relaxedBinding, that.relaxedBinding) && Objects.equals(this.pathExpressions, that.pathExpressions);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.propertyKey, this.relaxedBinding, this.pathExpressions);
    }

    public String toString() {
        return "DeleteSpringBootProperty{propertyKey='" + this.propertyKey + "', relaxedBinding=" + this.relaxedBinding + ", pathExpressions=" + String.valueOf(this.pathExpressions) + "}";
    }

    private static class DeleteSpringBootPropertyKeyVisitor
    extends TreeVisitor<Tree, ExecutionContext> {
        private final String propertyKey;
        private final @Nullable Boolean relaxedBinding;

        public DeleteSpringBootPropertyKeyVisitor(String propertyKey, @Nullable Boolean relaxedBinding) {
            this.propertyKey = propertyKey;
            this.relaxedBinding = relaxedBinding;
        }

        public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree == null) {
                return null;
            }
            Tree tree2 = tree;
            Objects.requireNonNull(tree2);
            Tree tree3 = tree2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Yaml.Documents.class, Properties.File.class}, (Object)tree3, n)) {
                case 0 -> {
                    Yaml.Documents yamlTree = (Yaml.Documents)tree3;
                    yield this.getYamlVisitor().visit((Tree)yamlTree, (Object)ctx);
                }
                case 1 -> {
                    Properties.File propertiesTree = (Properties.File)tree3;
                    yield this.getPropertiesVisitor().visit((Tree)propertiesTree, (Object)ctx);
                }
                default -> tree;
            };
        }

        private TreeVisitor<?, ExecutionContext> getYamlVisitor() {
            DeleteProperty yamlRecipe = new DeleteProperty(this.propertyKey, Boolean.valueOf(false), Boolean.valueOf(!Boolean.FALSE.equals(this.relaxedBinding)), null);
            return yamlRecipe.getVisitor();
        }

        private TreeVisitor<?, ExecutionContext> getPropertiesVisitor() {
            org.openrewrite.properties.DeleteProperty propertiesRecipe = new org.openrewrite.properties.DeleteProperty(this.propertyKey, Boolean.valueOf(!Boolean.FALSE.equals(this.relaxedBinding)));
            return propertiesRecipe.getVisitor();
        }
    }
}

