/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.rewrite.spring.boot.properties;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;

public class FindSpringBootConfigFiles
extends Recipe {
    private static final List<String> DEFAULT_PATH_EXPRESSIONS = List.of("**/application.yml", "**/application.yaml", "**/application.properties", "**/application-*.yml", "**/application-*.yaml", "**/application-*.properties");
    @Option(displayName="Configuration files path matchers", description="A list of glob expressions used to match which files contain Spring Boot configuration properties\nand therefore will be modified. If no value is provided, default expressions will be used to match\nthe main YAML and Properties files supported by Spring Boot for configuration.\nIf multiple patterns are supplied, any of the patterns matching will be interpreted as a match.\n", required=false)
    private final @Nullable List<String> pathExpressions;

    @JsonCreator
    public FindSpringBootConfigFiles(@Nullable List<String> pathExpressions) {
        this.pathExpressions = pathExpressions;
    }

    public String getDisplayName() {
        return "Find Spring Boot configuration files";
    }

    public String getDescription() {
        return "Finds Spring Boot configuration files based on the provided path matchers.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        String filePattern = this.pathExpressions != null && !this.pathExpressions.isEmpty() ? String.join((CharSequence)";", this.pathExpressions) : String.join((CharSequence)";", DEFAULT_PATH_EXPRESSIONS);
        return new FindSourceFiles(filePattern).getVisitor();
    }
}

