/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.rewrite.spring.boot.properties;

import com.fasterxml.jackson.annotation.JsonCreator;
import io.arconia.rewrite.spring.boot.properties.FindSpringBootConfigFiles;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.properties.ChangePropertyKey;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.yaml.tree.Yaml;

public class RenameSpringBootPropertyKey
extends Recipe {
    @Option(displayName="Old property key", description="The property key to rename.", example="arconia.config.profiles.test")
    private final String oldPropertyKey;
    @Option(displayName="New property key", description="The new name for the property key.", example="arconia.test.profiles")
    private final String newPropertyKey;
    @Option(displayName="Use relaxed binding", description="Whether to match the old property key using Spring Boot relaxed binding rules. Defaults to `true`.", required=false)
    private final @Nullable Boolean relaxedBinding;
    @Option(displayName="Configuration files path matchers", description="Glob expressions to match Spring Boot configuration files to modify.\nDefaults to standard `application.yml`, `application.yaml`, and `application.properties` files (including profile-specific variants).\nMultiple patterns are OR-ed together.\n", required=false)
    private final @Nullable List<String> pathExpressions;

    @JsonCreator
    public RenameSpringBootPropertyKey(String oldPropertyKey, String newPropertyKey, @Nullable Boolean relaxedBinding, @Nullable List<String> pathExpressions) {
        this.oldPropertyKey = oldPropertyKey;
        this.newPropertyKey = newPropertyKey;
        this.relaxedBinding = relaxedBinding;
        this.pathExpressions = pathExpressions;
    }

    public String getDisplayName() {
        return "Rename Spring Boot configuration property key";
    }

    public String getDescription() {
        return "Rename the key of a property in Spring Boot configuration files.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new FindSpringBootConfigFiles(this.pathExpressions).getVisitor(), (TreeVisitor)new RenameSpringBootPropertyKeyVisitor(this.oldPropertyKey, this.newPropertyKey, this.relaxedBinding));
    }

    public boolean equals(@Nullable Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RenameSpringBootPropertyKey that = (RenameSpringBootPropertyKey)((Object)o);
        return Objects.equals(this.oldPropertyKey, that.oldPropertyKey) && Objects.equals(this.newPropertyKey, that.newPropertyKey) && Objects.equals(this.relaxedBinding, that.relaxedBinding) && Objects.equals(this.pathExpressions, that.pathExpressions);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.oldPropertyKey, this.newPropertyKey, this.relaxedBinding, this.pathExpressions);
    }

    public String toString() {
        return "RenameSpringBootPropertyKey{oldPropertyKey='" + this.oldPropertyKey + "', newPropertyKey='" + this.newPropertyKey + "', relaxedBinding=" + this.relaxedBinding + ", pathExpressions=" + String.valueOf(this.pathExpressions) + "}";
    }

    private static class RenameSpringBootPropertyKeyVisitor
    extends TreeVisitor<Tree, ExecutionContext> {
        private final String oldPropertyKey;
        private final String newPropertyKey;
        private final @Nullable Boolean relaxedBinding;

        public RenameSpringBootPropertyKeyVisitor(String oldPropertyKey, String newPropertyKey, @Nullable Boolean relaxedBinding) {
            this.oldPropertyKey = oldPropertyKey;
            this.newPropertyKey = newPropertyKey;
            this.relaxedBinding = relaxedBinding;
        }

        public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree == null) {
                return null;
            }
            Tree tree2 = tree;
            Objects.requireNonNull(tree2);
            Tree tree3 = tree2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Yaml.Documents.class, Properties.File.class}, (Object)tree3, n)) {
                case 0 -> {
                    Yaml.Documents yamlTree = (Yaml.Documents)tree3;
                    yield this.getYamlVisitor().visit((Tree)yamlTree, (Object)ctx);
                }
                case 1 -> {
                    Properties.File propertiesTree = (Properties.File)tree3;
                    yield this.getPropertiesVisitor().visit((Tree)propertiesTree, (Object)ctx);
                }
                default -> tree;
            };
        }

        private TreeVisitor<?, ExecutionContext> getYamlVisitor() {
            org.openrewrite.yaml.ChangePropertyKey yamlRecipe = new org.openrewrite.yaml.ChangePropertyKey(this.oldPropertyKey, this.newPropertyKey, Boolean.valueOf(!Boolean.FALSE.equals(this.relaxedBinding)), List.of(), null);
            return yamlRecipe.getVisitor();
        }

        private TreeVisitor<?, ExecutionContext> getPropertiesVisitor() {
            ChangePropertyKey propertiesRecipe = new ChangePropertyKey(this.oldPropertyKey, this.newPropertyKey, Boolean.valueOf(!Boolean.FALSE.equals(this.relaxedBinding)), Boolean.valueOf(false));
            return propertiesRecipe.getVisitor();
        }
    }
}

