/*
 * Decompiled with CFR 0.152.
 */
package io.arconia.rewrite.test;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

public class ConvertToRawType
extends Recipe {
    @Option(displayName="Fully qualified type name", description="The fully qualified name of the Java class to convert to its raw type.", example="org.testcontainers.containers.PostgreSQLContainer")
    private final String fullyQualifiedTypeName;

    @JsonCreator
    public ConvertToRawType(String fullyQualifiedTypeName) {
        this.fullyQualifiedTypeName = fullyQualifiedTypeName;
    }

    public String getDisplayName() {
        return "Remove generic type arguments from a Java class";
    }

    public String getDescription() {
        return "Remove generic type arguments from a specified Java class. This replaces parameterized types with their raw types.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(this.fullyQualifiedTypeName, Boolean.valueOf(false)), (TreeVisitor)new RemoveGenericsVisitor());
    }

    private class RemoveGenericsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private RemoveGenericsVisitor() {
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
            J.VariableDeclarations v = super.visitVariableDeclarations(multiVariable, (Object)ctx);
            J.Identifier rawType = this.convertToRawTypeIfNeeded((J)v.getTypeExpression());
            if (rawType != null) {
                v = v.withTypeExpression((TypeTree)rawType.withPrefix(v.getTypeExpression().getPrefix()));
            }
            return v;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
            J.Identifier rawType = this.convertToRawTypeIfNeeded((J)m.getReturnTypeExpression());
            if (rawType != null) {
                m = m.withReturnTypeExpression((TypeTree)rawType.withPrefix(m.getReturnTypeExpression().getPrefix()));
            }
            return m;
        }

        public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
            J.NewClass n = super.visitNewClass(newClass, (Object)ctx);
            J.Identifier rawType = this.convertToRawTypeIfNeeded((J)n.getClazz());
            if (rawType != null) {
                n = n.withClazz((TypeTree)rawType.withPrefix(n.getClazz().getPrefix()));
            }
            return n;
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Identifier convertToRawTypeIfNeeded(@Nullable J typeExpression) {
            if (!(typeExpression instanceof J.ParameterizedType)) {
                return null;
            }
            J.ParameterizedType parameterizedType = (J.ParameterizedType)typeExpression;
            JavaType.Parameterized type = TypeUtils.asParameterized((JavaType)parameterizedType.getType());
            if (type == null || !this.isTargetClass(type)) {
                return null;
            }
            J.Identifier clazz = (J.Identifier)parameterizedType.getClazz();
            return clazz.withType((JavaType)type.getType());
        }

        private boolean isTargetClass(JavaType.Parameterized type) {
            JavaType.FullyQualified fullyQualified = TypeUtils.asFullyQualified((JavaType)type.getType());
            return fullyQualified != null && ConvertToRawType.this.fullyQualifiedTypeName.equals(fullyQualified.getFullyQualifiedName());
        }
    }
}

