/*
 * Decompiled with CFR 0.152.
 */
package argonaut;

import argonaut.Json;
import argonaut.Json$;
import argonaut.JsonNumber;
import argonaut.JsonNumber$;
import argonaut.JsonParser;
import argonaut.JsonParser$JsonObjectBuilder$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class JsonParser$ {
    public static JsonParser$ MODULE$;
    public final Left<String, Nothing$> argonaut$JsonParser$$unexpectedTermination;

    static {
        new JsonParser$();
    }

    public final String argonaut$JsonParser$$excerpt(String string, int position, int limit) {
        String remaining = (String)new StringOps(Predef$.MODULE$.augmentString(string)).drop(position);
        return remaining.length() > limit ? (String)new StringOps(Predef$.MODULE$.augmentString(remaining)).take(limit) + "..." : remaining;
    }

    public final int argonaut$JsonParser$$excerpt$default$3() {
        return 50;
    }

    public final Either<String, Json> parse(String json) {
        int jsonLength = json.length();
        return this.expectValue(json, 0).right().flatMap((Function1 & Serializable & scala.Serializable)result -> this.parseResult$1((Tuple2)result, json, jsonLength));
    }

    public final Either<String, Object> argonaut$JsonParser$$expectedSpacerToken(String stream, int position, char token, String failMessage) {
        Right right;
        block3: {
            Right right2;
            block4: {
                while (true) {
                    if (position >= stream.length()) {
                        right = this.argonaut$JsonParser$$unexpectedTermination;
                        break block3;
                    }
                    char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(stream), position);
                    if (token == c) {
                        right2 = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(position + 1)));
                        break block4;
                    }
                    boolean bl = ' ' == c ? true : ('\r' == c ? true : ('\n' == c ? true : '\t' == c));
                    if (!bl) break;
                    ++position;
                }
                right2 = package$.MODULE$.Left().apply((Object)new StringOps(Predef$.MODULE$.augmentString("%s but found: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{failMessage, this.argonaut$JsonParser$$excerpt(stream, position, this.argonaut$JsonParser$$excerpt$default$3())})));
            }
            right = right2;
        }
        return right;
    }

    public final Either<String, Object> argonaut$JsonParser$$expectStringBounds(String stream, int position) {
        return this.argonaut$JsonParser$$expectedSpacerToken(stream, position, '\"', "Expected string bounds");
    }

    private final Either<String, Object> expectEntrySeparator(String stream, int position) {
        return this.argonaut$JsonParser$$expectedSpacerToken(stream, position, ',', "Expected entry separator token");
    }

    private final Either<String, Object> expectFieldSeparator(String stream, int position) {
        return this.argonaut$JsonParser$$expectedSpacerToken(stream, position, ':', "Expected field separator token");
    }

    private final Either<String, Tuple2<Object, Json>> expectObject(String stream, int position, boolean first, JsonParser.JsonObjectBuilder fields) {
        Right right;
        block4: while (true) {
            if (position >= stream.length()) {
                right = this.argonaut$JsonParser$$unexpectedTermination;
                break;
            }
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(stream), position);
            switch (c) {
                case '}': {
                    right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)(position + 1)), (Object)fields.build()));
                    break block4;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++position;
                    continue block4;
                }
                default: {
                    Right right2;
                    Tuple2 tuple2;
                    Either next;
                    Either either = next = (first ? package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)position)) : this.expectEntrySeparator(stream, position)).right().flatMap((Function1 & Serializable & scala.Serializable)afterEntrySeparator -> JsonParser$.$anonfun$expectObject$1(this, stream, fields, BoxesRunTime.unboxToInt((Object)afterEntrySeparator)));
                    if (either instanceof Right && (tuple2 = (Tuple2)(right2 = (Right)either).value()) != null) {
                        JsonParser.JsonObjectBuilder newFields;
                        int newPosition = tuple2._1$mcI$sp();
                        fields = newFields = (JsonParser.JsonObjectBuilder)tuple2._2();
                        first = false;
                        position = newPosition;
                        continue block4;
                    }
                    if (!(either instanceof Left)) {
                        throw new MatchError((Object)either);
                    }
                    Left left = (Left)either;
                    String failure = (String)left.value();
                    Left left2 = package$.MODULE$.Left().apply((Object)failure);
                    right = left2;
                    break block4;
                }
            }
            break;
        }
        return right;
    }

    private final boolean expectObject$default$3() {
        return true;
    }

    private final JsonParser.JsonObjectBuilder expectObject$default$4() {
        return new JsonParser.JsonObjectBuilder(JsonParser$JsonObjectBuilder$.MODULE$.$lessinit$greater$default$1(), JsonParser$JsonObjectBuilder$.MODULE$.$lessinit$greater$default$2());
    }

    private final Either<String, Tuple2<Object, Json>> expectArray(String stream, int position, boolean first, Builder<Json, List<Json>> fields) {
        Right right;
        block4: while (true) {
            if (position >= stream.length()) {
                right = this.argonaut$JsonParser$$unexpectedTermination;
                break;
            }
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(stream), position);
            switch (c) {
                case ']': {
                    right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)(position + 1)), Json$.MODULE$.jArray().apply(fields.result())));
                    break block4;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++position;
                    continue block4;
                }
                default: {
                    Right right2;
                    Tuple2 tuple2;
                    Either next;
                    Either either = next = (first ? package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)position)) : this.expectEntrySeparator(stream, position)).right().flatMap((Function1 & Serializable & scala.Serializable)afterEntrySeparator -> JsonParser$.$anonfun$expectArray$1(this, stream, fields, BoxesRunTime.unboxToInt((Object)afterEntrySeparator)));
                    if (either instanceof Right && (tuple2 = (Tuple2)(right2 = (Right)either).value()) != null) {
                        Builder newFields;
                        int newPosition = tuple2._1$mcI$sp();
                        fields = newFields = (Builder)tuple2._2();
                        first = false;
                        position = newPosition;
                        continue block4;
                    }
                    if (!(either instanceof Left)) {
                        throw new MatchError((Object)either);
                    }
                    Left left = (Left)either;
                    String failure = (String)left.value();
                    Left left2 = package$.MODULE$.Left().apply((Object)failure);
                    right = left2;
                    break block4;
                }
            }
            break;
        }
        return right;
    }

    private final boolean expectArray$default$3() {
        return true;
    }

    private final Builder<Json, List<Json>> expectArray$default$4() {
        return List$.MODULE$.newBuilder();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Either<String, Tuple2<Object, Json>> expectValue(String stream, int position) {
        Right right;
        Right right2;
        block9: while (true) {
            if (position >= stream.length()) {
                right2 = this.argonaut$JsonParser$$unexpectedTermination;
                return right2;
            }
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(stream), position);
            switch (c) {
                case '[': {
                    right2 = this.expectArray(stream, position + 1, this.expectArray$default$3(), this.expectArray$default$4());
                    return right2;
                }
                case '{': {
                    right2 = this.expectObject(stream, position + 1, this.expectObject$default$3(), this.expectObject$default$4());
                    return right2;
                }
                case '\"': {
                    right2 = this.argonaut$JsonParser$$expectStringNoStartBounds(stream, position + 1).right().map((Function1 & Serializable & scala.Serializable)pair -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)pair._1$mcI$sp()), Json$.MODULE$.jString().apply(pair._2())));
                    return right2;
                }
                case 't': {
                    if (!stream.startsWith("true", position)) break block9;
                    right2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)(position + 4)), (Object)Json$.MODULE$.jTrue()));
                    return right2;
                }
                case 'f': {
                    if (!stream.startsWith("false", position)) break block9;
                    right2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)(position + 5)), (Object)Json$.MODULE$.jFalse()));
                    return right2;
                }
                case 'n': {
                    if (!stream.startsWith("null", position)) break block9;
                    right2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)(position + 4)), (Object)Json$.MODULE$.jNull()));
                    return right2;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++position;
                    continue block9;
                }
            }
            break;
        }
        int numberEndIndex = this.safeNumberIndex$1(position, stream);
        if (numberEndIndex == position) {
            right2 = this.unexpectedContent(stream, position);
            return right2;
        }
        String numberAsString = stream.substring(position, numberEndIndex);
        Option<JsonNumber> option = JsonNumber$.MODULE$.fromString(numberAsString);
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonNumber jn = (JsonNumber)some.value();
            right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)numberEndIndex), (Object)jn.asJson()));
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            right = package$.MODULE$.Left().apply((Object)new StringOps(Predef$.MODULE$.augmentString("Value [%s] cannot be parsed into a number.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{numberAsString})));
        }
        right2 = right;
        return right2;
    }

    private final Either<String, Tuple2<Object, String>> expectString(String stream, int position) {
        return this.argonaut$JsonParser$$expectStringBounds(stream, position).right().flatMap((Function1 & Serializable & scala.Serializable)afterOpen -> JsonParser$.$anonfun$expectString$1(this, stream, BoxesRunTime.unboxToInt((Object)afterOpen)));
    }

    private final <T> Either<String, T> unexpectedContent(String stream, int position) {
        return package$.MODULE$.Left().apply((Object)new StringOps(Predef$.MODULE$.augmentString("Unexpected content found: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.argonaut$JsonParser$$excerpt(stream, position, this.argonaut$JsonParser$$excerpt$default$3())})));
    }

    public final Either<String, Tuple2<Object, StringBuilder>> argonaut$JsonParser$$collectStringParts(String stream, int position, StringBuilder workingString) {
        Either either;
        block15: while (true) {
            int streamLength;
            if (position >= (streamLength = stream.length())) {
                either = this.argonaut$JsonParser$$unexpectedTermination;
                break;
            }
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(stream), position);
            switch (c) {
                case '\"': {
                    either = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)(position + 1)), (Object)workingString));
                    break block15;
                }
                case '\\': {
                    if (position + 2 < streamLength) {
                        char c2 = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(stream), position + 1);
                        switch (c2) {
                            case 'u': {
                                if (position + 6 < streamLength && this.checkUnicode$1(position + 2, JsonParser$.checkUnicode$default$2$1(), stream)) {
                                    workingString = workingString.appendCodePoint(Integer.parseInt(stream.substring(position + 2, position + 6), 16));
                                    position += 6;
                                    continue block15;
                                }
                                either = this.unexpectedContent(stream, position);
                                break block15;
                            }
                            case 'r': {
                                workingString = workingString.append("\r");
                                position += 2;
                                continue block15;
                            }
                            case 'n': {
                                workingString = workingString.append("\n");
                                position += 2;
                                continue block15;
                            }
                            case 't': {
                                workingString = workingString.append("\t");
                                position += 2;
                                continue block15;
                            }
                            case 'b': {
                                workingString = workingString.append("\b");
                                position += 2;
                                continue block15;
                            }
                            case 'f': {
                                workingString = workingString.append("\f");
                                position += 2;
                                continue block15;
                            }
                            case '\\': {
                                workingString = workingString.append("\\");
                                position += 2;
                                continue block15;
                            }
                            case '/': {
                                workingString = workingString.append("/");
                                position += 2;
                                continue block15;
                            }
                            case '\"': {
                                workingString = workingString.append("\"");
                                position += 2;
                                continue block15;
                            }
                        }
                        either = this.unexpectedContent(stream, position);
                        break block15;
                    }
                    either = this.unexpectedContent(stream, position);
                    break block15;
                }
                default: {
                    int normalCharEnd = this.safeNormalCharIndex$1(position, stream, streamLength);
                    workingString = workingString.append(stream, position, normalCharEnd);
                    position = normalCharEnd;
                    continue block15;
                }
            }
            break;
        }
        return either;
    }

    public final StringBuilder argonaut$JsonParser$$collectStringParts$default$3() {
        return new StringBuilder();
    }

    public final Either<String, Tuple2<Object, String>> argonaut$JsonParser$$expectStringNoStartBounds(String stream, int position) {
        return this.argonaut$JsonParser$$collectStringParts(stream, position, this.argonaut$JsonParser$$collectStringParts$default$3()).right().map((Function1 & Serializable & scala.Serializable)elements -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)elements._1$mcI$sp()), (Object)((StringBuilder)elements._2()).toString()));
    }

    private final boolean validSuffixContent$1(int from, String json$1, int jsonLength$1) {
        boolean bl;
        block5: {
            block3: while (true) {
                if (from >= jsonLength$1) {
                    bl = true;
                    break block5;
                }
                char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(json$1), from);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        ++from;
                        continue block3;
                    }
                }
                break;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Either parseResult$1(Tuple2 result, String json$1, int jsonLength$1) {
        Tuple2 tuple2 = result;
        if (tuple2 != null) {
            int n = tuple2._1$mcI$sp();
            Json jsonInstance = (Json)tuple2._2();
            if (jsonLength$1 == n) {
                return package$.MODULE$.Right().apply((Object)jsonInstance);
            }
        }
        if (tuple2 != null) {
            int remainder = tuple2._1$mcI$sp();
            Json jsonInstance = (Json)tuple2._2();
            if (this.validSuffixContent$1(remainder, json$1, jsonLength$1)) {
                return package$.MODULE$.Right().apply((Object)jsonInstance);
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        int remainder = tuple2._1$mcI$sp();
        return package$.MODULE$.Left().apply((Object)new StringOps(Predef$.MODULE$.augmentString("JSON contains invalid suffix content: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.argonaut$JsonParser$$excerpt(json$1, remainder, this.argonaut$JsonParser$$excerpt$default$3())})));
    }

    public static final /* synthetic */ Either $anonfun$expectObject$3(JsonParser$ $this, String stream$2, JsonParser.JsonObjectBuilder fields$1, Tuple2 streamAndKey$1, int afterFieldSeparator) {
        return $this.expectValue(stream$2, afterFieldSeparator).right().map((Function1 & Serializable & scala.Serializable)streamAndValue -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)streamAndValue._1$mcI$sp()), (Object)fields$1.add((String)streamAndKey$1._2(), (Json)streamAndValue._2())));
    }

    public static final /* synthetic */ Either $anonfun$expectObject$1(JsonParser$ $this, String stream$2, JsonParser.JsonObjectBuilder fields$1, int afterEntrySeparator) {
        return $this.expectString(stream$2, afterEntrySeparator).right().flatMap((Function1 & Serializable & scala.Serializable)streamAndKey -> $this.expectFieldSeparator(stream$2, streamAndKey._1$mcI$sp()).right().flatMap((Function1 & Serializable & scala.Serializable)afterFieldSeparator -> JsonParser$.$anonfun$expectObject$3($this, stream$2, fields$1, streamAndKey, BoxesRunTime.unboxToInt((Object)afterFieldSeparator))));
    }

    public static final /* synthetic */ Either $anonfun$expectArray$1(JsonParser$ $this, String stream$4, Builder fields$2, int afterEntrySeparator) {
        return $this.expectValue(stream$4, afterEntrySeparator).right().map((Function1 & Serializable & scala.Serializable)streamAndValue -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)streamAndValue._1$mcI$sp()), (Object)fields$2.$plus$eq(streamAndValue._2())));
    }

    private final int safeNumberIndex$1(int index, String stream$1) {
        int n;
        block2: {
            while (true) {
                if (index >= stream$1.length()) {
                    n = stream$1.length();
                    break block2;
                }
                char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(stream$1), index);
                if ((c < '0' || c > '9') && c != '+' && c != '-' && c != 'e' && c != 'E' && c != '.') break;
                ++index;
            }
            n = index;
        }
        return n;
    }

    public static final /* synthetic */ Either $anonfun$expectString$1(JsonParser$ $this, String stream$3, int afterOpen) {
        return $this.argonaut$JsonParser$$expectStringNoStartBounds(stream$3, afterOpen).right().map((Function1 & Serializable & scala.Serializable)afterString -> afterString);
    }

    private final boolean checkUnicode$1(int from, int unicodeShift, String stream$5) {
        boolean bl;
        block2: {
            while (true) {
                if (unicodeShift >= 4) {
                    bl = true;
                    break block2;
                }
                char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(stream$5), from + unicodeShift);
                if (!(c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') && (c < '0' || c > '9')) break;
                ++unicodeShift;
            }
            bl = false;
        }
        return bl;
    }

    private static final int checkUnicode$default$2$1() {
        return 0;
    }

    private final int safeNormalCharIndex$1(int index, String stream$5, int streamLength$1) {
        int n;
        while (true) {
            if (index >= streamLength$1) {
                n = streamLength$1;
                break;
            }
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(stream$5), index);
            if (c == '\"' || c == '\\') {
                n = index;
                break;
            }
            ++index;
        }
        return n;
    }

    private JsonParser$() {
        MODULE$ = this;
        this.argonaut$JsonParser$$unexpectedTermination = package$.MODULE$.Left().apply((Object)"JSON terminates unexpectedly.");
    }
}

