/*
 * Decompiled with CFR 0.152.
 */
package argonaut;

import argonaut.Json;
import argonaut.Json$;
import argonaut.JsonNumber;
import argonaut.JsonNumber$;
import argonaut.JsonParser;
import argonaut.JsonParser$JsonObjectBuilder$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class JsonParser$
implements Serializable {
    private static final Left<String, Nothing$> unexpectedTermination;
    private static final JsonParser$JsonObjectBuilder$ JsonObjectBuilder;
    public static final JsonParser$ MODULE$;

    private JsonParser$() {
    }

    static {
        MODULE$ = new JsonParser$();
        unexpectedTermination = package$.MODULE$.Left().apply((Object)"JSON terminates unexpectedly.");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JsonParser$.class);
    }

    private final String excerpt(String string, int position, int limit) {
        String remaining = StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(string), position);
        if (remaining.length() > limit) {
            return new StringBuilder(3).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(remaining), limit)).append("...").toString();
        }
        return remaining;
    }

    private int excerpt$default$3() {
        return 50;
    }

    public final Either<String, Json> parse(String json) {
        int jsonLength = json.length();
        return this.expectValue(json, 0).flatMap((Function1 & Serializable)result -> this.parseResult$1(json, jsonLength, (Tuple2)result));
    }

    private final Either<String, Object> expectedSpacerToken(String stream, int position, char token, String failMessage) {
        block3: while (true) {
            if (position >= stream.length()) {
                return unexpectedTermination;
            }
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(stream), position);
            if (token == c) {
                return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(position + 1)));
            }
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++position;
                    continue block3;
                }
            }
            break;
        }
        return package$.MODULE$.Left().apply((Object)new StringBuilder(12).append(failMessage).append(" but found: ").append(this.excerpt(stream, position, this.excerpt$default$3())).toString());
    }

    private final Either<String, Object> expectStringBounds(String stream, int position) {
        return this.expectedSpacerToken(stream, position, '\"', "Expected string bounds");
    }

    private final Either<String, Object> expectEntrySeparator(String stream, int position) {
        return this.expectedSpacerToken(stream, position, ',', "Expected entry separator token");
    }

    private final Either<String, Object> expectFieldSeparator(String stream, int position) {
        return this.expectedSpacerToken(stream, position, ':', "Expected field separator token");
    }

    private final Either<String, Tuple2<Object, Json>> expectObject(String stream, int position, boolean first, JsonParser.JsonObjectBuilder fields) {
        Either either;
        block4: while (true) {
            Tuple2 tuple2;
            Either next;
            if (position >= stream.length()) {
                return unexpectedTermination;
            }
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(stream), position);
            switch (c) {
                case '}': {
                    return package$.MODULE$.Right().apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(position + 1)), (Object)fields.build()));
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++position;
                    continue block4;
                }
            }
            either = next = (first ? package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)position)) : this.expectEntrySeparator(stream, position)).flatMap((Function1 & Serializable)afterEntrySeparator -> this.$anonfun$1(stream, fields, BoxesRunTime.unboxToInt((Object)afterEntrySeparator)));
            if (!(either instanceof Right) || (tuple2 = (Tuple2)((Right)either).value()) == null) break;
            int newPosition = BoxesRunTime.unboxToInt((Object)tuple2._1());
            JsonParser.JsonObjectBuilder newFields = (JsonParser.JsonObjectBuilder)tuple2._2();
            int n = newPosition;
            boolean bl = false;
            JsonParser.JsonObjectBuilder jsonObjectBuilder = newFields;
            position = n;
            first = bl;
            fields = jsonObjectBuilder;
        }
        if (either instanceof Left) {
            String failure = (String)((Left)either).value();
            return package$.MODULE$.Left().apply((Object)failure);
        }
        throw new MatchError((Object)either);
    }

    private boolean expectObject$default$3() {
        return true;
    }

    private JsonParser.JsonObjectBuilder expectObject$default$4() {
        return new JsonParser.JsonObjectBuilder(JsonParser$JsonObjectBuilder$.MODULE$.$lessinit$greater$default$1(), JsonParser$JsonObjectBuilder$.MODULE$.$lessinit$greater$default$2());
    }

    private final Either<String, Tuple2<Object, Json>> expectArray(String stream, int position, boolean first, Builder<Json, List<Json>> fields) {
        Either either;
        block4: while (true) {
            Tuple2 tuple2;
            Either next;
            if (position >= stream.length()) {
                return unexpectedTermination;
            }
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(stream), position);
            switch (c) {
                case ']': {
                    return package$.MODULE$.Right().apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(position + 1)), Json$.MODULE$.jArray().apply(fields.result())));
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++position;
                    continue block4;
                }
            }
            either = next = (first ? package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)position)) : this.expectEntrySeparator(stream, position)).flatMap((Function1 & Serializable)afterEntrySeparator -> this.$anonfun$2(stream, fields, BoxesRunTime.unboxToInt((Object)afterEntrySeparator)));
            if (!(either instanceof Right) || (tuple2 = (Tuple2)((Right)either).value()) == null) break;
            int newPosition = BoxesRunTime.unboxToInt((Object)tuple2._1());
            Builder newFields = (Builder)tuple2._2();
            int n = newPosition;
            boolean bl = false;
            Builder builder = newFields;
            position = n;
            first = bl;
            fields = builder;
        }
        if (either instanceof Left) {
            String failure = (String)((Left)either).value();
            return package$.MODULE$.Left().apply((Object)failure);
        }
        throw new MatchError((Object)either);
    }

    private boolean expectArray$default$3() {
        return true;
    }

    private Builder<Json, List<Json>> expectArray$default$4() {
        return package$.MODULE$.List().newBuilder();
    }

    private final Either<String, Tuple2<Object, Json>> expectValue(String stream, int position) {
        block8: while (true) {
            if (position >= stream.length()) {
                return unexpectedTermination;
            }
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(stream), position);
            switch (c) {
                case '[': {
                    return this.expectArray(stream, position + 1, this.expectArray$default$3(), this.expectArray$default$4());
                }
                case '{': {
                    return this.expectObject(stream, position + 1, this.expectObject$default$3(), this.expectObject$default$4());
                }
                case '\"': {
                    return this.expectStringNoStartBounds(stream, position + 1).map((Function1 & Serializable)pair -> Tuple2$.MODULE$.apply(pair._1(), Json$.MODULE$.jString().apply(pair._2())));
                }
            }
            if ('t' == c && stream.startsWith("true", position)) {
                return package$.MODULE$.Right().apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(position + 4)), (Object)Json$.MODULE$.jTrue()));
            }
            if ('f' == c && stream.startsWith("false", position)) {
                return package$.MODULE$.Right().apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(position + 5)), (Object)Json$.MODULE$.jFalse()));
            }
            if ('n' == c && stream.startsWith("null", position)) {
                return package$.MODULE$.Right().apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(position + 4)), (Object)Json$.MODULE$.jNull()));
            }
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++position;
                    continue block8;
                }
            }
            break;
        }
        int numberEndIndex = this.safeNumberIndex$1(stream, position);
        if (numberEndIndex == position) {
            return this.unexpectedContent(stream, position);
        }
        String numberAsString = stream.substring(position, numberEndIndex);
        Option<JsonNumber> option = JsonNumber$.MODULE$.fromString(numberAsString);
        if (option instanceof Some) {
            JsonNumber jn = (JsonNumber)((Some)option).value();
            return package$.MODULE$.Right().apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)numberEndIndex), (Object)jn.asJson()));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)new StringBuilder(40).append("Value [").append(numberAsString).append("] cannot be parsed into a number.").toString());
        }
        throw new MatchError(option);
    }

    private final Either<String, Tuple2<Object, String>> expectString(String stream, int position) {
        return this.expectStringBounds(stream, position).flatMap((Function1 & Serializable)afterOpen -> this.expectString$$anonfun$1(stream, BoxesRunTime.unboxToInt((Object)afterOpen)));
    }

    private final <T> Either<String, T> unexpectedContent(String stream, int position) {
        return package$.MODULE$.Left().apply((Object)new StringBuilder(26).append("Unexpected content found: ").append(this.excerpt(stream, position, this.excerpt$default$3())).toString());
    }

    private final Either<String, Tuple2<Object, StringBuilder>> collectStringParts(String stream, int position, StringBuilder workingString) {
        int streamLength;
        block11: while (position < (streamLength = stream.length())) {
            int normalCharEnd;
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(stream), position);
            if ('\"' == c) {
                return package$.MODULE$.Right().apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(position + 1)), (Object)workingString));
            }
            if ('\\' == c) {
                if (position + 2 < streamLength) {
                    char c2 = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(stream), position + 1);
                    switch (c2) {
                        case 'u': {
                            if (position + 6 < streamLength && this.checkUnicode$1(stream, position + 2, this.checkUnicode$default$2$1())) {
                                int n = position + 6;
                                StringBuilder stringBuilder = workingString.appendCodePoint(Integer.parseInt(stream.substring(position + 2, position + 6), 16));
                                position = n;
                                workingString = stringBuilder;
                                continue block11;
                            }
                            return this.unexpectedContent(stream, position);
                        }
                        case 'r': {
                            int n = position + 2;
                            StringBuilder stringBuilder = workingString.append("\r");
                            position = n;
                            workingString = stringBuilder;
                            continue block11;
                        }
                        case 'n': {
                            int n = position + 2;
                            StringBuilder stringBuilder = workingString.append("\n");
                            position = n;
                            workingString = stringBuilder;
                            continue block11;
                        }
                        case 't': {
                            int n = position + 2;
                            StringBuilder stringBuilder = workingString.append("\t");
                            position = n;
                            workingString = stringBuilder;
                            continue block11;
                        }
                        case 'b': {
                            int n = position + 2;
                            StringBuilder stringBuilder = workingString.append("\b");
                            position = n;
                            workingString = stringBuilder;
                            continue block11;
                        }
                        case 'f': {
                            int n = position + 2;
                            StringBuilder stringBuilder = workingString.append("\f");
                            position = n;
                            workingString = stringBuilder;
                            continue block11;
                        }
                        case '\\': {
                            int n = position + 2;
                            StringBuilder stringBuilder = workingString.append("\\");
                            position = n;
                            workingString = stringBuilder;
                            continue block11;
                        }
                        case '/': {
                            int n = position + 2;
                            StringBuilder stringBuilder = workingString.append("/");
                            position = n;
                            workingString = stringBuilder;
                            continue block11;
                        }
                        case '\"': {
                            int n = position + 2;
                            StringBuilder stringBuilder = workingString.append("\"");
                            position = n;
                            workingString = stringBuilder;
                            continue block11;
                        }
                    }
                    return this.unexpectedContent(stream, position);
                }
                return this.unexpectedContent(stream, position);
            }
            char other = c;
            int n = normalCharEnd = this.safeNormalCharIndex$1(stream, streamLength, position);
            StringBuilder stringBuilder = workingString.append(stream, position, normalCharEnd);
            position = n;
            workingString = stringBuilder;
        }
        return unexpectedTermination;
    }

    private StringBuilder collectStringParts$default$3() {
        return new StringBuilder();
    }

    private final Either<String, Tuple2<Object, String>> expectStringNoStartBounds(String stream, int position) {
        return this.collectStringParts(stream, position, this.collectStringParts$default$3()).map((Function1 & Serializable)elements -> Tuple2$.MODULE$.apply(elements._1(), (Object)((StringBuilder)elements._2()).toString()));
    }

    private final boolean validSuffixContent$1(String json$1, int jsonLength$1, int from) {
        block3: while (true) {
            if (from >= jsonLength$1) {
                return true;
            }
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(json$1), from);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++from;
                    continue block3;
                }
            }
            break;
        }
        return false;
    }

    private final Either parseResult$1(String json$2, int jsonLength$2, Tuple2 result) {
        Tuple2 tuple2 = result;
        if (tuple2 != null) {
            int n = BoxesRunTime.unboxToInt((Object)tuple2._1());
            Json json = (Json)tuple2._2();
            if (jsonLength$2 == n) {
                Json jsonInstance = json;
                return package$.MODULE$.Right().apply((Object)jsonInstance);
            }
            int remainder = n;
            Json jsonInstance = json;
            if (this.validSuffixContent$1(json$2, jsonLength$2, remainder)) {
                return package$.MODULE$.Right().apply((Object)jsonInstance);
            }
            int remainder2 = n;
            return package$.MODULE$.Left().apply((Object)new StringBuilder(38).append("JSON contains invalid suffix content: ").append(this.excerpt(json$2, remainder2, this.excerpt$default$3())).toString());
        }
        throw new MatchError((Object)tuple2);
    }

    private final /* synthetic */ Either $anonfun$1$$anonfun$1$$anonfun$1(String stream$3, Tuple2 streamAndKey$1, JsonParser.JsonObjectBuilder fields$tailLocal1$3, int afterFieldSeparator) {
        return this.expectValue(stream$3, afterFieldSeparator).map((Function1 & Serializable)streamAndValue -> Tuple2$.MODULE$.apply(streamAndValue._1(), (Object)fields$tailLocal1$3.add((String)streamAndKey$1._2(), (Json)streamAndValue._2())));
    }

    private final /* synthetic */ Either $anonfun$1(String stream$1, JsonParser.JsonObjectBuilder fields$tailLocal1$1, int afterEntrySeparator) {
        return this.expectString(stream$1, afterEntrySeparator).flatMap((Function1 & Serializable)streamAndKey -> this.expectFieldSeparator(stream$1, BoxesRunTime.unboxToInt((Object)streamAndKey._1())).flatMap((Function1 & Serializable)afterFieldSeparator -> this.$anonfun$1$$anonfun$1$$anonfun$1(stream$1, (Tuple2)streamAndKey, fields$tailLocal1$1, BoxesRunTime.unboxToInt((Object)afterFieldSeparator))));
    }

    private final /* synthetic */ Either $anonfun$2(String stream$4, Builder fields$tailLocal2$1, int afterEntrySeparator) {
        return this.expectValue(stream$4, afterEntrySeparator).map((Function1 & Serializable)streamAndValue -> Tuple2$.MODULE$.apply(streamAndValue._1(), (Object)fields$tailLocal2$1.$plus$eq(streamAndValue._2())));
    }

    private final int safeNumberIndex$1(String stream$5, int index) {
        while (true) {
            if (index >= stream$5.length()) {
                return stream$5.length();
            }
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(stream$5), index);
            if ((c < '0' || c > '9') && c != '+' && c != '-' && c != 'e' && c != 'E' && c != '.') break;
            ++index;
        }
        return index;
    }

    private final /* synthetic */ Either expectString$$anonfun$1(String stream$6, int afterOpen) {
        return this.expectStringNoStartBounds(stream$6, afterOpen).map((Function1 & Serializable)afterString -> afterString);
    }

    private final boolean checkUnicode$1(String stream$7, int from, int unicodeShift) {
        while (true) {
            if (unicodeShift >= 4) {
                return true;
            }
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(stream$7), from + unicodeShift);
            if (!(c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') && (c < '0' || c > '9')) break;
            ++unicodeShift;
        }
        return false;
    }

    private final int checkUnicode$default$2$1() {
        return 0;
    }

    private final int safeNormalCharIndex$1(String stream$8, int streamLength$1, int index) {
        while (index < streamLength$1) {
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(stream$8), index);
            if (c == '\"' || c == '\\') {
                return index;
            }
            ++index;
        }
        return streamLength$1;
    }
}

