package arrow.core.extensions.const.contravariant

import arrow.Kind
import arrow.core.extensions.ConstContravariant
import arrow.typeclasses.Const
import arrow.typeclasses.Const.Companion
import arrow.typeclasses.ForConst
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("contramap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<Kind<ForConst, A>, A>.contramap(arg1: Function1<B, A>): Const<A, B> = arrow.typeclasses.Const.contravariant<A>().run {
  this@contramap.contramap<A, B>(arg1) as arrow.typeclasses.Const<A, B>
}

@JvmName("lift1")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> lift(arg0: Function1<A, B>): Function1<Kind<Kind<ForConst, A>, B>, Kind<Kind<ForConst, A>, A>> = arrow.typeclasses.Const
   .contravariant<A>()
   .lift<A, B>(arg0) as kotlin.Function1<arrow.Kind<arrow.Kind<arrow.typeclasses.ForConst, A>, B>, arrow.Kind<arrow.Kind<arrow.typeclasses.ForConst, A>, A>>

@JvmName("imap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<Kind<ForConst, A>, A>.imap(arg1: Function1<A, B>, arg2: Function1<B, A>): Const<A, B> = arrow.typeclasses.Const.contravariant<A>().run {
  this@imap.imap<A, B>(arg1, arg2) as arrow.typeclasses.Const<A, B>
}

@JvmName("narrow")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B : A> Kind<Kind<ForConst, A>, A>.narrow(): Const<A, B> = arrow.typeclasses.Const.contravariant<A>().run {
  this@narrow.narrow<A, B>() as arrow.typeclasses.Const<A, B>
}

fun <A> Companion.contravariant(): ConstContravariant<A> = object : arrow.core.extensions.ConstContravariant<A> {  }