package arrow.core.extensions.function0.monad

import arrow.Kind
import arrow.core.Either
import arrow.core.Eval
import arrow.core.ForFunction0
import arrow.core.Function0
import arrow.core.Function0.Companion
import arrow.core.Tuple2
import arrow.core.extensions.Function0Monad
import arrow.typeclasses.MonadContinuation
import kotlin.Boolean
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("flatMap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<ForFunction0, A>.flatMap(arg1: Function1<A, Kind<ForFunction0, B>>): Function0<B> = arrow.core.Function0.monad().run {
  this@flatMap.flatMap<A, B>(arg1) as arrow.core.Function0<B>
}

@JvmName("tailRecM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> tailRecM(arg0: A, arg1: Function1<A, Kind<ForFunction0, Either<A, B>>>): Function0<B> = arrow.core.Function0
   .monad()
   .tailRecM<A, B>(arg0, arg1) as arrow.core.Function0<B>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<ForFunction0, A>.map(arg1: Function1<A, B>): Function0<B> = arrow.core.Function0.monad().run {
  this@map.map<A, B>(arg1) as arrow.core.Function0<B>
}

/**
 * @see [Applicative.ap]
 */
@JvmName("ap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<ForFunction0, A>.ap(arg1: Kind<ForFunction0, Function1<A, B>>): Function0<B> = arrow.core.Function0.monad().run {
  this@ap.ap<A, B>(arg1) as arrow.core.Function0<B>
}

@JvmName("flatten")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Kind<ForFunction0, Kind<ForFunction0, A>>.flatten(): Function0<A> = arrow.core.Function0.monad().run {
  this@flatten.flatten<A>() as arrow.core.Function0<A>
}

@JvmName("followedBy")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<ForFunction0, A>.followedBy(arg1: Kind<ForFunction0, B>): Function0<B> = arrow.core.Function0.monad().run {
  this@followedBy.followedBy<A, B>(arg1) as arrow.core.Function0<B>
}

@JvmName("followedByEval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<ForFunction0, A>.followedByEval(arg1: Eval<Kind<ForFunction0, B>>): Function0<B> = arrow.core.Function0.monad().run {
  this@followedByEval.followedByEval<A, B>(arg1) as arrow.core.Function0<B>
}

@JvmName("effectM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<ForFunction0, A>.effectM(arg1: Function1<A, Kind<ForFunction0, B>>): Function0<A> = arrow.core.Function0.monad().run {
  this@effectM.effectM<A, B>(arg1) as arrow.core.Function0<A>
}

@JvmName("forEffect")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<ForFunction0, A>.forEffect(arg1: Kind<ForFunction0, B>): Function0<A> = arrow.core.Function0.monad().run {
  this@forEffect.forEffect<A, B>(arg1) as arrow.core.Function0<A>
}

@JvmName("forEffectEval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<ForFunction0, A>.forEffectEval(arg1: Eval<Kind<ForFunction0, B>>): Function0<A> = arrow.core.Function0.monad().run {
  this@forEffectEval.forEffectEval<A, B>(arg1) as arrow.core.Function0<A>
}

@JvmName("mproduct")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<ForFunction0, A>.mproduct(arg1: Function1<A, Kind<ForFunction0, B>>): Function0<Tuple2<A, B>> = arrow.core.Function0.monad().run {
  this@mproduct.mproduct<A, B>(arg1) as arrow.core.Function0<arrow.core.Tuple2<A, B>>
}

@JvmName("ifM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <B> Kind<ForFunction0, Boolean>.ifM(arg1: kotlin.Function0<Kind<ForFunction0, B>>, arg2: kotlin.Function0<Kind<ForFunction0, B>>): Function0<B> = arrow.core.Function0.monad().run {
  this@ifM.ifM<B>(arg1, arg2) as arrow.core.Function0<B>
}

@JvmName("selectM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<ForFunction0, Either<A, B>>.selectM(arg1: Kind<ForFunction0, Function1<A, B>>): Function0<B> = arrow.core.Function0.monad().run {
  this@selectM.selectM<A, B>(arg1) as arrow.core.Function0<B>
}

@JvmName("select")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<ForFunction0, Either<A, B>>.select(arg1: Kind<ForFunction0, Function1<A, B>>): Function0<B> = arrow.core.Function0.monad().run {
  this@select.select<A, B>(arg1) as arrow.core.Function0<B>
}

/**
 * Entry point for monad bindings which enables for comprehension. The underlying implementation is based on coroutines.
 * A coroutine is initiated and suspended inside [MonadErrorContinuation] yielding to [Monad.flatMap]. Once all the flatMap binds are completed
 * the underlying monad is returned from the act of executing the coroutine
 */
@JvmName("binding")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> binding(arg0: suspend MonadContinuation<ForFunction0, *>.() -> A): Function0<A> = arrow.core.Function0
   .monad()
   .binding<A>(arg0) as arrow.core.Function0<A>

/**
 * ank_macro_hierarchy(arrow.typeclasses.Monad)
 *
 * [Monad] abstract over the ability to declare sequential computations that are dependent in the order or
 * the results of previous computations.
 *
 * Given a type constructor [F] with a value of [A] we can compose multiple operations of type
 * `Kind<F, ?>` where `?` denotes a value being transformed.
 *
 * This is true for all type constructors that can support the [Monad] type class including and not limited to
 * [IO], [DeferredK], [ObservableK], [Option], [Either], [List], [Try] ...
 *
 * [The Monad Tutorial](https://arrow-kt.io/docs/patterns/monads/)
 *
 */
fun Companion.monad(): Function0Monad = object : arrow.core.extensions.Function0Monad {  }