package arrow.core.extensions.option.applicativeError

import arrow.Kind
import arrow.core.Either
import arrow.core.ForOption
import arrow.core.ForTry
import arrow.core.Option
import arrow.core.Option.Companion
import arrow.core.extensions.OptionApplicativeError
import arrow.typeclasses.ApplicativeError
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.Throwable
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("handleErrorWith")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Kind<ForOption, A>.handleErrorWith(arg1: Function1<Unit, Kind<ForOption, A>>): Option<A> = arrow.core.Option.applicativeError().run {
  this@handleErrorWith.handleErrorWith<A>(arg1) as arrow.core.Option<A>
}

@JvmName("raiseError1")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Unit.raiseError(): Option<A> = arrow.core.Option.applicativeError().run {
  this@raiseError.raiseError<A>() as arrow.core.Option<A>
}

@JvmName("fromOption")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Kind<ForOption, A>.fromOption(arg1: Function0<Unit>): Option<A> = arrow.core.Option.applicativeError().run {
  this@fromOption.fromOption<A>(arg1) as arrow.core.Option<A>
}

@JvmName("fromEither")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, EE> Either<EE, A>.fromEither(arg1: Function1<EE, Unit>): Option<A> = arrow.core.Option.applicativeError().run {
  this@fromEither.fromEither<A, EE>(arg1) as arrow.core.Option<A>
}

@JvmName("fromTry")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Kind<ForTry, A>.fromTry(arg1: Function1<Throwable, Unit>): Option<A> = arrow.core.Option.applicativeError().run {
  this@fromTry.fromTry<A>(arg1) as arrow.core.Option<A>
}

@JvmName("handleError")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Kind<ForOption, A>.handleError(arg1: Function1<Unit, A>): Option<A> = arrow.core.Option.applicativeError().run {
  this@handleError.handleError<A>(arg1) as arrow.core.Option<A>
}

@JvmName("attempt")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Kind<ForOption, A>.attempt(): Option<Either<Unit, A>> = arrow.core.Option.applicativeError().run {
  this@attempt.attempt<A>() as arrow.core.Option<arrow.core.Either<kotlin.Unit, A>>
}

@JvmName("catch")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> catch(arg0: Function1<Throwable, Unit>, arg1: Function0<A>): Option<A> = arrow.core.Option
   .applicativeError()
   .catch<A>(arg0, arg1) as arrow.core.Option<A>

@JvmName("catch")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> ApplicativeError<ForOption, Throwable>.catch(arg1: Function0<A>): Option<A> = arrow.core.Option.applicativeError().run {
  this@catch.catch<A>(arg1) as arrow.core.Option<A>
}

fun Companion.applicativeError(): OptionApplicativeError = object : arrow.core.extensions.OptionApplicativeError {  }