package arrow.core.extensions.option.semiring

import arrow.core.Option
import arrow.core.Option.Companion
import arrow.core.extensions.OptionSemiring
import arrow.typeclasses.Semiring
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("empty")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> empty(SG: Semiring<A>): Option<A> = arrow.core.Option
   .semiring<A>(SG)
   .empty() as arrow.core.Option<A>

@JvmName("times")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Option<A>.times(SG: Semiring<A>, arg1: Option<A>): Option<A> = arrow.core.Option.semiring<A>(SG).run {
  this@times.times(arg1) as arrow.core.Option<A>
}

/**
 * Maybe additively combine two [A] values.
 */
@JvmName("maybeCombineAddition")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Option<A>.maybeCombineAddition(SG: Semiring<A>, arg1: Option<A>): Option<A> = arrow.core.Option.semiring<A>(SG).run {
  this@maybeCombineAddition.maybeCombineAddition(arg1) as arrow.core.Option<A>
}

/**
 * Maybe multiplicatively combine two [A] values.
 */
@JvmName("maybeCombineMultiplicate")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Option<A>.maybeCombineMultiplicate(SG: Semiring<A>, arg1: Option<A>): Option<A> = arrow.core.Option.semiring<A>(SG).run {
  this@maybeCombineMultiplicate.maybeCombineMultiplicate(arg1) as arrow.core.Option<A>
}

/**
 * ank_macro_hierarchy(arrow.typeclasses.Semiring)
 *
 * The [Semiring] type class for a given type `A` extends the [Monoid] type class by adding a `combineMultiplicate` and an
 * [one] function. [combineMultiplicate] also takes two values and returns a value of type `A` and guarantees to be
 * associative:
 *
 * ```kotlin
 * (a.combineMultiplicate(b)).combineMultiplicate(c) == a.combineMultiplicate(b.combineMultiplicate(c))
 * ```
 *
 * The [one] value serves exactly like the [empty] function for an additive [Monoid], just adapted for the multiplicative
 * version. This forms the following law:
 *
 * ```kotlin
 * combineMultiplicate(x, one) == combineMultiplicate(one, x) == x
 * ```
 *
 * Please note that the empty function has been renamed to [zero] to get a consistent naming style inside the semiring.
 *
 * Currently, [Semiring] instances are defined for all available number types.
 *
 * ### Examples
 *
 * Here a some examples:
 *
 * ```kotlin:ank:playground
 * import arrow.core.extensions.*
 *
 * fun main(args: Array<String>) {
 *   val result =
 *   //sampleStart
 *   Int.semiring().run { 1.combine(2) }
 *   //sampleEnd
 *   println(result)
 * }
 * ```
 *
 * ```kotlin:ank:playground
 * import arrow.core.extensions.*
 *
 * fun main(args: Array<String>) {
 *   val result =
 *   //sampleStart
 *   Int.semiring().run { 2.combineMultiplicate(3) }
 *   //sampleEnd
 *   println(result)
 * }
 * ```
 *
 * ```kotlin:ank:playground
 * import arrow.core.Option
 * import arrow.core.extensions.*
 * import arrow.core.extensions.option.semiring.semiring
 *
 * fun main(args: Array<String>) {
 *   val result =
 *   //sampleStart
 *   Option.semiring(Int.semiring()).run {
 *      Option(1).combine(Option(2))
 *   }
 *   //sampleEnd
 *   println(result)
 * }
 * ```
 *
 * ```kotlin:ank:playground
 * import arrow.core.Option
 * import arrow.core.extensions.*
 * import arrow.core.extensions.option.semiring.semiring
 *
 * fun main(args: Array<String>) {
 *   val result =
 *   //sampleStart
 *   Option.semiring(Int.semiring()).run {
 *      Option(2).combineMultiplicate(Option(3))
 *   }
 *   //sampleEnd
 *   println(result)
 * }
 * ```
 *
 * ```kotlin:ank:playground
 * import arrow.core.Option
 * import arrow.core.None
 * import arrow.core.extensions.*
 * import arrow.core.extensions.option.semiring.semiring
 *
 * fun main(args: Array<String>) {
 *   val result =
 *   //sampleStart
 *   Option.semiring(Int.semiring()).run {
 *      Option(1).combine(None)
 *   }
 *   //sampleEnd
 *   println(result)
 * }
 * ```
 *
 * The type class `Semiring` also has support for the `+` `*` syntax:
 *
 * ```kotlin:ank:playground
 * import arrow.core.Option
 * import arrow.core.extensions.*
 * import arrow.core.extensions.option.semiring.semiring
 *
 * fun main(args: Array<String>) {
 *   val result =
 *   //sampleStart
 *   Option.semiring(Int.semiring()).run {
 *      Option(1) + Option(2)
 *   }
 *   //sampleEnd
 *   println(result)
 * }
 * ```
 *
 * ```kotlin:ank:playground
 * import arrow.core.Option
 * import arrow.core.extensions.*
 * import arrow.core.extensions.option.semiring.semiring
 *
 * fun main(args: Array<String>) {
 *   val result =
 *   //sampleStart
 *   Option.semiring(Int.semiring()).run {
 *      Option(2) * Option(3)
 *   }
 *   //sampleEnd
 *   println(result)
 * }
 * ```
 */
fun <A> Companion.semiring(SG: Semiring<A>): OptionSemiring<A> = object : arrow.core.extensions.OptionSemiring<A> { override fun SG(): arrow.typeclasses.Semiring<A> = SG }