package arrow.core.extensions.tuple2.monad

import arrow.Kind
import arrow.core.Either
import arrow.core.Eval
import arrow.core.ForTuple2
import arrow.core.Tuple2
import arrow.core.Tuple2.Companion
import arrow.core.extensions.Tuple2Monad
import arrow.typeclasses.MonadContinuation
import arrow.typeclasses.Monoid
import kotlin.Boolean
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("flatMap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForTuple2, F>, A>.flatMap(MF: Monoid<F>, arg1: Function1<A, Kind<Kind<ForTuple2, F>, B>>): Tuple2<F, B> = arrow.core.Tuple2.monad<F>(MF).run {
  this@flatMap.flatMap<A, B>(arg1) as arrow.core.Tuple2<F, B>
}

@JvmName("tailRecM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A, B> tailRecM(
    MF: Monoid<F>,
    arg0: A,
    arg1: Function1<A, Kind<Kind<ForTuple2, F>, Either<A, B>>>
): Tuple2<F, B> = arrow.core.Tuple2
   .monad<F>(MF)
   .tailRecM<A, B>(arg0, arg1) as arrow.core.Tuple2<F, B>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForTuple2, F>, A>.map(MF: Monoid<F>, arg1: Function1<A, B>): Tuple2<F, B> = arrow.core.Tuple2.monad<F>(MF).run {
  this@map.map<A, B>(arg1) as arrow.core.Tuple2<F, B>
}

/**
 * @see [Applicative.ap]
 */
@JvmName("ap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForTuple2, F>, A>.ap(MF: Monoid<F>, arg1: Kind<Kind<ForTuple2, F>, Function1<A, B>>): Tuple2<F, B> = arrow.core.Tuple2.monad<F>(MF).run {
  this@ap.ap<A, B>(arg1) as arrow.core.Tuple2<F, B>
}

@JvmName("flatten")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> Kind<Kind<ForTuple2, F>, Kind<Kind<ForTuple2, F>, A>>.flatten(MF: Monoid<F>): Tuple2<F, A> = arrow.core.Tuple2.monad<F>(MF).run {
  this@flatten.flatten<A>() as arrow.core.Tuple2<F, A>
}

@JvmName("followedBy")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForTuple2, F>, A>.followedBy(MF: Monoid<F>, arg1: Kind<Kind<ForTuple2, F>, B>): Tuple2<F, B> = arrow.core.Tuple2.monad<F>(MF).run {
  this@followedBy.followedBy<A, B>(arg1) as arrow.core.Tuple2<F, B>
}

@JvmName("followedByEval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForTuple2, F>, A>.followedByEval(MF: Monoid<F>, arg1: Eval<Kind<Kind<ForTuple2, F>, B>>): Tuple2<F, B> = arrow.core.Tuple2.monad<F>(MF).run {
  this@followedByEval.followedByEval<A, B>(arg1) as arrow.core.Tuple2<F, B>
}

@JvmName("effectM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForTuple2, F>, A>.effectM(MF: Monoid<F>, arg1: Function1<A, Kind<Kind<ForTuple2, F>, B>>): Tuple2<F, A> = arrow.core.Tuple2.monad<F>(MF).run {
  this@effectM.effectM<A, B>(arg1) as arrow.core.Tuple2<F, A>
}

@JvmName("forEffect")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForTuple2, F>, A>.forEffect(MF: Monoid<F>, arg1: Kind<Kind<ForTuple2, F>, B>): Tuple2<F, A> = arrow.core.Tuple2.monad<F>(MF).run {
  this@forEffect.forEffect<A, B>(arg1) as arrow.core.Tuple2<F, A>
}

@JvmName("forEffectEval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForTuple2, F>, A>.forEffectEval(MF: Monoid<F>, arg1: Eval<Kind<Kind<ForTuple2, F>, B>>): Tuple2<F, A> = arrow.core.Tuple2.monad<F>(MF).run {
  this@forEffectEval.forEffectEval<A, B>(arg1) as arrow.core.Tuple2<F, A>
}

@JvmName("mproduct")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForTuple2, F>, A>.mproduct(MF: Monoid<F>, arg1: Function1<A, Kind<Kind<ForTuple2, F>, B>>): Tuple2<F, Tuple2<A, B>> = arrow.core.Tuple2.monad<F>(MF).run {
  this@mproduct.mproduct<A, B>(arg1) as arrow.core.Tuple2<F, arrow.core.Tuple2<A, B>>
}

@JvmName("ifM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, B> Kind<Kind<ForTuple2, F>, Boolean>.ifM(
    MF: Monoid<F>,
    arg1: Function0<Kind<Kind<ForTuple2, F>, B>>,
    arg2: Function0<Kind<Kind<ForTuple2, F>, B>>
): Tuple2<F, B> = arrow.core.Tuple2.monad<F>(MF).run {
  this@ifM.ifM<B>(arg1, arg2) as arrow.core.Tuple2<F, B>
}

@JvmName("selectM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForTuple2, F>, Either<A, B>>.selectM(MF: Monoid<F>, arg1: Kind<Kind<ForTuple2, F>, Function1<A, B>>): Tuple2<F, B> = arrow.core.Tuple2.monad<F>(MF).run {
  this@selectM.selectM<A, B>(arg1) as arrow.core.Tuple2<F, B>
}

@JvmName("select")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForTuple2, F>, Either<A, B>>.select(MF: Monoid<F>, arg1: Kind<Kind<ForTuple2, F>, Function1<A, B>>): Tuple2<F, B> = arrow.core.Tuple2.monad<F>(MF).run {
  this@select.select<A, B>(arg1) as arrow.core.Tuple2<F, B>
}

/**
 * Entry point for monad bindings which enables for comprehension. The underlying implementation is based on coroutines.
 * A coroutine is initiated and suspended inside [MonadErrorContinuation] yielding to [Monad.flatMap]. Once all the flatMap binds are completed
 * the underlying monad is returned from the act of executing the coroutine
 */
@JvmName("binding")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> binding(MF: Monoid<F>, arg0: suspend MonadContinuation<Kind<ForTuple2, F>, *>.() -> A): Tuple2<F, A> = arrow.core.Tuple2
   .monad<F>(MF)
   .binding<A>(arg0) as arrow.core.Tuple2<F, A>

/**
 * ank_macro_hierarchy(arrow.typeclasses.Monad)
 *
 * [Monad] abstract over the ability to declare sequential computations that are dependent in the order or
 * the results of previous computations.
 *
 * Given a type constructor [F] with a value of [A] we can compose multiple operations of type
 * `Kind<F, ?>` where `?` denotes a value being transformed.
 *
 * This is true for all type constructors that can support the [Monad] type class including and not limited to
 * [IO], [DeferredK], [ObservableK], [Option], [Either], [List], [Try] ...
 *
 * [The Monad Tutorial](https://arrow-kt.io/docs/patterns/monads/)
 *
 */
fun <F> Companion.monad(MF: Monoid<F>): Tuple2Monad<F> = object : arrow.core.extensions.Tuple2Monad<F> { override fun MF(): arrow.typeclasses.Monoid<F> = MF }