package arrow.core.extensions.validated.applicative

import arrow.Kind
import arrow.core.ForValidated
import arrow.core.Validated
import arrow.core.Validated.Companion
import arrow.core.extensions.ValidatedApplicative
import arrow.typeclasses.Monoid
import arrow.typeclasses.Semigroup
import kotlin.Function1
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

@JvmName("just1")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> A.just(SE: Semigroup<E>): Validated<E, A> = arrow.core.Validated.applicative<E>(SE).run {
  this@just.just<A>() as arrow.core.Validated<E, A>
}

@JvmName("unit")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E> unit(SE: Semigroup<E>): Validated<E, Unit> = arrow.core.Validated
   .applicative<E>(SE)
   .unit() as arrow.core.Validated<E, kotlin.Unit>

@JvmName("map")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A, B> Kind<Kind<ForValidated, E>, A>.map(SE: Semigroup<E>, arg1: Function1<A, B>):
    Validated<E, B> = arrow.core.Validated.applicative<E>(SE).run {
  this@map.map<A, B>(arg1) as arrow.core.Validated<E, B>
}

@JvmName("replicate")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.replicate(SE: Semigroup<E>, arg1: Int): Validated<E,
    List<A>> = arrow.core.Validated.applicative<E>(SE).run {
  this@replicate.replicate<A>(arg1) as arrow.core.Validated<E, kotlin.collections.List<A>>
}

@JvmName("replicate")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.replicate(
  SE: Semigroup<E>,
  arg1: Int,
  arg2: Monoid<A>
): Validated<E, A> = arrow.core.Validated.applicative<E>(SE).run {
  this@replicate.replicate<A>(arg1, arg2) as arrow.core.Validated<E, A>
}

@Suppress(
  "UNCHECKED_CAST",
  "NOTHING_TO_INLINE"
)
inline fun <E> Companion.applicative(SE: Semigroup<E>): ValidatedApplicative<E> = object :
    arrow.core.extensions.ValidatedApplicative<E> { override fun SE():
    arrow.typeclasses.Semigroup<E> = SE }