package arrow.core.extensions.validated.order

import arrow.core.Tuple2
import arrow.core.Validated
import arrow.core.Validated.Companion
import arrow.core.extensions.ValidatedOrder
import arrow.typeclasses.Order
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("compareTo")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, R> Validated<L, R>.compareTo(
  OL: Order<L>,
  OR: Order<R>,
  arg1: Validated<L, R>
): Int = arrow.core.Validated.order<L, R>(OL, OR).run {
  this@compareTo.compareTo(arg1) as kotlin.Int
}

@JvmName("eqv")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, R> Validated<L, R>.eqv(
  OL: Order<L>,
  OR: Order<R>,
  arg1: Validated<L, R>
): Boolean = arrow.core.Validated.order<L, R>(OL, OR).run {
  this@eqv.eqv(arg1) as kotlin.Boolean
}

@JvmName("lt")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, R> Validated<L, R>.lt(
  OL: Order<L>,
  OR: Order<R>,
  arg1: Validated<L, R>
): Boolean = arrow.core.Validated.order<L, R>(OL, OR).run {
  this@lt.lt(arg1) as kotlin.Boolean
}

@JvmName("lte")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, R> Validated<L, R>.lte(
  OL: Order<L>,
  OR: Order<R>,
  arg1: Validated<L, R>
): Boolean = arrow.core.Validated.order<L, R>(OL, OR).run {
  this@lte.lte(arg1) as kotlin.Boolean
}

@JvmName("gt")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, R> Validated<L, R>.gt(
  OL: Order<L>,
  OR: Order<R>,
  arg1: Validated<L, R>
): Boolean = arrow.core.Validated.order<L, R>(OL, OR).run {
  this@gt.gt(arg1) as kotlin.Boolean
}

@JvmName("gte")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, R> Validated<L, R>.gte(
  OL: Order<L>,
  OR: Order<R>,
  arg1: Validated<L, R>
): Boolean = arrow.core.Validated.order<L, R>(OL, OR).run {
  this@gte.gte(arg1) as kotlin.Boolean
}

@JvmName("max")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, R> Validated<L, R>.max(
  OL: Order<L>,
  OR: Order<R>,
  arg1: Validated<L, R>
): Validated<L, R> = arrow.core.Validated.order<L, R>(OL, OR).run {
  this@max.max(arg1) as arrow.core.Validated<L, R>
}

@JvmName("min")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, R> Validated<L, R>.min(
  OL: Order<L>,
  OR: Order<R>,
  arg1: Validated<L, R>
): Validated<L, R> = arrow.core.Validated.order<L, R>(OL, OR).run {
  this@min.min(arg1) as arrow.core.Validated<L, R>
}

@JvmName("sort")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <L, R> Validated<L, R>.sort(
  OL: Order<L>,
  OR: Order<R>,
  arg1: Validated<L, R>
): Tuple2<Validated<L, R>, Validated<L, R>> = arrow.core.Validated.order<L, R>(OL, OR).run {
  this@sort.sort(arg1) as arrow.core.Tuple2<arrow.core.Validated<L, R>, arrow.core.Validated<L, R>>
}

@Suppress(
  "UNCHECKED_CAST",
  "NOTHING_TO_INLINE"
)
inline fun <L, R> Companion.order(OL: Order<L>, OR: Order<R>): ValidatedOrder<L, R> = object :
    arrow.core.extensions.ValidatedOrder<L, R> { override fun OL(): arrow.typeclasses.Order<L> = OL

  override fun OR(): arrow.typeclasses.Order<R> = OR }