package arrow.core.extensions.eval.functor

import arrow.Kind
import arrow.core.Eval
import arrow.core.Eval.Companion
import arrow.core.ForEval
import arrow.core.Tuple2
import arrow.core.extensions.EvalFunctor

/**
 * cached extension
 */
@PublishedApi()
internal val functor_singleton: EvalFunctor = object : arrow.core.extensions.EvalFunctor {}

/**
 *  Transform the [F] wrapped value [A] into [B] preserving the [F] structure
 *  Kind<F, A> -> Kind<F, B>
 *
 *  ```kotlin:ank:playground
 *  import arrow.core.*
 * import arrow.core.extensions.eval.functor.*
 * import arrow.core.*
 *
 *
 *  import arrow.core.extensions.eval.applicative.just
 *
 *  fun main(args: Array<String>) {
 *   val result =
 *   //sampleStart
 *   "Hello".just().map({ "$it World" })
 *   //sampleEnd
 *   println(result)
 *  }
 *  ```
 */
@JvmName("map")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
@Deprecated(
  "@extension kinded projected functions are deprecated",
  ReplaceWith(
    "map(arg1)",
    "arrow.core.map"
  ),
  DeprecationLevel.WARNING
)
fun <A, B> Kind<ForEval, A>.map(arg1: Function1<A, B>): Eval<B> =
  arrow.core.Eval.functor().run {
    this@map.map<A, B>(arg1) as arrow.core.Eval<B>
  }

@JvmName("imap")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
@Deprecated(
  "@extension kinded projected functions are deprecated",
  ReplaceWith(
    "map(arg1)",
    "arrow.core.map"
  ),
  DeprecationLevel.WARNING
)
fun <A, B> Kind<ForEval, A>.imap(arg1: Function1<A, B>, arg2: Function1<B, A>): Eval<B> =
  arrow.core.Eval.functor().run {
    this@imap.imap<A, B>(arg1, arg2) as arrow.core.Eval<B>
  }

/**
 *  Lifts a function `A -> B` to the [F] structure returning a polymorphic function
 *  that can be applied over all [F] values in the shape of Kind<F, A>
 *
 *  `A -> B -> Kind<F, A> -> Kind<F, B>`
 *
 *  ```kotlin:ank:playground
 *  import arrow.core.*
 * import arrow.core.extensions.eval.functor.*
 * import arrow.core.*
 *
 *
 *  import arrow.core.extensions.eval.applicative.just
 *
 *  fun main(args: Array<String>) {
 *   val result =
 *   //sampleStart
 *   lift({ s: CharSequence -> "$s World" })("Hello".just())
 *   //sampleEnd
 *   println(result)
 *  }
 *  ```
 */
@JvmName("lift")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
@Deprecated("Kind/type constructors will be deprecated, so this typeclass will no longer be available from 0.13.0")
fun <A, B> lift(arg0: Function1<A, B>): Function1<Kind<ForEval, A>, Kind<ForEval, B>> =
  arrow.core.Eval
    .functor()
    .lift<A, B>(arg0) as kotlin.Function1<arrow.Kind<arrow.core.ForEval, A>,
    arrow.Kind<arrow.core.ForEval, B>>

@JvmName("void")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
@Deprecated(
  "@extension kinded projected functions are deprecated",
  ReplaceWith(
    "map { Unit }",
    "arrow.core.map"
  ),
  DeprecationLevel.WARNING
)
fun <A> Kind<ForEval, A>.void(): Eval<Unit> =
  arrow.core.Eval.functor().run {
    this@void.void<A>() as arrow.core.Eval<kotlin.Unit>
  }

/**
 *  Applies [f] to an [A] inside [F] and returns the [F] structure with a tuple of the [A] value and the
 *  computed [B] value as result of applying [f]
 *
 *  Kind<F, A> -> Kind<F, Tuple2<A, B>>
 *
 *  ```kotlin:ank:playground
 *  import arrow.core.*
 * import arrow.core.extensions.eval.functor.*
 * import arrow.core.*
 *
 *
 *  import arrow.core.extensions.eval.applicative.just
 *
 *  fun main(args: Array<String>) {
 *   val result =
 *   //sampleStart
 *   "Hello".just().fproduct({ "$it World" })
 *   //sampleEnd
 *   println(result)
 *  }
 *  ```
 */
@JvmName("fproduct")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
@Deprecated(
  "@extension kinded projected functions are deprecated",
  ReplaceWith(
    "map { a -> Tuple2(a, f(a)) }",
    "arrow.core.map"
  ),
  DeprecationLevel.WARNING
)
fun <A, B> Kind<ForEval, A>.fproduct(arg1: Function1<A, B>): Eval<Tuple2<A, B>> =
  arrow.core.Eval.functor().run {
    this@fproduct.fproduct<A, B>(arg1) as arrow.core.Eval<arrow.core.Tuple2<A, B>>
  }

/**
 *  Replaces [A] inside [F] with [B] resulting in a Kind<F, B>
 *
 *  Kind<F, A> -> Kind<F, B>
 *
 *  ```kotlin:ank:playground
 *  import arrow.core.*
 * import arrow.core.extensions.eval.functor.*
 * import arrow.core.*
 *
 *
 *  import arrow.core.extensions.eval.applicative.just
 *
 *  fun main(args: Array<String>) {
 *   val result =
 *   //sampleStart
 *   "Hello World".just().mapConst("...")
 *   //sampleEnd
 *   println(result)
 *  }
 *  ```
 */
@JvmName("mapConst")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
@Deprecated(
  "@extension kinded projected functions are deprecated",
  ReplaceWith(
    "map { arg1 }",
    "arrow.core.map"
  ),
  DeprecationLevel.WARNING
)
fun <A, B> Kind<ForEval, A>.mapConst(arg1: B): Eval<B> =
  arrow.core.Eval.functor().run {
    this@mapConst.mapConst<A, B>(arg1) as arrow.core.Eval<B>
  }

/**
 *  Replaces the [B] value inside [F] with [A] resulting in a Kind<F, A>
 */
@JvmName("mapConst")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
@Deprecated(
  "@extension kinded projected functions are deprecated",
  ReplaceWith(
    "map { arg1 }",
    "arrow.core.map"
  ),
  DeprecationLevel.WARNING
)
fun <A, B> A.mapConst(arg1: Kind<ForEval, B>): Eval<A> =
  arrow.core.Eval.functor().run {
    this@mapConst.mapConst<A, B>(arg1) as arrow.core.Eval<A>
  }

/**
 *  Pairs [B] with [A] returning a Kind<F, Tuple2<B, A>>
 *
 *  Kind<F, A> -> Kind<F, Tuple2<B, A>>
 *
 *  ```kotlin:ank:playground
 *  import arrow.core.*
 * import arrow.core.extensions.eval.functor.*
 * import arrow.core.*
 *
 *
 *  import arrow.core.extensions.eval.applicative.just
 *
 *  fun main(args: Array<String>) {
 *   val result =
 *   //sampleStart
 *   "Hello".just().tupleLeft("World")
 *   //sampleEnd
 *   println(result)
 *  }
 *  ```
 */
@JvmName("tupleLeft")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
@Deprecated(
  "@extension kinded projected functions are deprecated",
  ReplaceWith(
    "map { a -> Tuple2(arg1, a) }",
    "arrow.core.map"
  ),
  DeprecationLevel.WARNING
)
fun <A, B> Kind<ForEval, A>.tupleLeft(arg1: B): Eval<Tuple2<B, A>> =
  arrow.core.Eval.functor().run {
    this@tupleLeft.tupleLeft<A, B>(arg1) as arrow.core.Eval<arrow.core.Tuple2<B, A>>
  }

/**
 *  Pairs [A] with [B] returning a Kind<F, Tuple2<A, B>>
 *
 *  Kind<F, A> -> Kind<F, Tuple2<A, B>>
 *
 *  ```kotlin:ank:playground
 *  import arrow.core.*
 * import arrow.core.extensions.eval.functor.*
 * import arrow.core.*
 *
 *
 *  import arrow.core.extensions.eval.applicative.just
 *
 *  fun main(args: Array<String>) {
 *   val result =
 *   //sampleStart
 *   "Hello".just().tupleRight("World")
 *   //sampleEnd
 *   println(result)
 *  }
 *  ```
 */
@JvmName("tupleRight")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
@Deprecated(
  "@extension kinded projected functions are deprecated",
  ReplaceWith(
    "map { a -> Tuple2(a, arg1) }",
    "arrow.core.map"
  ),
  DeprecationLevel.WARNING
)
fun <A, B> Kind<ForEval, A>.tupleRight(arg1: B): Eval<Tuple2<A, B>> =
  arrow.core.Eval.functor().run {
    this@tupleRight.tupleRight<A, B>(arg1) as arrow.core.Eval<arrow.core.Tuple2<A, B>>
  }

/**
 *  Given [A] is a sub type of [B], re-type this value from Kind<F, A> to Kind<F, B>
 *
 *  Kind<F, A> -> Kind<F, B>
 *
 *  ```kotlin:ank:playground
 *  import arrow.core.*
 * import arrow.core.extensions.eval.functor.*
 * import arrow.core.*
 *
 *
 *  import arrow.core.extensions.eval.applicative.just
 *  import arrow.Kind
 *
 *  fun main(args: Array<String>) {
 *   val result: Kind<*, CharSequence> =
 *   //sampleStart
 *   "Hello".just().map({ "$it World" }).widen()
 *   //sampleEnd
 *   println(result)
 *  }
 *  ```
 */
@JvmName("widen")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
@Deprecated(
  "@extension kinded projected functions are deprecated",
  ReplaceWith("this"),
  DeprecationLevel.WARNING
)
fun <B, A : B> Kind<ForEval, A>.widen(): Eval<B> =
  arrow.core.Eval.functor().run {
    this@widen.widen<B, A>() as arrow.core.Eval<B>
  }

@Suppress(
  "UNCHECKED_CAST",
  "NOTHING_TO_INLINE"
)
@Deprecated("Functor typeclass is deprecated. Use concrete methods on Eval")
inline fun Companion.functor(): EvalFunctor = functor_singleton
