package arrow.core.extensions

import arrow.Kind
import arrow.core.Eval
import arrow.core.Ior
import arrow.core.MapK
import arrow.core.MapKOf
import arrow.core.MapKPartialOf
import arrow.core.Option
import arrow.core.SetK
import arrow.core.Tuple2
import arrow.core.extensions.list.functorFilter.flattenOption
import arrow.core.extensions.mapk.eq.eq
import arrow.core.extensions.option.applicative.applicative
import arrow.core.extensions.set.foldable.foldLeft
import arrow.core.extensions.setk.eq.eq
import arrow.core.extensions.setk.hash.hash
import arrow.core.fix
import arrow.core.getOption
import arrow.core.identity
import arrow.core.k
import arrow.core.sequence
import arrow.core.toMap
import arrow.core.toOption
import arrow.core.toT
import arrow.core.updated
import arrow.typeclasses.Align
import arrow.typeclasses.Applicative
import arrow.typeclasses.Apply
import arrow.typeclasses.Eq
import arrow.typeclasses.EqDeprecation
import arrow.typeclasses.EqK
import arrow.typeclasses.Foldable
import arrow.typeclasses.Functor
import arrow.typeclasses.FunctorFilter
import arrow.typeclasses.Hash
import arrow.typeclasses.HashDeprecation
import arrow.typeclasses.Monoid
import arrow.typeclasses.Semialign
import arrow.typeclasses.Semigroup
import arrow.typeclasses.Show
import arrow.typeclasses.ShowDeprecation
import arrow.typeclasses.Traverse
import arrow.typeclasses.Zip
import arrow.typeclasses.Unalign
import arrow.typeclasses.Unzip

@Deprecated(
  message = "Functor typeclass is deprecated and will be removed in 0.13.0. Use concrete methods on Map.",
  level = DeprecationLevel.WARNING
)
interface MapKFunctor<K> : Functor<MapKPartialOf<K>> {
  override fun <A, B> Kind<MapKPartialOf<K>, A>.map(f: (A) -> B): MapK<K, B> = fix().map(f)
}

@Deprecated(
  message = "Foldable typeclass is deprecated and will be removed in 0.13.0. Use concrete methods on Map.",
  level = DeprecationLevel.WARNING
)
interface MapKFoldable<K> : Foldable<MapKPartialOf<K>> {

  override fun <A, B> Kind<MapKPartialOf<K>, A>.foldLeft(b: B, f: (B, A) -> B): B = fix().foldLeft(b, f)

  override fun <A, B> Kind<MapKPartialOf<K>, A>.foldRight(lb: Eval<B>, f: (A, Eval<B>) -> Eval<B>): Eval<B> =
    fix().foldRight(lb, f)
}

@Deprecated(
  message = "Traverse typeclass is deprecated and will be removed in 0.13.0. Use concrete methods on Map.",
  level = DeprecationLevel.WARNING
)
interface MapKTraverse<K> : Traverse<MapKPartialOf<K>>, MapKFoldable<K> {

  override fun <G, A, B> MapKOf<K, A>.traverse(AP: Applicative<G>, f: (A) -> Kind<G, B>): Kind<G, MapKOf<K, B>> =
    fix().traverse(AP, f)
}

@Deprecated(
  "Typeclass instance have been moved to the companion object of the typeclass."
)
interface MapKSemigroup<K, A> : Semigroup<MapK<K, A>> {

  fun SG(): Semigroup<A>

  override fun MapK<K, A>.combine(b: MapK<K, A>): MapK<K, A> = with(SG()) {
    if (fix().size < b.fix().size) fix().foldLeft<A>(b.fix()) { my, (k, b) -> my.updated(k, b.maybeCombine(my[k])) }
    else b.fix().foldLeft<A>(fix()) { my, (k, a) -> my.updated(k, a.maybeCombine(my[k])) }
  }
}

@Deprecated(
  message = "FunctorFilter typeclass is deprecated and will be removed in 0.13.0. Use concrete methods on Map.",
  level = DeprecationLevel.WARNING
)
interface MapKFunctorFilter<K> : FunctorFilter<MapKPartialOf<K>> {
  override fun <A, B> Kind<MapKPartialOf<K>, A>.filterMap(f: (A) -> Option<B>): Kind<MapKPartialOf<K>, B> =
    fix().map(f).sequence(Option.applicative()).fix().fold({ emptyMap<K, B>().k() }, ::identity)

  override fun <A, B> Kind<MapKPartialOf<K>, A>.map(f: (A) -> B): Kind<MapKPartialOf<K>, B> =
    fix().map(f)
}

@Deprecated(
  message = "Apply typeclass is deprecated and will be removed in 0.13.0. Use concrete methods on Map.",
  level = DeprecationLevel.WARNING
)
interface MapKApply<K> : Apply<MapKPartialOf<K>> {
  override fun <A, B> Kind<MapKPartialOf<K>, A>.ap(ff: Kind<MapKPartialOf<K>, (A) -> B>): Kind<MapKPartialOf<K>, B> =
    fix().ap(ff.fix())

  override fun <A, B> Kind<MapKPartialOf<K>, A>.map(f: (A) -> B): Kind<MapKPartialOf<K>, B> =
    fix().map(f)
}

@Deprecated(
  "Typeclass instance have been moved to the companion object of the typeclass."
)
interface MapKMonoid<K, A> : Monoid<MapK<K, A>>, MapKSemigroup<K, A> {

  override fun SG(): Semigroup<A>

  override fun empty(): MapK<K, A> = emptyMap<K, A>().k()
}

@Deprecated(
  message = EqDeprecation,
  level = DeprecationLevel.WARNING
)
interface MapKEq<K, A> : Eq<MapK<K, A>> {

  fun EQK(): Eq<K>

  fun EQA(): Eq<A>

  override fun MapK<K, A>.eqv(b: MapK<K, A>): Boolean =
    if (SetK.eq(EQK()).run { keys.k().eqv(b.keys.k()) }) {
      keys.map { key ->
        b[key]?.let {
          EQA().run { getValue(key).eqv(it) }
        } ?: false
      }.fold(true) { b1, b2 -> b1 && b2 }
    } else false
}

@Deprecated(
  message = ShowDeprecation,
  level = DeprecationLevel.WARNING
)
interface MapKShow<K, A> : Show<MapK<K, A>> {
  fun SK(): Show<K>
  fun SA(): Show<A>
  override fun MapK<K, A>.show(): String = show(SK(), SA())
}

@Deprecated(
  message = HashDeprecation,
  level = DeprecationLevel.WARNING
)
interface MapKHash<K, A> : Hash<MapK<K, A>> {
  fun HK(): Hash<K>
  fun HA(): Hash<A>

  override fun MapK<K, A>.hashWithSalt(salt: Int): Int =
    SetK.hash(HA()).run {
      values.toHashSet().k().hashWithSalt(salt)
    }.let { hash ->
      SetK.hash(HK()).run {
        keys.k().hashWithSalt(hash)
      }
    }
}

@Deprecated(
  message = "Semialign typeclass is deprecated and will be removed in 0.13.0. Use concrete methods on Map.",
  level = DeprecationLevel.WARNING
)
interface MapKSemialign<K> : Semialign<MapKPartialOf<K>>, MapKFunctor<K> {
  override fun <A, B> align(
    a: Kind<MapKPartialOf<K>, A>,
    b: Kind<MapKPartialOf<K>, B>
  ): Kind<MapKPartialOf<K>, Ior<A, B>> {
    val l = a.fix()
    val r = b.fix()
    val keys = l.keys + r.keys

    return keys.map { key ->
      Ior.fromOptions(l[key].toOption(), r[key].toOption()).map { key toT it }
    }.flattenOption().toMap().k()
  }
}

@Deprecated(
  message = "Align typeclass is deprecated and will be removed in 0.13.0. Use concrete methods on Map.",
  level = DeprecationLevel.WARNING
)
interface MapKAlign<K> : Align<MapKPartialOf<K>>, MapKSemialign<K> {
  override fun <A> empty(): Kind<MapKPartialOf<K>, A> = emptyMap<K, A>().k()
}

@Deprecated(
  message = "Unalign typeclass is deprecated and will be removed in 0.13.0. Use concrete methods on Map.",
  level = DeprecationLevel.WARNING
)
interface MapKUnalign<K> : Unalign<MapKPartialOf<K>>, MapKSemialign<K> {
  override fun <A, B> unalign(ior: Kind<MapKPartialOf<K>, Ior<A, B>>): Tuple2<Kind<MapKPartialOf<K>, A>, Kind<MapKPartialOf<K>, B>> =
    ior.fix().let { map ->
      map.entries.foldLeft(emptyMap<K, A>() toT emptyMap<K, B>()) { (ls, rs), (k, v) ->
        v.fold(
          { a -> ls.plus(k to a) toT rs },
          { b -> ls toT rs.plus(k to b) },
          { a, b -> ls.plus(k to a) toT rs.plus(k to b) }
        )
      }.bimap({ it.k() }, { it.k() })
    }
}

@Deprecated(
  message = "Zip typeclass is deprecated and will be removed in 0.13.0. Use concrete methods on Map.",
  level = DeprecationLevel.WARNING
)
interface MapKZip<K> : Zip<MapKPartialOf<K>>, MapKSemialign<K> {
  override fun <A, B> Kind<MapKPartialOf<K>, A>.zip(other: Kind<MapKPartialOf<K>, B>): Kind<MapKPartialOf<K>, Tuple2<A, B>> =
    (this.fix() to other.fix()).let { (ls, rs) ->
      val keys = (ls.keys.intersect(rs.keys))

      val values = keys.map { key -> ls.getOption(key).flatMap { l -> rs.getOption(key).map { key to (l toT it) } } }.flattenOption()

      return values.toMap().k()
    }
}

@Deprecated(
  message = "Unzip typeclass is deprecated and will be removed in 0.13.0. Use concrete methods on Map.",
  level = DeprecationLevel.WARNING
)
interface MapKUnzip<K> : Unzip<MapKPartialOf<K>>, MapKZip<K> {
  override fun <A, B> Kind<MapKPartialOf<K>, Tuple2<A, B>>.unzip(): Tuple2<Kind<MapKPartialOf<K>, A>, Kind<MapKPartialOf<K>, B>> =
    this.fix().let { map ->
      map.entries.fold(emptyMap<K, A>() toT emptyMap<K, B>()) { (ls, rs), (k, v) ->
        ls.plus(k to v.a) toT rs.plus(k to v.b)
      }
    }.bimap({ it.k() }, { it.k() })
}

@Deprecated(
  message = "EqK typeclass is deprecated and will be removed in 0.13.0. Use concrete methods on Map.",
  level = DeprecationLevel.WARNING
)
interface MapKEqK<K> : EqK<MapKPartialOf<K>> {

  fun EQK(): Eq<K>

  override fun <A> Kind<MapKPartialOf<K>, A>.eqK(other: Kind<MapKPartialOf<K>, A>, EQ: Eq<A>): Boolean =
    MapK.eq(EQK(), EQ).run {
      this@eqK.fix().eqv(other.fix())
    }
}
