/*
 * Decompiled with CFR 0.152.
 */
package arrow.typeclasses;

import arrow.core.Composition;
import arrow.core.Const;
import arrow.core.ConstKt;
import arrow.core.Either;
import arrow.core.EitherKt;
import arrow.core.Endo;
import arrow.core.MapKt;
import arrow.core.None;
import arrow.core.Option;
import arrow.core.OptionKt;
import arrow.core.SequenceKt;
import arrow.core.TupleNKt;
import arrow.core.Validated;
import arrow.core.ValidatedKt;
import arrow.typeclasses.Monoid;
import arrow.typeclasses.Semigroup;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\bf\u0018\u0000 \u000b*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u000bJ\u001b\u0010\u0003\u001a\u00028\u00002\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u0007\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\bJ\u0017\u0010\u0003\u001a\u00028\u0000*\b\u0012\u0004\u0012\u00028\u00000\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\f"}, d2={"Larrow/typeclasses/Monoid;", "A", "Larrow/typeclasses/Semigroup;", "combineAll", "elems", "", "(Ljava/util/List;)Ljava/lang/Object;", "empty", "()Ljava/lang/Object;", "", "(Ljava/util/Collection;)Ljava/lang/Object;", "Companion", "arrow-core"})
public interface Monoid<A>
extends Semigroup<A> {
    @NotNull
    public static final Companion Companion = arrow.typeclasses.Monoid$Companion.$$INSTANCE;

    public A empty();

    public A combineAll(@NotNull Collection<? extends A> var1);

    public A combineAll(@NotNull List<? extends A> var1);

    @JvmStatic
    @JvmName(name="Boolean")
    @NotNull
    public static Monoid<Boolean> Boolean() {
        return Companion.Boolean();
    }

    @JvmStatic
    @JvmName(name="Byte")
    @NotNull
    public static Monoid<Byte> Byte() {
        return Companion.Byte();
    }

    @JvmStatic
    @JvmName(name="Double")
    @NotNull
    public static Monoid<Double> Double() {
        return Companion.Double();
    }

    @JvmStatic
    @JvmName(name="Integer")
    @NotNull
    public static Monoid<Integer> Integer() {
        return Companion.Integer();
    }

    @JvmStatic
    @JvmName(name="Long")
    @NotNull
    public static Monoid<Long> Long() {
        return Companion.Long();
    }

    @JvmStatic
    @JvmName(name="Short")
    @NotNull
    public static Monoid<Short> Short() {
        return Companion.Short();
    }

    @JvmStatic
    @JvmName(name="Float")
    @NotNull
    public static Monoid<Float> Float() {
        return Companion.Float();
    }

    @JvmStatic
    @NotNull
    public static <A> Monoid<List<A>> list() {
        return Companion.list();
    }

    @JvmStatic
    @NotNull
    public static <A> Monoid<Sequence<A>> sequence() {
        return Companion.sequence();
    }

    @JvmStatic
    @NotNull
    public static Monoid<String> string() {
        return Companion.string();
    }

    @JvmStatic
    @NotNull
    public static <A, B> Monoid<Either<A, B>> either(@NotNull Monoid<A> MA, @NotNull Monoid<B> MB) {
        return Companion.either(MA, MB);
    }

    @JvmStatic
    @NotNull
    public static <A> Monoid<Endo<A>> endo() {
        return Companion.endo();
    }

    @JvmStatic
    @JvmName(name="constant")
    @NotNull
    public static <A, T> Monoid<Const<A, T>> constant(@NotNull Monoid<A> MA) {
        return Companion.constant(MA);
    }

    @JvmStatic
    @NotNull
    public static <K, A> Monoid<Map<K, A>> map(@NotNull Semigroup<A> SG) {
        return Companion.map(SG);
    }

    @JvmStatic
    @NotNull
    public static <A> Monoid<Option<A>> option(@NotNull Semigroup<A> MA) {
        return Companion.option(MA);
    }

    @JvmStatic
    @NotNull
    public static <E, A> Monoid<Validated<E, A>> validated(@NotNull Semigroup<E> SE, @NotNull Monoid<A> MA) {
        return Companion.validated(SE, MA);
    }

    @JvmStatic
    @NotNull
    public static <A, B> Monoid<Pair<A, B>> pair(@NotNull Monoid<A> MA, @NotNull Monoid<B> MB) {
        return Companion.pair(MA, MB);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        public static <A> A combineAll(@NotNull Monoid<A> $this, @NotNull Collection<? extends A> $this$combineAll) {
            Object object;
            Intrinsics.checkNotNullParameter($this$combineAll, (String)"$this$combineAll");
            if ($this$combineAll.isEmpty()) {
                object = $this.empty();
            } else {
                Iterable $this$reduce$iv = $this$combineAll;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void b;
                    Object t = iterator$iv.next();
                    Object a = accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = $this.combine((void)a, b);
                }
                object = accumulator$iv;
            }
            return object;
        }

        public static <A> A combineAll(@NotNull Monoid<A> $this, @NotNull List<? extends A> elems) {
            Intrinsics.checkNotNullParameter(elems, (String)"elems");
            return $this.combineAll((Collection)elems);
        }

        public static <A> A plus(@NotNull Monoid<A> $this, A $this$plus, A b) {
            return Semigroup.DefaultImpls.plus($this, $this$plus, b);
        }

        public static <A> A maybeCombine(@NotNull Monoid<A> $this, A $this$maybeCombine, @Nullable A b) {
            return Semigroup.DefaultImpls.maybeCombine($this, $this$maybeCombine, b);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0086\u0003\u0018\u00002\u00020\u0001:\u000f89:;<=>?@ABCDEFB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007\u00a2\u0006\u0002\b\u0006J\u0013\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0004H\u0007\u00a2\u0006\u0002\b\tJ9\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0\u000b0\u0004\"\u0004\b\u0001\u0010\f\"\u0004\b\u0002\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u0004H\u0007\u00a2\u0006\u0002\b\u000fJ\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004H\u0007\u00a2\u0006\u0002\b\u0012JB\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\u00150\u00140\u0004\"\u0004\b\u0001\u0010\f\"\u0004\b\u0002\u0010\u00152\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0004H\u0007J\u001a\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u00180\u0004\"\u0004\b\u0001\u0010\fH\u0007J\u0013\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0004H\u0007\u00a2\u0006\u0002\b\u001bJ\u0013\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0004H\u0007\u00a2\u0006\u0002\b\u001eJ\u001a\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0 0\u0004\"\u0004\b\u0001\u0010\fH\u0007J\u0013\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0004H\u0007\u00a2\u0006\u0002\b#J4\u0010$\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u0002H\f0%0\u0004\"\u0004\b\u0001\u0010&\"\u0004\b\u0002\u0010\f2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H\f0(H\u0007J(\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0*0\u0004\"\u0004\b\u0001\u0010\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0(H\u0007JB\u0010+\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\u00150,0\u0004\"\u0004\b\u0001\u0010\f\"\u0004\b\u0002\u0010\u00152\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0004H\u0007J\u001a\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0.0\u0004\"\u0004\b\u0001\u0010\fH\u0007J\u0013\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u0004H\u0007\u00a2\u0006\u0002\b1J\u000e\u00102\u001a\b\u0012\u0004\u0012\u0002030\u0004H\u0007JB\u00104\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H6\u0012\u0004\u0012\u0002H\f050\u0004\"\u0004\b\u0001\u00106\"\u0004\b\u0002\u0010\f2\f\u00107\u001a\b\u0012\u0004\u0012\u0002H60(2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u0004H\u0007\u00a8\u0006G"}, d2={"Larrow/typeclasses/Monoid$Companion;", "", "()V", "boolean", "Larrow/typeclasses/Monoid;", "", "Boolean", "byte", "", "Byte", "const", "Larrow/core/Const;", "A", "T", "MA", "constant", "double", "", "Double", "either", "Larrow/core/Either;", "B", "MB", "endo", "Larrow/core/Endo;", "float", "", "Float", "int", "", "Integer", "list", "", "long", "", "Long", "map", "", "K", "SG", "Larrow/typeclasses/Semigroup;", "option", "Larrow/core/Option;", "pair", "Lkotlin/Pair;", "sequence", "Lkotlin/sequences/Sequence;", "short", "", "Short", "string", "", "validated", "Larrow/core/Validated;", "E", "SE", "AndMonoid", "ByteMonoid", "DoubleMonoid", "EitherMonoid", "FloatMonoid", "IntMonoid", "ListMonoid", "LongMonoid", "MapMonoid", "OptionMonoid", "PairMonoid", "SequenceMonoid", "ShortMonoid", "StringMonoid", "ValidatedMonoid", "arrow-core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        @JvmStatic
        @JvmName(name="Boolean")
        @NotNull
        public final Monoid<Boolean> Boolean() {
            return AndMonoid.INSTANCE;
        }

        @JvmStatic
        @JvmName(name="Byte")
        @NotNull
        public final Monoid<Byte> Byte() {
            return ByteMonoid.INSTANCE;
        }

        @JvmStatic
        @JvmName(name="Double")
        @NotNull
        public final Monoid<Double> Double() {
            return DoubleMonoid.INSTANCE;
        }

        @JvmStatic
        @JvmName(name="Integer")
        @NotNull
        public final Monoid<Integer> Integer() {
            return IntMonoid.INSTANCE;
        }

        @JvmStatic
        @JvmName(name="Long")
        @NotNull
        public final Monoid<Long> Long() {
            return LongMonoid.INSTANCE;
        }

        @JvmStatic
        @JvmName(name="Short")
        @NotNull
        public final Monoid<Short> Short() {
            return ShortMonoid.INSTANCE;
        }

        @JvmStatic
        @JvmName(name="Float")
        @NotNull
        public final Monoid<Float> Float() {
            return FloatMonoid.INSTANCE;
        }

        @JvmStatic
        @NotNull
        public final <A> Monoid<List<A>> list() {
            ListMonoid listMonoid = ListMonoid.INSTANCE;
            if (listMonoid == null) {
                throw new NullPointerException("null cannot be cast to non-null type arrow.typeclasses.Monoid<kotlin.collections.List<A>>");
            }
            return listMonoid;
        }

        @JvmStatic
        @NotNull
        public final <A> Monoid<Sequence<A>> sequence() {
            SequenceMonoid sequenceMonoid = SequenceMonoid.INSTANCE;
            if (sequenceMonoid == null) {
                throw new NullPointerException("null cannot be cast to non-null type arrow.typeclasses.Monoid<kotlin.sequences.Sequence<A>>");
            }
            return sequenceMonoid;
        }

        @JvmStatic
        @NotNull
        public final Monoid<String> string() {
            return StringMonoid.INSTANCE;
        }

        @JvmStatic
        @NotNull
        public final <A, B> Monoid<Either<A, B>> either(@NotNull Monoid<A> MA, @NotNull Monoid<B> MB) {
            Intrinsics.checkNotNullParameter(MA, (String)"MA");
            Intrinsics.checkNotNullParameter(MB, (String)"MB");
            return new EitherMonoid<A, B>(MA, MB);
        }

        @JvmStatic
        @NotNull
        public final <A> Monoid<Endo<A>> endo() {
            return new Monoid<Endo<A>>(){

                @NotNull
                public Endo<A> empty() {
                    return new Endo<A>(endo.empty.1.INSTANCE);
                }

                @NotNull
                public Endo<A> combine(@NotNull Endo<A> $this$combine, @NotNull Endo<A> g) {
                    Intrinsics.checkNotNullParameter($this$combine, (String)"$this$combine");
                    Intrinsics.checkNotNullParameter(g, (String)"g");
                    return new Endo<A>(Composition.compose($this$combine.getF(), g.getF()));
                }

                @NotNull
                public Endo<A> combineAll(@NotNull Collection<Endo<A>> $this$combineAll) {
                    Intrinsics.checkNotNullParameter($this$combineAll, (String)"$this$combineAll");
                    return DefaultImpls.combineAll(this, $this$combineAll);
                }

                @NotNull
                public Endo<A> combineAll(@NotNull List<Endo<A>> elems) {
                    Intrinsics.checkNotNullParameter(elems, (String)"elems");
                    return DefaultImpls.combineAll(this, elems);
                }

                @NotNull
                public Endo<A> plus(@NotNull Endo<A> $this$plus, @NotNull Endo<A> b) {
                    Intrinsics.checkNotNullParameter($this$plus, (String)"$this$plus");
                    Intrinsics.checkNotNullParameter(b, (String)"b");
                    return DefaultImpls.plus(this, $this$plus, b);
                }

                @NotNull
                public Endo<A> maybeCombine(@NotNull Endo<A> $this$maybeCombine, @Nullable Endo<A> b) {
                    Intrinsics.checkNotNullParameter($this$maybeCombine, (String)"$this$maybeCombine");
                    return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
                }
            };
        }

        @JvmStatic
        @JvmName(name="constant")
        @NotNull
        public final <A, T> Monoid<Const<A, T>> constant(@NotNull Monoid<A> MA) {
            Intrinsics.checkNotNullParameter(MA, (String)"MA");
            return new Monoid<Const<A, ? extends T>>(MA){
                final /* synthetic */ Monoid $MA;

                @NotNull
                public Const<A, T> empty() {
                    return new Const<A, T>(this.$MA.empty());
                }

                @NotNull
                public Const<A, T> combine(@NotNull Const<A, ? extends T> $this$combine, @NotNull Const<A, ? extends T> b) {
                    Intrinsics.checkNotNullParameter($this$combine, (String)"$this$combine");
                    Intrinsics.checkNotNullParameter(b, (String)"b");
                    return ConstKt.combine($this$combine, this.$MA, b);
                }
                {
                    this.$MA = $captured_local_variable$0;
                }

                @NotNull
                public Const<A, T> combineAll(@NotNull Collection<? extends Const<A, ? extends T>> $this$combineAll) {
                    Intrinsics.checkNotNullParameter($this$combineAll, (String)"$this$combineAll");
                    return DefaultImpls.combineAll(this, $this$combineAll);
                }

                @NotNull
                public Const<A, T> combineAll(@NotNull List<? extends Const<A, ? extends T>> elems) {
                    Intrinsics.checkNotNullParameter(elems, (String)"elems");
                    return DefaultImpls.combineAll(this, elems);
                }

                @NotNull
                public Const<A, T> plus(@NotNull Const<A, ? extends T> $this$plus, @NotNull Const<A, ? extends T> b) {
                    Intrinsics.checkNotNullParameter($this$plus, (String)"$this$plus");
                    Intrinsics.checkNotNullParameter(b, (String)"b");
                    return DefaultImpls.plus(this, $this$plus, b);
                }

                @NotNull
                public Const<A, T> maybeCombine(@NotNull Const<A, ? extends T> $this$maybeCombine, @Nullable Const<A, ? extends T> b) {
                    Intrinsics.checkNotNullParameter($this$maybeCombine, (String)"$this$maybeCombine");
                    return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
                }
            };
        }

        @JvmStatic
        @NotNull
        public final <K, A> Monoid<Map<K, A>> map(@NotNull Semigroup<A> SG) {
            Intrinsics.checkNotNullParameter(SG, (String)"SG");
            return new MapMonoid(SG);
        }

        @JvmStatic
        @NotNull
        public final <A> Monoid<Option<A>> option(@NotNull Semigroup<A> MA) {
            Intrinsics.checkNotNullParameter(MA, (String)"MA");
            return new OptionMonoid<A>(MA);
        }

        @JvmStatic
        @NotNull
        public final <E, A> Monoid<Validated<E, A>> validated(@NotNull Semigroup<E> SE, @NotNull Monoid<A> MA) {
            Intrinsics.checkNotNullParameter(SE, (String)"SE");
            Intrinsics.checkNotNullParameter(MA, (String)"MA");
            return new ValidatedMonoid<E, A>(SE, MA);
        }

        @JvmStatic
        @NotNull
        public final <A, B> Monoid<Pair<A, B>> pair(@NotNull Monoid<A> MA, @NotNull Monoid<B> MB) {
            Intrinsics.checkNotNullParameter(MA, (String)"MA");
            Intrinsics.checkNotNullParameter(MB, (String)"MB");
            return new PairMonoid<A, B>(MA, MB);
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u0001*\u0004\b\u0002\u0010\u00022\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00040\u0003B!\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004H\u0016J8\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004*\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00042\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Larrow/typeclasses/Monoid$Companion$ValidatedMonoid;", "A", "B", "Larrow/typeclasses/Monoid;", "Larrow/core/Validated;", "SA", "Larrow/typeclasses/Semigroup;", "MB", "(Larrow/typeclasses/Semigroup;Larrow/typeclasses/Monoid;)V", "empty", "Larrow/core/Validated$Valid;", "combine", "b", "arrow-core"})
        private static final class ValidatedMonoid<A, B>
        implements Monoid<Validated<? extends A, ? extends B>> {
            private final Validated.Valid<B> empty;
            private final Semigroup<A> SA;
            private final Monoid<B> MB;

            @Override
            @NotNull
            public Validated<A, B> empty() {
                return this.empty;
            }

            @Override
            @NotNull
            public Validated<A, B> combine(@NotNull Validated<? extends A, ? extends B> $this$combine, @NotNull Validated<? extends A, ? extends B> b) {
                Intrinsics.checkNotNullParameter($this$combine, (String)"$this$combine");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return ValidatedKt.combine($this$combine, this.SA, this.MB, b);
            }

            public ValidatedMonoid(@NotNull Semigroup<A> SA, @NotNull Monoid<B> MB) {
                Intrinsics.checkNotNullParameter(SA, (String)"SA");
                Intrinsics.checkNotNullParameter(MB, (String)"MB");
                this.SA = SA;
                this.MB = MB;
                this.empty = new Validated.Valid<B>(this.MB.empty());
            }

            @Override
            @NotNull
            public Validated<A, B> combineAll(@NotNull Collection<? extends Validated<? extends A, ? extends B>> $this$combineAll) {
                Intrinsics.checkNotNullParameter($this$combineAll, (String)"$this$combineAll");
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @NotNull
            public Validated<A, B> combineAll(@NotNull List<? extends Validated<? extends A, ? extends B>> elems) {
                Intrinsics.checkNotNullParameter(elems, (String)"elems");
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Validated<A, B> plus(@NotNull Validated<? extends A, ? extends B> $this$plus, @NotNull Validated<? extends A, ? extends B> b) {
                Intrinsics.checkNotNullParameter($this$plus, (String)"$this$plus");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public Validated<A, B> maybeCombine(@NotNull Validated<? extends A, ? extends B> $this$maybeCombine, @Nullable Validated<? extends A, ? extends B> b) {
                Intrinsics.checkNotNullParameter($this$maybeCombine, (String)"$this$maybeCombine");
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003H\u0016J&\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003*\b\u0012\u0004\u0012\u00028\u00010\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003H\u0016J(\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003*\b\u0012\u0004\u0012\u00028\u00010\u00032\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0003H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Larrow/typeclasses/Monoid$Companion$OptionMonoid;", "A", "Larrow/typeclasses/Monoid;", "Larrow/core/Option;", "MA", "Larrow/typeclasses/Semigroup;", "(Larrow/typeclasses/Semigroup;)V", "empty", "combine", "b", "maybeCombine", "arrow-core"})
        private static final class OptionMonoid<A>
        implements Monoid<Option<? extends A>> {
            private final Semigroup<A> MA;

            @Override
            @NotNull
            public Option<A> combine(@NotNull Option<? extends A> $this$combine, @NotNull Option<? extends A> b) {
                Intrinsics.checkNotNullParameter($this$combine, (String)"$this$combine");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return OptionKt.combine($this$combine, this.MA, b);
            }

            @Override
            @NotNull
            public Option<A> maybeCombine(@NotNull Option<? extends A> $this$maybeCombine, @Nullable Option<? extends A> b) {
                Option<? extends A> option2;
                block3: {
                    block2: {
                        Intrinsics.checkNotNullParameter($this$maybeCombine, (String)"$this$maybeCombine");
                        option2 = b;
                        if (option2 == null) break block2;
                        Option<? extends A> option3 = option2;
                        boolean bl = false;
                        boolean bl2 = false;
                        Option<? extends A> it = option3;
                        boolean bl3 = false;
                        option2 = OptionKt.combine($this$maybeCombine, this.MA, it);
                        if (option2 != null) break block3;
                    }
                    option2 = $this$maybeCombine;
                }
                return option2;
            }

            @Override
            @NotNull
            public Option<A> empty() {
                return None.INSTANCE;
            }

            public OptionMonoid(@NotNull Semigroup<A> MA) {
                Intrinsics.checkNotNullParameter(MA, (String)"MA");
                this.MA = MA;
            }

            @Override
            @NotNull
            public Option<A> combineAll(@NotNull Collection<? extends Option<? extends A>> $this$combineAll) {
                Intrinsics.checkNotNullParameter($this$combineAll, (String)"$this$combineAll");
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @NotNull
            public Option<A> combineAll(@NotNull List<? extends Option<? extends A>> elems) {
                Intrinsics.checkNotNullParameter(elems, (String)"elems");
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Option<A> plus(@NotNull Option<? extends A> $this$plus, @NotNull Option<? extends A> b) {
                Intrinsics.checkNotNullParameter($this$plus, (String)"$this$plus");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return DefaultImpls.plus(this, $this$plus, b);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u0001*\u0004\b\u0002\u0010\u00022\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00040\u0003B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004H\u0016J8\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004*\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Larrow/typeclasses/Monoid$Companion$MapMonoid;", "K", "A", "Larrow/typeclasses/Monoid;", "", "SG", "Larrow/typeclasses/Semigroup;", "(Larrow/typeclasses/Semigroup;)V", "empty", "combine", "b", "arrow-core"})
        private static final class MapMonoid<K, A>
        implements Monoid<Map<K, ? extends A>> {
            private final Semigroup<A> SG;

            @Override
            @NotNull
            public Map<K, A> empty() {
                return MapsKt.emptyMap();
            }

            @Override
            @NotNull
            public Map<K, A> combine(@NotNull Map<K, ? extends A> $this$combine, @NotNull Map<K, ? extends A> b) {
                Intrinsics.checkNotNullParameter($this$combine, (String)"$this$combine");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return MapKt.combine($this$combine, this.SG, b);
            }

            public MapMonoid(@NotNull Semigroup<A> SG) {
                Intrinsics.checkNotNullParameter(SG, (String)"SG");
                this.SG = SG;
            }

            @Override
            @NotNull
            public Map<K, A> combineAll(@NotNull Collection<? extends Map<K, ? extends A>> $this$combineAll) {
                Intrinsics.checkNotNullParameter($this$combineAll, (String)"$this$combineAll");
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @NotNull
            public Map<K, A> combineAll(@NotNull List<? extends Map<K, ? extends A>> elems) {
                Intrinsics.checkNotNullParameter(elems, (String)"elems");
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Map<K, A> plus(@NotNull Map<K, ? extends A> $this$plus, @NotNull Map<K, ? extends A> b) {
                Intrinsics.checkNotNullParameter($this$plus, (String)"$this$plus");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public Map<K, A> maybeCombine(@NotNull Map<K, ? extends A> $this$maybeCombine, @Nullable Map<K, ? extends A> b) {
                Intrinsics.checkNotNullParameter($this$maybeCombine, (String)"$this$maybeCombine");
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\u0006\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Larrow/typeclasses/Monoid$Companion$AndMonoid;", "Larrow/typeclasses/Monoid;", "", "()V", "empty", "()Ljava/lang/Boolean;", "combine", "b", "(ZZ)Ljava/lang/Boolean;", "arrow-core"})
        private static final class AndMonoid
        implements Monoid<Boolean> {
            @NotNull
            public static final AndMonoid INSTANCE;

            @Override
            @NotNull
            public Boolean combine(boolean $this$combine, boolean b) {
                return $this$combine && b;
            }

            @Override
            @NotNull
            public Boolean empty() {
                return true;
            }

            private AndMonoid() {
            }

            static {
                AndMonoid andMonoid;
                INSTANCE = andMonoid = new AndMonoid();
            }

            @Override
            @NotNull
            public Boolean combineAll(@NotNull Collection<Boolean> $this$combineAll) {
                Intrinsics.checkNotNullParameter($this$combineAll, (String)"$this$combineAll");
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @NotNull
            public Boolean combineAll(@NotNull List<Boolean> elems) {
                Intrinsics.checkNotNullParameter(elems, (String)"elems");
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Boolean plus(boolean $this$plus, boolean b) {
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public Boolean maybeCombine(boolean $this$maybeCombine, @Nullable Boolean b) {
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0007\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\u0006\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Larrow/typeclasses/Monoid$Companion$ByteMonoid;", "Larrow/typeclasses/Monoid;", "", "()V", "empty", "()Ljava/lang/Byte;", "combine", "b", "(BB)Ljava/lang/Byte;", "arrow-core"})
        private static final class ByteMonoid
        implements Monoid<Byte> {
            @NotNull
            public static final ByteMonoid INSTANCE;

            @Override
            @NotNull
            public Byte empty() {
                return (byte)0;
            }

            @Override
            @NotNull
            public Byte combine(byte $this$combine, byte b) {
                return (byte)($this$combine + b);
            }

            private ByteMonoid() {
            }

            static {
                ByteMonoid byteMonoid;
                INSTANCE = byteMonoid = new ByteMonoid();
            }

            @Override
            @NotNull
            public Byte combineAll(@NotNull Collection<Byte> $this$combineAll) {
                Intrinsics.checkNotNullParameter($this$combineAll, (String)"$this$combineAll");
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @NotNull
            public Byte combineAll(@NotNull List<Byte> elems) {
                Intrinsics.checkNotNullParameter(elems, (String)"elems");
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Byte plus(byte $this$plus, byte b) {
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public Byte maybeCombine(byte $this$maybeCombine, @Nullable Byte b) {
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\u0006\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Larrow/typeclasses/Monoid$Companion$DoubleMonoid;", "Larrow/typeclasses/Monoid;", "", "()V", "empty", "()Ljava/lang/Double;", "combine", "b", "(DD)Ljava/lang/Double;", "arrow-core"})
        private static final class DoubleMonoid
        implements Monoid<Double> {
            @NotNull
            public static final DoubleMonoid INSTANCE;

            @Override
            @NotNull
            public Double empty() {
                return 0.0;
            }

            @Override
            @NotNull
            public Double combine(double $this$combine, double b) {
                return $this$combine + b;
            }

            private DoubleMonoid() {
            }

            static {
                DoubleMonoid doubleMonoid;
                INSTANCE = doubleMonoid = new DoubleMonoid();
            }

            @Override
            @NotNull
            public Double combineAll(@NotNull Collection<Double> $this$combineAll) {
                Intrinsics.checkNotNullParameter($this$combineAll, (String)"$this$combineAll");
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @NotNull
            public Double combineAll(@NotNull List<Double> elems) {
                Intrinsics.checkNotNullParameter(elems, (String)"elems");
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Double plus(double $this$plus, double b) {
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public Double maybeCombine(double $this$maybeCombine, @Nullable Double b) {
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\u0006\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Larrow/typeclasses/Monoid$Companion$IntMonoid;", "Larrow/typeclasses/Monoid;", "", "()V", "empty", "()Ljava/lang/Integer;", "combine", "b", "(II)Ljava/lang/Integer;", "arrow-core"})
        private static final class IntMonoid
        implements Monoid<Integer> {
            @NotNull
            public static final IntMonoid INSTANCE;

            @Override
            @NotNull
            public Integer empty() {
                return 0;
            }

            @Override
            @NotNull
            public Integer combine(int $this$combine, int b) {
                return $this$combine + b;
            }

            private IntMonoid() {
            }

            static {
                IntMonoid intMonoid;
                INSTANCE = intMonoid = new IntMonoid();
            }

            @Override
            @NotNull
            public Integer combineAll(@NotNull Collection<Integer> $this$combineAll) {
                Intrinsics.checkNotNullParameter($this$combineAll, (String)"$this$combineAll");
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @NotNull
            public Integer combineAll(@NotNull List<Integer> elems) {
                Intrinsics.checkNotNullParameter(elems, (String)"elems");
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Integer plus(int $this$plus, int b) {
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public Integer maybeCombine(int $this$maybeCombine, @Nullable Integer b) {
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\u0006\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Larrow/typeclasses/Monoid$Companion$LongMonoid;", "Larrow/typeclasses/Monoid;", "", "()V", "empty", "()Ljava/lang/Long;", "combine", "b", "(JJ)Ljava/lang/Long;", "arrow-core"})
        private static final class LongMonoid
        implements Monoid<Long> {
            @NotNull
            public static final LongMonoid INSTANCE;

            @Override
            @NotNull
            public Long empty() {
                return 0L;
            }

            @Override
            @NotNull
            public Long combine(long $this$combine, long b) {
                return $this$combine + b;
            }

            private LongMonoid() {
            }

            static {
                LongMonoid longMonoid;
                INSTANCE = longMonoid = new LongMonoid();
            }

            @Override
            @NotNull
            public Long combineAll(@NotNull Collection<Long> $this$combineAll) {
                Intrinsics.checkNotNullParameter($this$combineAll, (String)"$this$combineAll");
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @NotNull
            public Long combineAll(@NotNull List<Long> elems) {
                Intrinsics.checkNotNullParameter(elems, (String)"elems");
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Long plus(long $this$plus, long b) {
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public Long maybeCombine(long $this$maybeCombine, @Nullable Long b) {
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0002\b\u0007\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\u0006\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Larrow/typeclasses/Monoid$Companion$ShortMonoid;", "Larrow/typeclasses/Monoid;", "", "()V", "empty", "()Ljava/lang/Short;", "combine", "b", "(SS)Ljava/lang/Short;", "arrow-core"})
        private static final class ShortMonoid
        implements Monoid<Short> {
            @NotNull
            public static final ShortMonoid INSTANCE;

            @Override
            @NotNull
            public Short empty() {
                return (short)0;
            }

            @Override
            @NotNull
            public Short combine(short $this$combine, short b) {
                return (short)($this$combine + b);
            }

            private ShortMonoid() {
            }

            static {
                ShortMonoid shortMonoid;
                INSTANCE = shortMonoid = new ShortMonoid();
            }

            @Override
            @NotNull
            public Short combineAll(@NotNull Collection<Short> $this$combineAll) {
                Intrinsics.checkNotNullParameter($this$combineAll, (String)"$this$combineAll");
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @NotNull
            public Short combineAll(@NotNull List<Short> elems) {
                Intrinsics.checkNotNullParameter(elems, (String)"elems");
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Short plus(short $this$plus, short b) {
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public Short maybeCombine(short $this$maybeCombine, @Nullable Short b) {
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\u0006\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Larrow/typeclasses/Monoid$Companion$FloatMonoid;", "Larrow/typeclasses/Monoid;", "", "()V", "empty", "()Ljava/lang/Float;", "combine", "b", "(FF)Ljava/lang/Float;", "arrow-core"})
        private static final class FloatMonoid
        implements Monoid<Float> {
            @NotNull
            public static final FloatMonoid INSTANCE;

            @Override
            @NotNull
            public Float empty() {
                return Float.valueOf(0.0f);
            }

            @Override
            @NotNull
            public Float combine(float $this$combine, float b) {
                return Float.valueOf($this$combine + b);
            }

            private FloatMonoid() {
            }

            static {
                FloatMonoid floatMonoid;
                INSTANCE = floatMonoid = new FloatMonoid();
            }

            @Override
            @NotNull
            public Float combineAll(@NotNull Collection<Float> $this$combineAll) {
                Intrinsics.checkNotNullParameter($this$combineAll, (String)"$this$combineAll");
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @NotNull
            public Float combineAll(@NotNull List<Float> elems) {
                Intrinsics.checkNotNullParameter(elems, (String)"elems");
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Float plus(float $this$plus, float b) {
                return DefaultImpls.plus(this, Float.valueOf($this$plus), Float.valueOf(b));
            }

            @Override
            @NotNull
            public Float maybeCombine(float $this$maybeCombine, @Nullable Float b) {
                return DefaultImpls.maybeCombine(this, Float.valueOf($this$maybeCombine), b);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0002H\u0016J\u0014\u0010\u0005\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Larrow/typeclasses/Monoid$Companion$StringMonoid;", "Larrow/typeclasses/Monoid;", "", "()V", "empty", "combine", "b", "arrow-core"})
        private static final class StringMonoid
        implements Monoid<String> {
            @NotNull
            public static final StringMonoid INSTANCE;

            @Override
            @NotNull
            public String combine(@NotNull String $this$combine, @NotNull String b) {
                Intrinsics.checkNotNullParameter((Object)$this$combine, (String)"$this$combine");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                return $this$combine + b;
            }

            @Override
            @NotNull
            public String empty() {
                return "";
            }

            private StringMonoid() {
            }

            static {
                StringMonoid stringMonoid;
                INSTANCE = stringMonoid = new StringMonoid();
            }

            @Override
            @NotNull
            public String combineAll(@NotNull Collection<String> $this$combineAll) {
                Intrinsics.checkNotNullParameter($this$combineAll, (String)"$this$combineAll");
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @NotNull
            public String combineAll(@NotNull List<String> elems) {
                Intrinsics.checkNotNullParameter(elems, (String)"elems");
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public String plus(@NotNull String $this$plus, @NotNull String b) {
                Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"$this$plus");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public String maybeCombine(@NotNull String $this$maybeCombine, @Nullable String b) {
                Intrinsics.checkNotNullParameter((Object)$this$maybeCombine, (String)"$this$maybeCombine");
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002H\u0016J,\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00022\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002H\u0016\u00a8\u0006\b"}, d2={"Larrow/typeclasses/Monoid$Companion$ListMonoid;", "Larrow/typeclasses/Monoid;", "", "", "()V", "empty", "combine", "b", "arrow-core"})
        private static final class ListMonoid
        implements Monoid<List<? extends Object>> {
            @NotNull
            public static final ListMonoid INSTANCE;

            @Override
            @NotNull
            public List<Object> empty() {
                return CollectionsKt.emptyList();
            }

            @Override
            @NotNull
            public List<Object> combine(@NotNull List<? extends Object> $this$combine, @NotNull List<? extends Object> b) {
                Intrinsics.checkNotNullParameter($this$combine, (String)"$this$combine");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return CollectionsKt.plus((Collection)$this$combine, (Iterable)b);
            }

            private ListMonoid() {
            }

            static {
                ListMonoid listMonoid;
                INSTANCE = listMonoid = new ListMonoid();
            }

            @Override
            @NotNull
            public List<Object> combineAll(@NotNull Collection<? extends List<? extends Object>> $this$combineAll) {
                Intrinsics.checkNotNullParameter($this$combineAll, (String)"$this$combineAll");
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @NotNull
            public List<Object> combineAll(@NotNull List<? extends List<? extends Object>> elems) {
                Intrinsics.checkNotNullParameter(elems, (String)"elems");
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public List<Object> plus(@NotNull List<? extends Object> $this$plus, @NotNull List<? extends Object> b) {
                Intrinsics.checkNotNullParameter($this$plus, (String)"$this$plus");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public List<Object> maybeCombine(@NotNull List<? extends Object> $this$maybeCombine, @Nullable List<? extends Object> b) {
                Intrinsics.checkNotNullParameter($this$maybeCombine, (String)"$this$maybeCombine");
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002H\u0016J,\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00022\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002H\u0016\u00a8\u0006\b"}, d2={"Larrow/typeclasses/Monoid$Companion$SequenceMonoid;", "Larrow/typeclasses/Monoid;", "Lkotlin/sequences/Sequence;", "", "()V", "empty", "combine", "b", "arrow-core"})
        private static final class SequenceMonoid
        implements Monoid<Sequence<? extends Object>> {
            @NotNull
            public static final SequenceMonoid INSTANCE;

            @Override
            @NotNull
            public Sequence<Object> empty() {
                return SequencesKt.emptySequence();
            }

            @Override
            @NotNull
            public Sequence<Object> combine(@NotNull Sequence<? extends Object> $this$combine, @NotNull Sequence<? extends Object> b) {
                Intrinsics.checkNotNullParameter($this$combine, (String)"$this$combine");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return SequenceKt.flatten(SequencesKt.sequenceOf((Object[])new Sequence[]{$this$combine, b}));
            }

            private SequenceMonoid() {
            }

            static {
                SequenceMonoid sequenceMonoid;
                INSTANCE = sequenceMonoid = new SequenceMonoid();
            }

            @Override
            @NotNull
            public Sequence<Object> combineAll(@NotNull Collection<? extends Sequence<? extends Object>> $this$combineAll) {
                Intrinsics.checkNotNullParameter($this$combineAll, (String)"$this$combineAll");
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @NotNull
            public Sequence<Object> combineAll(@NotNull List<? extends Sequence<? extends Object>> elems) {
                Intrinsics.checkNotNullParameter(elems, (String)"elems");
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Sequence<Object> plus(@NotNull Sequence<? extends Object> $this$plus, @NotNull Sequence<? extends Object> b) {
                Intrinsics.checkNotNullParameter($this$plus, (String)"$this$plus");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public Sequence<Object> maybeCombine(@NotNull Sequence<? extends Object> $this$maybeCombine, @Nullable Sequence<? extends Object> b) {
                Intrinsics.checkNotNullParameter($this$maybeCombine, (String)"$this$maybeCombine");
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u0001*\u0004\b\u0002\u0010\u00022\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00040\u0003B!\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J.\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00042\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00040\nH\u0016J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004H\u0016J8\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004*\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00042\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004H\u0016J*\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00040\u000eH\u0016J:\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004*\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00042\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u0004H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Larrow/typeclasses/Monoid$Companion$EitherMonoid;", "L", "R", "Larrow/typeclasses/Monoid;", "Larrow/core/Either;", "MOL", "MOR", "(Larrow/typeclasses/Monoid;Larrow/typeclasses/Monoid;)V", "combineAll", "elems", "", "empty", "combine", "b", "", "maybeCombine", "arrow-core"})
        private static final class EitherMonoid<L, R>
        implements Monoid<Either<? extends L, ? extends R>> {
            private final Monoid<L> MOL;
            private final Monoid<R> MOR;

            @Override
            @NotNull
            public Either<L, R> empty() {
                return new Either.Right<R>(this.MOR.empty());
            }

            @Override
            @NotNull
            public Either<L, R> combine(@NotNull Either<? extends L, ? extends R> $this$combine, @NotNull Either<? extends L, ? extends R> b) {
                Intrinsics.checkNotNullParameter($this$combine, (String)"$this$combine");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return EitherKt.combine($this$combine, this.MOL, (Semigroup)this.MOR, b);
            }

            @Override
            @NotNull
            public Either<L, R> combineAll(@NotNull Collection<? extends Either<? extends L, ? extends R>> $this$combineAll) {
                Intrinsics.checkNotNullParameter($this$combineAll, (String)"$this$combineAll");
                return EitherKt.combineAll((Iterable)$this$combineAll, this.MOL, this.MOR);
            }

            @Override
            @NotNull
            public Either<L, R> maybeCombine(@NotNull Either<? extends L, ? extends R> $this$maybeCombine, @Nullable Either<? extends L, ? extends R> b) {
                Either<L, R> either2;
                block3: {
                    block2: {
                        Intrinsics.checkNotNullParameter($this$maybeCombine, (String)"$this$maybeCombine");
                        either2 = b;
                        if (either2 == null) break block2;
                        Either<L, R> either3 = either2;
                        boolean bl = false;
                        boolean bl2 = false;
                        Either<L, R> it = either3;
                        boolean bl3 = false;
                        either2 = EitherKt.combine($this$maybeCombine, this.MOL, (Semigroup)this.MOR, it);
                        if (either2 != null) break block3;
                    }
                    either2 = $this$maybeCombine;
                }
                return either2;
            }

            @Override
            @NotNull
            public Either<L, R> combineAll(@NotNull List<? extends Either<? extends L, ? extends R>> elems) {
                Intrinsics.checkNotNullParameter(elems, (String)"elems");
                return EitherKt.combineAll((Iterable)elems, this.MOL, this.MOR);
            }

            public EitherMonoid(@NotNull Monoid<L> MOL, @NotNull Monoid<R> MOR) {
                Intrinsics.checkNotNullParameter(MOL, (String)"MOL");
                Intrinsics.checkNotNullParameter(MOR, (String)"MOR");
                this.MOL = MOL;
                this.MOR = MOR;
            }

            @Override
            @NotNull
            public Either<L, R> plus(@NotNull Either<? extends L, ? extends R> $this$plus, @NotNull Either<? extends L, ? extends R> b) {
                Intrinsics.checkNotNullParameter($this$plus, (String)"$this$plus");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return DefaultImpls.plus(this, $this$plus, b);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u0001*\u0004\b\u0002\u0010\u00022\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00040\u0003B!\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004H\u0016J8\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004*\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0004H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Larrow/typeclasses/Monoid$Companion$PairMonoid;", "A", "B", "Larrow/typeclasses/Monoid;", "Lkotlin/Pair;", "MA", "MB", "(Larrow/typeclasses/Monoid;Larrow/typeclasses/Monoid;)V", "empty", "combine", "b", "arrow-core"})
        private static final class PairMonoid<A, B>
        implements Monoid<Pair<? extends A, ? extends B>> {
            private final Monoid<A> MA;
            private final Monoid<B> MB;

            @Override
            @NotNull
            public Pair<A, B> empty() {
                return new Pair(this.MA.empty(), this.MB.empty());
            }

            @Override
            @NotNull
            public Pair<A, B> combine(@NotNull Pair<? extends A, ? extends B> $this$combine, @NotNull Pair<? extends A, ? extends B> b) {
                Intrinsics.checkNotNullParameter($this$combine, (String)"$this$combine");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return TupleNKt.combine($this$combine, this.MA, (Semigroup)this.MB, b);
            }

            public PairMonoid(@NotNull Monoid<A> MA, @NotNull Monoid<B> MB) {
                Intrinsics.checkNotNullParameter(MA, (String)"MA");
                Intrinsics.checkNotNullParameter(MB, (String)"MB");
                this.MA = MA;
                this.MB = MB;
            }

            @Override
            @NotNull
            public Pair<A, B> combineAll(@NotNull Collection<? extends Pair<? extends A, ? extends B>> $this$combineAll) {
                Intrinsics.checkNotNullParameter($this$combineAll, (String)"$this$combineAll");
                return DefaultImpls.combineAll(this, $this$combineAll);
            }

            @Override
            @NotNull
            public Pair<A, B> combineAll(@NotNull List<? extends Pair<? extends A, ? extends B>> elems) {
                Intrinsics.checkNotNullParameter(elems, (String)"elems");
                return DefaultImpls.combineAll(this, elems);
            }

            @Override
            @NotNull
            public Pair<A, B> plus(@NotNull Pair<? extends A, ? extends B> $this$plus, @NotNull Pair<? extends A, ? extends B> b) {
                Intrinsics.checkNotNullParameter($this$plus, (String)"$this$plus");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return DefaultImpls.plus(this, $this$plus, b);
            }

            @Override
            @NotNull
            public Pair<A, B> maybeCombine(@NotNull Pair<? extends A, ? extends B> $this$maybeCombine, @Nullable Pair<? extends A, ? extends B> b) {
                Intrinsics.checkNotNullParameter($this$maybeCombine, (String)"$this$maybeCombine");
                return DefaultImpls.maybeCombine(this, $this$maybeCombine, b);
            }
        }
    }
}

