package arrow.effects.extensions.eithert.async

import arrow.Kind
import arrow.core.Either
import arrow.data.EitherT
import arrow.data.EitherT.Companion
import arrow.data.ForEitherT
import arrow.effects.extensions.EitherTAsync
import arrow.effects.typeclasses.Async
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.Throwable
import kotlin.Unit
import kotlin.coroutines.CoroutineContext
import kotlin.jvm.JvmName

@JvmName("asyncF")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> asyncF(ASF: Async<F>, arg0: Function1<Function1<Either<Throwable, A>, Unit>, Kind<Kind<Kind<ForEitherT, F>, Throwable>, Unit>>): EitherT<F, Throwable, A> = arrow.data.EitherT
   .async<F>(ASF)
   .asyncF<A>(arg0) as arrow.data.EitherT<F, kotlin.Throwable, A>

@JvmName("continueOn")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> Kind<Kind<Kind<ForEitherT, F>, Throwable>, A>.continueOn(ASF: Async<F>, arg1: CoroutineContext): EitherT<F, Throwable, A> = arrow.data.EitherT.async<F>(ASF).run {
  this@continueOn.continueOn<A>(arg1) as arrow.data.EitherT<F, kotlin.Throwable, A>
}

@JvmName("delay")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> delay(
    ASF: Async<F>,
    arg0: CoroutineContext,
    arg1: Function0<A>
): EitherT<F, Throwable, A> = arrow.data.EitherT
   .async<F>(ASF)
   .delay<A>(arg0, arg1) as arrow.data.EitherT<F, kotlin.Throwable, A>

@JvmName("invoke")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> invoke(
    ASF: Async<F>,
    arg0: CoroutineContext,
    arg1: Function0<A>
): EitherT<F, Throwable, A> = arrow.data.EitherT
   .async<F>(ASF)
   .invoke<A>(arg0, arg1) as arrow.data.EitherT<F, kotlin.Throwable, A>

@JvmName("defer")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> defer(
    ASF: Async<F>,
    arg0: CoroutineContext,
    arg1: Function0<Kind<Kind<Kind<ForEitherT, F>, Throwable>, A>>
): EitherT<F, Throwable, A> = arrow.data.EitherT
   .async<F>(ASF)
   .defer<A>(arg0, arg1) as arrow.data.EitherT<F, kotlin.Throwable, A>

@JvmName("shift")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F> CoroutineContext.shift(ASF: Async<F>): EitherT<F, Throwable, Unit> = arrow.data.EitherT.async<F>(ASF).run {
  this@shift.shift() as arrow.data.EitherT<F, kotlin.Throwable, kotlin.Unit>
}

@JvmName("never")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> never(ASF: Async<F>): EitherT<F, Throwable, A> = arrow.data.EitherT
   .async<F>(ASF)
   .never<A>() as arrow.data.EitherT<F, kotlin.Throwable, A>

fun <F> Companion.async(ASF: Async<F>): EitherTAsync<F> = object : arrow.effects.extensions.EitherTAsync<F> { override fun ASF(): arrow.effects.typeclasses.Async<F> = ASF }