package arrow.effects.extensions.eithert.bracket

import arrow.Kind
import arrow.data.EitherT
import arrow.data.EitherT.Companion
import arrow.data.ForEitherT
import arrow.effects.extensions.EitherTBracket
import arrow.effects.typeclasses.ExitCase
import arrow.effects.typeclasses.MonadDefer
import kotlin.Function1
import kotlin.Function2
import kotlin.Suppress
import kotlin.Throwable
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("bracketCase")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<Kind<ForEitherT, F>, Throwable>, A>.bracketCase(
    MDF: MonadDefer<F>,
    arg1: Function2<A, ExitCase<Throwable>, Kind<Kind<Kind<ForEitherT, F>, Throwable>, Unit>>,
    arg2: Function1<A, Kind<Kind<Kind<ForEitherT, F>, Throwable>, B>>
): EitherT<F, Throwable, B> = arrow.data.EitherT.bracket<F>(MDF).run {
  this@bracketCase.bracketCase<A, B>(arg1, arg2) as arrow.data.EitherT<F, kotlin.Throwable, B>
}

@JvmName("bracket")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<Kind<ForEitherT, F>, Throwable>, A>.bracket(
    MDF: MonadDefer<F>,
    arg1: Function1<A, Kind<Kind<Kind<ForEitherT, F>, Throwable>, Unit>>,
    arg2: Function1<A, Kind<Kind<Kind<ForEitherT, F>, Throwable>, B>>
): EitherT<F, Throwable, B> = arrow.data.EitherT.bracket<F>(MDF).run {
  this@bracket.bracket<A, B>(arg1, arg2) as arrow.data.EitherT<F, kotlin.Throwable, B>
}

@JvmName("uncancelable")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> Kind<Kind<Kind<ForEitherT, F>, Throwable>, A>.uncancelable(MDF: MonadDefer<F>): EitherT<F, Throwable, A> = arrow.data.EitherT.bracket<F>(MDF).run {
  this@uncancelable.uncancelable<A>() as arrow.data.EitherT<F, kotlin.Throwable, A>
}

@JvmName("guarantee")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> Kind<Kind<Kind<ForEitherT, F>, Throwable>, A>.guarantee(MDF: MonadDefer<F>, arg1: Kind<Kind<Kind<ForEitherT, F>, Throwable>, Unit>): EitherT<F, Throwable, A> = arrow.data.EitherT.bracket<F>(MDF).run {
  this@guarantee.guarantee<A>(arg1) as arrow.data.EitherT<F, kotlin.Throwable, A>
}

@JvmName("guaranteeCase")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> Kind<Kind<Kind<ForEitherT, F>, Throwable>, A>.guaranteeCase(MDF: MonadDefer<F>, arg1: Function1<ExitCase<Throwable>, Kind<Kind<Kind<ForEitherT, F>, Throwable>, Unit>>): EitherT<F, Throwable, A> = arrow.data.EitherT.bracket<F>(MDF).run {
  this@guaranteeCase.guaranteeCase<A>(arg1) as arrow.data.EitherT<F, kotlin.Throwable, A>
}

fun <F> Companion.bracket(MDF: MonadDefer<F>): EitherTBracket<F> = object : arrow.effects.extensions.EitherTBracket<F> { override fun MDF(): arrow.effects.typeclasses.MonadDefer<F> = MDF }