package arrow.effects.extensions.eithert.monadDefer

import arrow.Kind
import arrow.core.Either
import arrow.core.Tuple2
import arrow.data.EitherT
import arrow.data.EitherT.Companion
import arrow.data.ForEitherT
import arrow.effects.extensions.EitherTMonadDefer
import arrow.effects.typeclasses.MonadDefer
import arrow.effects.typeclasses.MonadDeferCancellableContinuation
import arrow.typeclasses.MonadContinuation
import arrow.typeclasses.MonadErrorContinuation
import kotlin.Function0
import kotlin.Suppress
import kotlin.Throwable
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("defer")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> defer(MDF: MonadDefer<F>, arg0: Function0<Kind<Kind<Kind<ForEitherT, F>, Throwable>, A>>): EitherT<F, Throwable, A> = arrow.data.EitherT
   .monadDefer<F>(MDF)
   .defer<A>(arg0) as arrow.data.EitherT<F, kotlin.Throwable, A>

@JvmName("delay")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> delay(MDF: MonadDefer<F>, arg0: Function0<A>): EitherT<F, Throwable, A> = arrow.data.EitherT
   .monadDefer<F>(MDF)
   .delay<A>(arg0) as arrow.data.EitherT<F, kotlin.Throwable, A>

@JvmName("delay")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> delay(MDF: MonadDefer<F>, arg0: Kind<Kind<Kind<ForEitherT, F>, Throwable>, A>): EitherT<F, Throwable, A> = arrow.data.EitherT
   .monadDefer<F>(MDF)
   .delay<A>(arg0) as arrow.data.EitherT<F, kotlin.Throwable, A>

@JvmName("invoke")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> invoke(MDF: MonadDefer<F>, arg0: Function0<A>): EitherT<F, Throwable, A> = arrow.data.EitherT
   .monadDefer<F>(MDF)
   .invoke<A>(arg0) as arrow.data.EitherT<F, kotlin.Throwable, A>

@JvmName("lazy")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F> lazy(MDF: MonadDefer<F>): EitherT<F, Throwable, Unit> = arrow.data.EitherT
   .monadDefer<F>(MDF)
   .lazy() as arrow.data.EitherT<F, kotlin.Throwable, kotlin.Unit>

@JvmName("deferUnsafe")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> deferUnsafe(MDF: MonadDefer<F>, arg0: Function0<Either<Throwable, A>>): EitherT<F, Throwable, A> = arrow.data.EitherT
   .monadDefer<F>(MDF)
   .deferUnsafe<A>(arg0) as arrow.data.EitherT<F, kotlin.Throwable, A>

@JvmName("bindingCancellable")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, B> bindingCancellable(MDF: MonadDefer<F>, arg0: suspend MonadDeferCancellableContinuation<Kind<Kind<ForEitherT, F>, Throwable>, *>.() -> B): Tuple2<Kind<Kind<Kind<ForEitherT, F>, Throwable>, B>, Function0<Unit>> = arrow.data.EitherT
   .monadDefer<F>(MDF)
   .bindingCancellable<B>(arg0) as arrow.core.Tuple2<arrow.Kind<arrow.Kind<arrow.Kind<arrow.data.ForEitherT, F>, kotlin.Throwable>, B>, kotlin.Function0<kotlin.Unit>>

@JvmName("binding")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, B> binding(MDF: MonadDefer<F>, arg0: suspend MonadContinuation<Kind<Kind<ForEitherT, F>, Throwable>, *>.() -> B): EitherT<F, Throwable, B> = arrow.data.EitherT
   .monadDefer<F>(MDF)
   .binding<B>(arg0) as arrow.data.EitherT<F, kotlin.Throwable, B>

@JvmName("bindingCatch")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, B> bindingCatch(MDF: MonadDefer<F>, arg0: suspend MonadErrorContinuation<Kind<Kind<ForEitherT, F>, Throwable>, *>.() -> B): EitherT<F, Throwable, B> = arrow.data.EitherT
   .monadDefer<F>(MDF)
   .bindingCatch<B>(arg0) as arrow.data.EitherT<F, kotlin.Throwable, B>

fun <F> Companion.monadDefer(MDF: MonadDefer<F>): EitherTMonadDefer<F> = object : arrow.effects.extensions.EitherTMonadDefer<F> { override fun MDF(): arrow.effects.typeclasses.MonadDefer<F> = MDF }