package arrow.effects.extensions.io.applicativeError

import arrow.Kind
import arrow.core.Either
import arrow.core.ForOption
import arrow.core.ForTry
import arrow.effects.ForIO
import arrow.effects.IO
import arrow.effects.IO.Companion
import arrow.effects.extensions.IOApplicativeError
import arrow.typeclasses.ApplicativeError
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.Throwable
import kotlin.jvm.JvmName

@JvmName("handleErrorWith")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Kind<ForIO, A>.handleErrorWith(arg1: Function1<Throwable, Kind<ForIO, A>>): IO<A> = arrow.effects.IO.applicativeError().run {
  this@handleErrorWith.handleErrorWith<A>(arg1) as arrow.effects.IO<A>
}

@JvmName("raiseError1")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Throwable.raiseError(): IO<A> = arrow.effects.IO.applicativeError().run {
  this@raiseError.raiseError<A>() as arrow.effects.IO<A>
}

@JvmName("fromOption")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Kind<ForOption, A>.fromOption(arg1: Function0<Throwable>): IO<A> = arrow.effects.IO.applicativeError().run {
  this@fromOption.fromOption<A>(arg1) as arrow.effects.IO<A>
}

@JvmName("fromEither")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, EE> Either<EE, A>.fromEither(arg1: Function1<EE, Throwable>): IO<A> = arrow.effects.IO.applicativeError().run {
  this@fromEither.fromEither<A, EE>(arg1) as arrow.effects.IO<A>
}

@JvmName("fromTry")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Kind<ForTry, A>.fromTry(arg1: Function1<Throwable, Throwable>): IO<A> = arrow.effects.IO.applicativeError().run {
  this@fromTry.fromTry<A>(arg1) as arrow.effects.IO<A>
}

@JvmName("handleError")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Kind<ForIO, A>.handleError(arg1: Function1<Throwable, A>): IO<A> = arrow.effects.IO.applicativeError().run {
  this@handleError.handleError<A>(arg1) as arrow.effects.IO<A>
}

@JvmName("attempt")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Kind<ForIO, A>.attempt(): IO<Either<Throwable, A>> = arrow.effects.IO.applicativeError().run {
  this@attempt.attempt<A>() as arrow.effects.IO<arrow.core.Either<kotlin.Throwable, A>>
}

@JvmName("catch")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> catch(arg0: Function1<Throwable, Throwable>, arg1: Function0<A>): IO<A> = arrow.effects.IO
   .applicativeError()
   .catch<A>(arg0, arg1) as arrow.effects.IO<A>

@JvmName("catch")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> ApplicativeError<ForIO, Throwable>.catch(arg1: Function0<A>): IO<A> = arrow.effects.IO.applicativeError().run {
  this@catch.catch<A>(arg1) as arrow.effects.IO<A>
}

fun Companion.applicativeError(): IOApplicativeError = object : arrow.effects.extensions.IOApplicativeError {  }