package arrow.effects.extensions.io.monad

import arrow.Kind
import arrow.core.Either
import arrow.core.Eval
import arrow.core.Tuple2
import arrow.effects.ForIO
import arrow.effects.IO
import arrow.effects.IO.Companion
import arrow.effects.extensions.IOMonad
import arrow.typeclasses.MonadContinuation
import kotlin.Boolean
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("flatMap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<ForIO, A>.flatMap(arg1: Function1<A, Kind<ForIO, B>>): IO<B> = arrow.effects.IO.monad().run {
  this@flatMap.flatMap<A, B>(arg1) as arrow.effects.IO<B>
}

@JvmName("tailRecM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> tailRecM(arg0: A, arg1: Function1<A, Kind<ForIO, Either<A, B>>>): IO<B> = arrow.effects.IO
   .monad()
   .tailRecM<A, B>(arg0, arg1) as arrow.effects.IO<B>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<ForIO, A>.map(arg1: Function1<A, B>): IO<B> = arrow.effects.IO.monad().run {
  this@map.map<A, B>(arg1) as arrow.effects.IO<B>
}

/**
 * @see [Applicative.ap]
 */
@JvmName("ap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<ForIO, A>.ap(arg1: Kind<ForIO, Function1<A, B>>): IO<B> = arrow.effects.IO.monad().run {
  this@ap.ap<A, B>(arg1) as arrow.effects.IO<B>
}

@JvmName("flatten")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> Kind<ForIO, Kind<ForIO, A>>.flatten(): IO<A> = arrow.effects.IO.monad().run {
  this@flatten.flatten<A>() as arrow.effects.IO<A>
}

@JvmName("followedBy")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<ForIO, A>.followedBy(arg1: Kind<ForIO, B>): IO<B> = arrow.effects.IO.monad().run {
  this@followedBy.followedBy<A, B>(arg1) as arrow.effects.IO<B>
}

@JvmName("followedByEval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<ForIO, A>.followedByEval(arg1: Eval<Kind<ForIO, B>>): IO<B> = arrow.effects.IO.monad().run {
  this@followedByEval.followedByEval<A, B>(arg1) as arrow.effects.IO<B>
}

@JvmName("effectM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<ForIO, A>.effectM(arg1: Function1<A, Kind<ForIO, B>>): IO<A> = arrow.effects.IO.monad().run {
  this@effectM.effectM<A, B>(arg1) as arrow.effects.IO<A>
}

@JvmName("forEffect")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<ForIO, A>.forEffect(arg1: Kind<ForIO, B>): IO<A> = arrow.effects.IO.monad().run {
  this@forEffect.forEffect<A, B>(arg1) as arrow.effects.IO<A>
}

@JvmName("forEffectEval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<ForIO, A>.forEffectEval(arg1: Eval<Kind<ForIO, B>>): IO<A> = arrow.effects.IO.monad().run {
  this@forEffectEval.forEffectEval<A, B>(arg1) as arrow.effects.IO<A>
}

@JvmName("mproduct")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<ForIO, A>.mproduct(arg1: Function1<A, Kind<ForIO, B>>): IO<Tuple2<A, B>> = arrow.effects.IO.monad().run {
  this@mproduct.mproduct<A, B>(arg1) as arrow.effects.IO<arrow.core.Tuple2<A, B>>
}

@JvmName("ifM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <B> Kind<ForIO, Boolean>.ifM(arg1: Function0<Kind<ForIO, B>>, arg2: Function0<Kind<ForIO, B>>): IO<B> = arrow.effects.IO.monad().run {
  this@ifM.ifM<B>(arg1, arg2) as arrow.effects.IO<B>
}

@JvmName("selectM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<ForIO, Either<A, B>>.selectM(arg1: Kind<ForIO, Function1<A, B>>): IO<B> = arrow.effects.IO.monad().run {
  this@selectM.selectM<A, B>(arg1) as arrow.effects.IO<B>
}

@JvmName("select")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A, B> Kind<ForIO, Either<A, B>>.select(arg1: Kind<ForIO, Function1<A, B>>): IO<B> = arrow.effects.IO.monad().run {
  this@select.select<A, B>(arg1) as arrow.effects.IO<B>
}

/**
 * Entry point for monad bindings which enables for comprehension. The underlying implementation is based on coroutines.
 * A coroutine is initiated and suspended inside [MonadErrorContinuation] yielding to [Monad.flatMap]. Once all the flatMap binds are completed
 * the underlying monad is returned from the act of executing the coroutine
 */
@JvmName("binding")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <A> binding(arg0: suspend MonadContinuation<ForIO, *>.() -> A): IO<A> = arrow.effects.IO
   .monad()
   .binding<A>(arg0) as arrow.effects.IO<A>

/**
 * ank_macro_hierarchy(arrow.typeclasses.Monad)
 *
 * [Monad] abstract over the ability to declare sequential computations that are dependent in the order or
 * the results of previous computations.
 *
 * Given a type constructor [F] with a value of [A] we can compose multiple operations of type
 * `Kind<F, ?>` where `?` denotes a value being transformed.
 *
 * This is true for all type constructors that can support the [Monad] type class including and not limited to
 * [IO], [DeferredK], [ObservableK], [Option], [Either], [List], [Try] ...
 *
 * [The Monad Tutorial](https://arrow-kt.io/docs/patterns/monads/)
 *
 */
fun Companion.monad(): IOMonad = object : arrow.effects.extensions.IOMonad {  }