package arrow.effects.extensions.kleisli.bracket

import arrow.Kind
import arrow.data.ForKleisli
import arrow.data.Kleisli
import arrow.data.Kleisli.Companion
import arrow.effects.extensions.KleisliBracket
import arrow.effects.typeclasses.Bracket
import arrow.effects.typeclasses.ExitCase
import kotlin.Function1
import kotlin.Function2
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("bracketCase")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, R, E, A, B> Kind<Kind<Kind<ForKleisli, F>, R>, A>.bracketCase(
    BF: Bracket<F, E>,
    arg1: Function2<A, ExitCase<E>, Kind<Kind<Kind<ForKleisli, F>, R>, Unit>>,
    arg2: Function1<A, Kind<Kind<Kind<ForKleisli, F>, R>, B>>
): Kleisli<F, R, B> = arrow.data.Kleisli.bracket<F, R, E>(BF).run {
  this@bracketCase.bracketCase<A, B>(arg1, arg2) as arrow.data.Kleisli<F, R, B>
}

@JvmName("bracket")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, R, E, A, B> Kind<Kind<Kind<ForKleisli, F>, R>, A>.bracket(
    BF: Bracket<F, E>,
    arg1: Function1<A, Kind<Kind<Kind<ForKleisli, F>, R>, Unit>>,
    arg2: Function1<A, Kind<Kind<Kind<ForKleisli, F>, R>, B>>
): Kleisli<F, R, B> = arrow.data.Kleisli.bracket<F, R, E>(BF).run {
  this@bracket.bracket<A, B>(arg1, arg2) as arrow.data.Kleisli<F, R, B>
}

@JvmName("uncancelable")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, R, E, A> Kind<Kind<Kind<ForKleisli, F>, R>, A>.uncancelable(BF: Bracket<F, E>): Kleisli<F, R, A> = arrow.data.Kleisli.bracket<F, R, E>(BF).run {
  this@uncancelable.uncancelable<A>() as arrow.data.Kleisli<F, R, A>
}

@JvmName("guarantee")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, R, E, A> Kind<Kind<Kind<ForKleisli, F>, R>, A>.guarantee(BF: Bracket<F, E>, arg1: Kind<Kind<Kind<ForKleisli, F>, R>, Unit>): Kleisli<F, R, A> = arrow.data.Kleisli.bracket<F, R, E>(BF).run {
  this@guarantee.guarantee<A>(arg1) as arrow.data.Kleisli<F, R, A>
}

@JvmName("guaranteeCase")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, R, E, A> Kind<Kind<Kind<ForKleisli, F>, R>, A>.guaranteeCase(BF: Bracket<F, E>, arg1: Function1<ExitCase<E>, Kind<Kind<Kind<ForKleisli, F>, R>, Unit>>): Kleisli<F, R, A> = arrow.data.Kleisli.bracket<F, R, E>(BF).run {
  this@guaranteeCase.guaranteeCase<A>(arg1) as arrow.data.Kleisli<F, R, A>
}

fun <F, R, E> Companion.bracket(BF: Bracket<F, E>): KleisliBracket<F, R, E> = object : arrow.effects.extensions.KleisliBracket<F, R, E> { override fun BF(): arrow.effects.typeclasses.Bracket<F, E> = BF }