package arrow.effects.extensions.optiont.bracket

import arrow.Kind
import arrow.data.ForOptionT
import arrow.data.OptionT
import arrow.data.OptionT.Companion
import arrow.effects.extensions.OptionTBracket
import arrow.effects.typeclasses.ExitCase
import arrow.effects.typeclasses.MonadDefer
import kotlin.Function1
import kotlin.Function2
import kotlin.Suppress
import kotlin.Throwable
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("bracketCase")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForOptionT, F>, A>.bracketCase(
    MD: MonadDefer<F>,
    arg1: Function2<A, ExitCase<Throwable>, Kind<Kind<ForOptionT, F>, Unit>>,
    arg2: Function1<A, Kind<Kind<ForOptionT, F>, B>>
): OptionT<F, B> = arrow.data.OptionT.bracket<F>(MD).run {
  this@bracketCase.bracketCase<A, B>(arg1, arg2) as arrow.data.OptionT<F, B>
}

@JvmName("bracket")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A, B> Kind<Kind<ForOptionT, F>, A>.bracket(
    MD: MonadDefer<F>,
    arg1: Function1<A, Kind<Kind<ForOptionT, F>, Unit>>,
    arg2: Function1<A, Kind<Kind<ForOptionT, F>, B>>
): OptionT<F, B> = arrow.data.OptionT.bracket<F>(MD).run {
  this@bracket.bracket<A, B>(arg1, arg2) as arrow.data.OptionT<F, B>
}

@JvmName("uncancelable")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> Kind<Kind<ForOptionT, F>, A>.uncancelable(MD: MonadDefer<F>): OptionT<F, A> = arrow.data.OptionT.bracket<F>(MD).run {
  this@uncancelable.uncancelable<A>() as arrow.data.OptionT<F, A>
}

@JvmName("guarantee")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> Kind<Kind<ForOptionT, F>, A>.guarantee(MD: MonadDefer<F>, arg1: Kind<Kind<ForOptionT, F>, Unit>): OptionT<F, A> = arrow.data.OptionT.bracket<F>(MD).run {
  this@guarantee.guarantee<A>(arg1) as arrow.data.OptionT<F, A>
}

@JvmName("guaranteeCase")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> Kind<Kind<ForOptionT, F>, A>.guaranteeCase(MD: MonadDefer<F>, arg1: Function1<ExitCase<Throwable>, Kind<Kind<ForOptionT, F>, Unit>>): OptionT<F, A> = arrow.data.OptionT.bracket<F>(MD).run {
  this@guaranteeCase.guaranteeCase<A>(arg1) as arrow.data.OptionT<F, A>
}

fun <F> Companion.bracket(MD: MonadDefer<F>): OptionTBracket<F> = object : arrow.effects.extensions.OptionTBracket<F> { override fun MD(): arrow.effects.typeclasses.MonadDefer<F> = MD }