package arrow.effects.extensions.optiont.monadDefer

import arrow.Kind
import arrow.core.Either
import arrow.core.Tuple2
import arrow.data.ForOptionT
import arrow.data.OptionT
import arrow.data.OptionT.Companion
import arrow.effects.extensions.OptionTMonadDefer
import arrow.effects.typeclasses.MonadDefer
import arrow.effects.typeclasses.MonadDeferCancellableContinuation
import arrow.typeclasses.MonadContinuation
import arrow.typeclasses.MonadErrorContinuation
import kotlin.Function0
import kotlin.Suppress
import kotlin.Throwable
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("defer")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> defer(MD: MonadDefer<F>, arg0: Function0<Kind<Kind<ForOptionT, F>, A>>): OptionT<F, A> = arrow.data.OptionT
   .monadDefer<F>(MD)
   .defer<A>(arg0) as arrow.data.OptionT<F, A>

@JvmName("delay")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> delay(MD: MonadDefer<F>, arg0: Function0<A>): OptionT<F, A> = arrow.data.OptionT
   .monadDefer<F>(MD)
   .delay<A>(arg0) as arrow.data.OptionT<F, A>

@JvmName("delay")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> delay(MD: MonadDefer<F>, arg0: Kind<Kind<ForOptionT, F>, A>): OptionT<F, A> = arrow.data.OptionT
   .monadDefer<F>(MD)
   .delay<A>(arg0) as arrow.data.OptionT<F, A>

@JvmName("invoke")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> invoke(MD: MonadDefer<F>, arg0: Function0<A>): OptionT<F, A> = arrow.data.OptionT
   .monadDefer<F>(MD)
   .invoke<A>(arg0) as arrow.data.OptionT<F, A>

@JvmName("lazy")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F> lazy(MD: MonadDefer<F>): OptionT<F, Unit> = arrow.data.OptionT
   .monadDefer<F>(MD)
   .lazy() as arrow.data.OptionT<F, kotlin.Unit>

@JvmName("deferUnsafe")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, A> deferUnsafe(MD: MonadDefer<F>, arg0: Function0<Either<Throwable, A>>): OptionT<F, A> = arrow.data.OptionT
   .monadDefer<F>(MD)
   .deferUnsafe<A>(arg0) as arrow.data.OptionT<F, A>

@JvmName("bindingCancellable")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, B> bindingCancellable(MD: MonadDefer<F>, arg0: suspend MonadDeferCancellableContinuation<Kind<ForOptionT, F>, *>.() -> B): Tuple2<Kind<Kind<ForOptionT, F>, B>, Function0<Unit>> = arrow.data.OptionT
   .monadDefer<F>(MD)
   .bindingCancellable<B>(arg0) as arrow.core.Tuple2<arrow.Kind<arrow.Kind<arrow.data.ForOptionT, F>, B>, kotlin.Function0<kotlin.Unit>>

@JvmName("binding")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, B> binding(MD: MonadDefer<F>, arg0: suspend MonadContinuation<Kind<ForOptionT, F>, *>.() -> B): OptionT<F, B> = arrow.data.OptionT
   .monadDefer<F>(MD)
   .binding<B>(arg0) as arrow.data.OptionT<F, B>

@JvmName("bindingCatch")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, B> bindingCatch(MD: MonadDefer<F>, arg0: suspend MonadErrorContinuation<Kind<ForOptionT, F>, *>.() -> B): OptionT<F, B> = arrow.data.OptionT
   .monadDefer<F>(MD)
   .bindingCatch<B>(arg0) as arrow.data.OptionT<F, B>

fun <F> Companion.monadDefer(MD: MonadDefer<F>): OptionTMonadDefer<F> = object : arrow.effects.extensions.OptionTMonadDefer<F> { override fun MD(): arrow.effects.typeclasses.MonadDefer<F> = MD }