package arrow.effects.extensions.statet.async

import arrow.Kind
import arrow.core.Either
import arrow.data.ForStateT
import arrow.data.StateT
import arrow.data.StateT.Companion
import arrow.effects.extensions.StateTAsyncInstane
import arrow.effects.typeclasses.Async
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.Throwable
import kotlin.Unit
import kotlin.coroutines.CoroutineContext
import kotlin.jvm.JvmName

@JvmName("asyncF")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A> asyncF(AS: Async<F>, arg0: Function1<Function1<Either<Throwable, A>, Unit>, Kind<Kind<Kind<ForStateT, F>, S>, Unit>>): StateT<F, S, A> = arrow.data.StateT
   .async<F, S>(AS)
   .asyncF<A>(arg0) as arrow.data.StateT<F, S, A>

@JvmName("continueOn")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A> Kind<Kind<Kind<ForStateT, F>, S>, A>.continueOn(AS: Async<F>, arg1: CoroutineContext): StateT<F, S, A> = arrow.data.StateT.async<F, S>(AS).run {
  this@continueOn.continueOn<A>(arg1) as arrow.data.StateT<F, S, A>
}

@JvmName("delay")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A> delay(
    AS: Async<F>,
    arg0: CoroutineContext,
    arg1: Function0<A>
): StateT<F, S, A> = arrow.data.StateT
   .async<F, S>(AS)
   .delay<A>(arg0, arg1) as arrow.data.StateT<F, S, A>

@JvmName("invoke")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A> invoke(
    AS: Async<F>,
    arg0: CoroutineContext,
    arg1: Function0<A>
): StateT<F, S, A> = arrow.data.StateT
   .async<F, S>(AS)
   .invoke<A>(arg0, arg1) as arrow.data.StateT<F, S, A>

@JvmName("defer")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A> defer(
    AS: Async<F>,
    arg0: CoroutineContext,
    arg1: Function0<Kind<Kind<Kind<ForStateT, F>, S>, A>>
): StateT<F, S, A> = arrow.data.StateT
   .async<F, S>(AS)
   .defer<A>(arg0, arg1) as arrow.data.StateT<F, S, A>

@JvmName("shift")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S> CoroutineContext.shift(AS: Async<F>): StateT<F, S, Unit> = arrow.data.StateT.async<F, S>(AS).run {
  this@shift.shift() as arrow.data.StateT<F, S, kotlin.Unit>
}

@JvmName("never")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A> never(AS: Async<F>): StateT<F, S, A> = arrow.data.StateT
   .async<F, S>(AS)
   .never<A>() as arrow.data.StateT<F, S, A>

fun <F, S> Companion.async(AS: Async<F>): StateTAsyncInstane<F, S> = object : arrow.effects.extensions.StateTAsyncInstane<F, S> { override fun AS(): arrow.effects.typeclasses.Async<F> = AS }