package arrow.effects.extensions.statet.bracket

import arrow.Kind
import arrow.data.ForStateT
import arrow.data.StateT
import arrow.data.StateT.Companion
import arrow.effects.extensions.StateTBracket
import arrow.effects.typeclasses.ExitCase
import arrow.effects.typeclasses.MonadDefer
import kotlin.Function1
import kotlin.Function2
import kotlin.Suppress
import kotlin.Throwable
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("bracketCase")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A, B> Kind<Kind<Kind<ForStateT, F>, S>, A>.bracketCase(
    MD: MonadDefer<F>,
    arg1: Function2<A, ExitCase<Throwable>, Kind<Kind<Kind<ForStateT, F>, S>, Unit>>,
    arg2: Function1<A, Kind<Kind<Kind<ForStateT, F>, S>, B>>
): StateT<F, S, B> = arrow.data.StateT.bracket<F, S>(MD).run {
  this@bracketCase.bracketCase<A, B>(arg1, arg2) as arrow.data.StateT<F, S, B>
}

@JvmName("bracket")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A, B> Kind<Kind<Kind<ForStateT, F>, S>, A>.bracket(
    MD: MonadDefer<F>,
    arg1: Function1<A, Kind<Kind<Kind<ForStateT, F>, S>, Unit>>,
    arg2: Function1<A, Kind<Kind<Kind<ForStateT, F>, S>, B>>
): StateT<F, S, B> = arrow.data.StateT.bracket<F, S>(MD).run {
  this@bracket.bracket<A, B>(arg1, arg2) as arrow.data.StateT<F, S, B>
}

@JvmName("uncancelable")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A> Kind<Kind<Kind<ForStateT, F>, S>, A>.uncancelable(MD: MonadDefer<F>): StateT<F, S, A> = arrow.data.StateT.bracket<F, S>(MD).run {
  this@uncancelable.uncancelable<A>() as arrow.data.StateT<F, S, A>
}

@JvmName("guarantee")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A> Kind<Kind<Kind<ForStateT, F>, S>, A>.guarantee(MD: MonadDefer<F>, arg1: Kind<Kind<Kind<ForStateT, F>, S>, Unit>): StateT<F, S, A> = arrow.data.StateT.bracket<F, S>(MD).run {
  this@guarantee.guarantee<A>(arg1) as arrow.data.StateT<F, S, A>
}

@JvmName("guaranteeCase")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A> Kind<Kind<Kind<ForStateT, F>, S>, A>.guaranteeCase(MD: MonadDefer<F>, arg1: Function1<ExitCase<Throwable>, Kind<Kind<Kind<ForStateT, F>, S>, Unit>>): StateT<F, S, A> = arrow.data.StateT.bracket<F, S>(MD).run {
  this@guaranteeCase.guaranteeCase<A>(arg1) as arrow.data.StateT<F, S, A>
}

fun <F, S> Companion.bracket(MD: MonadDefer<F>): StateTBracket<F, S> = object : arrow.effects.extensions.StateTBracket<F, S> { override fun MD(): arrow.effects.typeclasses.MonadDefer<F> = MD }