package arrow.effects.extensions.statet.monadDefer

import arrow.Kind
import arrow.core.Either
import arrow.core.Tuple2
import arrow.data.ForStateT
import arrow.data.StateT
import arrow.data.StateT.Companion
import arrow.effects.extensions.StateTMonadDefer
import arrow.effects.typeclasses.MonadDefer
import arrow.effects.typeclasses.MonadDeferCancellableContinuation
import arrow.typeclasses.MonadContinuation
import arrow.typeclasses.MonadErrorContinuation
import kotlin.Function0
import kotlin.Suppress
import kotlin.Throwable
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("defer")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A> defer(MD: MonadDefer<F>, arg0: Function0<Kind<Kind<Kind<ForStateT, F>, S>, A>>): StateT<F, S, A> = arrow.data.StateT
   .monadDefer<F, S>(MD)
   .defer<A>(arg0) as arrow.data.StateT<F, S, A>

@JvmName("delay")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A> delay(MD: MonadDefer<F>, arg0: Function0<A>): StateT<F, S, A> = arrow.data.StateT
   .monadDefer<F, S>(MD)
   .delay<A>(arg0) as arrow.data.StateT<F, S, A>

@JvmName("delay")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A> delay(MD: MonadDefer<F>, arg0: Kind<Kind<Kind<ForStateT, F>, S>, A>): StateT<F, S, A> = arrow.data.StateT
   .monadDefer<F, S>(MD)
   .delay<A>(arg0) as arrow.data.StateT<F, S, A>

@JvmName("invoke")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A> invoke(MD: MonadDefer<F>, arg0: Function0<A>): StateT<F, S, A> = arrow.data.StateT
   .monadDefer<F, S>(MD)
   .invoke<A>(arg0) as arrow.data.StateT<F, S, A>

@JvmName("lazy")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S> lazy(MD: MonadDefer<F>): StateT<F, S, Unit> = arrow.data.StateT
   .monadDefer<F, S>(MD)
   .lazy() as arrow.data.StateT<F, S, kotlin.Unit>

@JvmName("deferUnsafe")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, A> deferUnsafe(MD: MonadDefer<F>, arg0: Function0<Either<Throwable, A>>): StateT<F, S, A> = arrow.data.StateT
   .monadDefer<F, S>(MD)
   .deferUnsafe<A>(arg0) as arrow.data.StateT<F, S, A>

@JvmName("bindingCancellable")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, B> bindingCancellable(MD: MonadDefer<F>, arg0: suspend MonadDeferCancellableContinuation<Kind<Kind<ForStateT, F>, S>, *>.() -> B): Tuple2<Kind<Kind<Kind<ForStateT, F>, S>, B>, Function0<Unit>> = arrow.data.StateT
   .monadDefer<F, S>(MD)
   .bindingCancellable<B>(arg0) as arrow.core.Tuple2<arrow.Kind<arrow.Kind<arrow.Kind<arrow.data.ForStateT, F>, S>, B>, kotlin.Function0<kotlin.Unit>>

@JvmName("binding")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, B> binding(MD: MonadDefer<F>, arg0: suspend MonadContinuation<Kind<Kind<ForStateT, F>, S>, *>.() -> B): StateT<F, S, B> = arrow.data.StateT
   .monadDefer<F, S>(MD)
   .binding<B>(arg0) as arrow.data.StateT<F, S, B>

@JvmName("bindingCatch")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, S, B> bindingCatch(MD: MonadDefer<F>, arg0: suspend MonadErrorContinuation<Kind<Kind<ForStateT, F>, S>, *>.() -> B): StateT<F, S, B> = arrow.data.StateT
   .monadDefer<F, S>(MD)
   .bindingCatch<B>(arg0) as arrow.data.StateT<F, S, B>

fun <F, S> Companion.monadDefer(MD: MonadDefer<F>): StateTMonadDefer<F, S> = object : arrow.effects.extensions.StateTMonadDefer<F, S> { override fun MD(): arrow.effects.typeclasses.MonadDefer<F> = MD }