package arrow.effects.extensions.writert.async

import arrow.Kind
import arrow.core.Either
import arrow.data.ForWriterT
import arrow.data.WriterT
import arrow.data.WriterT.Companion
import arrow.effects.extensions.WriterTAsync
import arrow.effects.typeclasses.Async
import arrow.typeclasses.Monoid
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.Throwable
import kotlin.Unit
import kotlin.coroutines.CoroutineContext
import kotlin.jvm.JvmName

@JvmName("asyncF")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A> asyncF(
    AS: Async<F>,
    MM: Monoid<W>,
    arg0: Function1<Function1<Either<Throwable, A>, Unit>, Kind<Kind<Kind<ForWriterT, F>, W>, Unit>>
): WriterT<F, W, A> = arrow.data.WriterT
   .async<F, W>(AS, MM)
   .asyncF<A>(arg0) as arrow.data.WriterT<F, W, A>

@JvmName("continueOn")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A> Kind<Kind<Kind<ForWriterT, F>, W>, A>.continueOn(
    AS: Async<F>,
    MM: Monoid<W>,
    arg1: CoroutineContext
): WriterT<F, W, A> = arrow.data.WriterT.async<F, W>(AS, MM).run {
  this@continueOn.continueOn<A>(arg1) as arrow.data.WriterT<F, W, A>
}

@JvmName("delay")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A> delay(
    AS: Async<F>,
    MM: Monoid<W>,
    arg0: CoroutineContext,
    arg1: Function0<A>
): WriterT<F, W, A> = arrow.data.WriterT
   .async<F, W>(AS, MM)
   .delay<A>(arg0, arg1) as arrow.data.WriterT<F, W, A>

@JvmName("invoke")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A> invoke(
    AS: Async<F>,
    MM: Monoid<W>,
    arg0: CoroutineContext,
    arg1: Function0<A>
): WriterT<F, W, A> = arrow.data.WriterT
   .async<F, W>(AS, MM)
   .invoke<A>(arg0, arg1) as arrow.data.WriterT<F, W, A>

@JvmName("defer")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A> defer(
    AS: Async<F>,
    MM: Monoid<W>,
    arg0: CoroutineContext,
    arg1: Function0<Kind<Kind<Kind<ForWriterT, F>, W>, A>>
): WriterT<F, W, A> = arrow.data.WriterT
   .async<F, W>(AS, MM)
   .defer<A>(arg0, arg1) as arrow.data.WriterT<F, W, A>

@JvmName("shift")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W> CoroutineContext.shift(AS: Async<F>, MM: Monoid<W>): WriterT<F, W, Unit> = arrow.data.WriterT.async<F, W>(AS, MM).run {
  this@shift.shift() as arrow.data.WriterT<F, W, kotlin.Unit>
}

@JvmName("never")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A> never(AS: Async<F>, MM: Monoid<W>): WriterT<F, W, A> = arrow.data.WriterT
   .async<F, W>(AS, MM)
   .never<A>() as arrow.data.WriterT<F, W, A>

fun <F, W> Companion.async(AS: Async<F>, MM: Monoid<W>): WriterTAsync<F, W> = object : arrow.effects.extensions.WriterTAsync<F, W> { override fun AS(): arrow.effects.typeclasses.Async<F> = AS

  override fun MM(): arrow.typeclasses.Monoid<W> = MM }