package arrow.effects.extensions.writert.bracket

import arrow.Kind
import arrow.data.ForWriterT
import arrow.data.WriterT
import arrow.data.WriterT.Companion
import arrow.effects.extensions.WriterTBracket
import arrow.effects.typeclasses.ExitCase
import arrow.effects.typeclasses.MonadDefer
import arrow.typeclasses.Monoid
import kotlin.Function1
import kotlin.Function2
import kotlin.Suppress
import kotlin.Throwable
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("bracketCase")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, A>.bracketCase(
    MD: MonadDefer<F>,
    MM: Monoid<W>,
    arg1: Function2<A, ExitCase<Throwable>, Kind<Kind<Kind<ForWriterT, F>, W>, Unit>>,
    arg2: Function1<A, Kind<Kind<Kind<ForWriterT, F>, W>, B>>
): WriterT<F, W, B> = arrow.data.WriterT.bracket<F, W>(MD, MM).run {
  this@bracketCase.bracketCase<A, B>(arg1, arg2) as arrow.data.WriterT<F, W, B>
}

@JvmName("bracket")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A, B> Kind<Kind<Kind<ForWriterT, F>, W>, A>.bracket(
    MD: MonadDefer<F>,
    MM: Monoid<W>,
    arg1: Function1<A, Kind<Kind<Kind<ForWriterT, F>, W>, Unit>>,
    arg2: Function1<A, Kind<Kind<Kind<ForWriterT, F>, W>, B>>
): WriterT<F, W, B> = arrow.data.WriterT.bracket<F, W>(MD, MM).run {
  this@bracket.bracket<A, B>(arg1, arg2) as arrow.data.WriterT<F, W, B>
}

@JvmName("uncancelable")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A> Kind<Kind<Kind<ForWriterT, F>, W>, A>.uncancelable(MD: MonadDefer<F>, MM: Monoid<W>): WriterT<F, W, A> = arrow.data.WriterT.bracket<F, W>(MD, MM).run {
  this@uncancelable.uncancelable<A>() as arrow.data.WriterT<F, W, A>
}

@JvmName("guarantee")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A> Kind<Kind<Kind<ForWriterT, F>, W>, A>.guarantee(
    MD: MonadDefer<F>,
    MM: Monoid<W>,
    arg1: Kind<Kind<Kind<ForWriterT, F>, W>, Unit>
): WriterT<F, W, A> = arrow.data.WriterT.bracket<F, W>(MD, MM).run {
  this@guarantee.guarantee<A>(arg1) as arrow.data.WriterT<F, W, A>
}

@JvmName("guaranteeCase")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A> Kind<Kind<Kind<ForWriterT, F>, W>, A>.guaranteeCase(
    MD: MonadDefer<F>,
    MM: Monoid<W>,
    arg1: Function1<ExitCase<Throwable>, Kind<Kind<Kind<ForWriterT, F>, W>, Unit>>
): WriterT<F, W, A> = arrow.data.WriterT.bracket<F, W>(MD, MM).run {
  this@guaranteeCase.guaranteeCase<A>(arg1) as arrow.data.WriterT<F, W, A>
}

fun <F, W> Companion.bracket(MD: MonadDefer<F>, MM: Monoid<W>): WriterTBracket<F, W> = object : arrow.effects.extensions.WriterTBracket<F, W> { override fun MD(): arrow.effects.typeclasses.MonadDefer<F> = MD

  override fun MM(): arrow.typeclasses.Monoid<W> = MM }