package arrow.effects.extensions.writert.monadDefer

import arrow.Kind
import arrow.core.Either
import arrow.core.Tuple2
import arrow.data.ForWriterT
import arrow.data.WriterT
import arrow.data.WriterT.Companion
import arrow.effects.extensions.WriterTMonadDefer
import arrow.effects.typeclasses.MonadDefer
import arrow.effects.typeclasses.MonadDeferCancellableContinuation
import arrow.typeclasses.MonadContinuation
import arrow.typeclasses.MonadErrorContinuation
import arrow.typeclasses.Monoid
import kotlin.Function0
import kotlin.Suppress
import kotlin.Throwable
import kotlin.Unit
import kotlin.jvm.JvmName

@JvmName("defer")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A> defer(
    MD: MonadDefer<F>,
    MM: Monoid<W>,
    arg0: Function0<Kind<Kind<Kind<ForWriterT, F>, W>, A>>
): WriterT<F, W, A> = arrow.data.WriterT
   .monadDefer<F, W>(MD, MM)
   .defer<A>(arg0) as arrow.data.WriterT<F, W, A>

@JvmName("delay")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A> delay(
    MD: MonadDefer<F>,
    MM: Monoid<W>,
    arg0: Function0<A>
): WriterT<F, W, A> = arrow.data.WriterT
   .monadDefer<F, W>(MD, MM)
   .delay<A>(arg0) as arrow.data.WriterT<F, W, A>

@JvmName("delay")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A> delay(
    MD: MonadDefer<F>,
    MM: Monoid<W>,
    arg0: Kind<Kind<Kind<ForWriterT, F>, W>, A>
): WriterT<F, W, A> = arrow.data.WriterT
   .monadDefer<F, W>(MD, MM)
   .delay<A>(arg0) as arrow.data.WriterT<F, W, A>

@JvmName("invoke")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A> invoke(
    MD: MonadDefer<F>,
    MM: Monoid<W>,
    arg0: Function0<A>
): WriterT<F, W, A> = arrow.data.WriterT
   .monadDefer<F, W>(MD, MM)
   .invoke<A>(arg0) as arrow.data.WriterT<F, W, A>

@JvmName("lazy")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W> lazy(MD: MonadDefer<F>, MM: Monoid<W>): WriterT<F, W, Unit> = arrow.data.WriterT
   .monadDefer<F, W>(MD, MM)
   .lazy() as arrow.data.WriterT<F, W, kotlin.Unit>

@JvmName("deferUnsafe")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, A> deferUnsafe(
    MD: MonadDefer<F>,
    MM: Monoid<W>,
    arg0: Function0<Either<Throwable, A>>
): WriterT<F, W, A> = arrow.data.WriterT
   .monadDefer<F, W>(MD, MM)
   .deferUnsafe<A>(arg0) as arrow.data.WriterT<F, W, A>

@JvmName("bindingCancellable")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, B> bindingCancellable(
    MD: MonadDefer<F>,
    MM: Monoid<W>,
    arg0: suspend MonadDeferCancellableContinuation<Kind<Kind<ForWriterT, F>, W>, *>.() -> B
): Tuple2<Kind<Kind<Kind<ForWriterT, F>, W>, B>, Function0<Unit>> = arrow.data.WriterT
   .monadDefer<F, W>(MD, MM)
   .bindingCancellable<B>(arg0) as arrow.core.Tuple2<arrow.Kind<arrow.Kind<arrow.Kind<arrow.data.ForWriterT, F>, W>, B>, kotlin.Function0<kotlin.Unit>>

@JvmName("binding")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, B> binding(
    MD: MonadDefer<F>,
    MM: Monoid<W>,
    arg0: suspend MonadContinuation<Kind<Kind<ForWriterT, F>, W>, *>.() -> B
): WriterT<F, W, B> = arrow.data.WriterT
   .monadDefer<F, W>(MD, MM)
   .binding<B>(arg0) as arrow.data.WriterT<F, W, B>

@JvmName("bindingCatch")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, W, B> bindingCatch(
    MD: MonadDefer<F>,
    MM: Monoid<W>,
    arg0: suspend MonadErrorContinuation<Kind<Kind<ForWriterT, F>, W>, *>.() -> B
): WriterT<F, W, B> = arrow.data.WriterT
   .monadDefer<F, W>(MD, MM)
   .bindingCatch<B>(arg0) as arrow.data.WriterT<F, W, B>

fun <F, W> Companion.monadDefer(MD: MonadDefer<F>, MM: Monoid<W>): WriterTMonadDefer<F, W> = object : arrow.effects.extensions.WriterTMonadDefer<F, W> { override fun MD(): arrow.effects.typeclasses.MonadDefer<F> = MD

  override fun MM(): arrow.typeclasses.Monoid<W> = MM }