package arrow.data.extensions.andthen.monad

import arrow.Kind
import arrow.core.Either
import arrow.core.Eval
import arrow.core.Tuple2
import arrow.data.AndThen
import arrow.data.AndThen.Companion
import arrow.data.ForAndThen
import arrow.data.extensions.AndThenMonad
import arrow.typeclasses.MonadContinuation
import kotlin.Boolean
import kotlin.Function0
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("flatMap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <X, A, B> Kind<Kind<ForAndThen, X>, A>.flatMap(arg1: Function1<A, Kind<Kind<ForAndThen, X>, B>>): AndThen<X, B> = arrow.data.AndThen.monad<X>().run {
  this@flatMap.flatMap<A, B>(arg1) as arrow.data.AndThen<X, B>
}

@JvmName("tailRecM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <X, A, B> tailRecM(arg0: A, arg1: Function1<A, Kind<Kind<ForAndThen, X>, Either<A, B>>>): AndThen<X, B> = arrow.data.AndThen
   .monad<X>()
   .tailRecM<A, B>(arg0, arg1) as arrow.data.AndThen<X, B>

@JvmName("map")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <X, A, B> Kind<Kind<ForAndThen, X>, A>.map(arg1: Function1<A, B>): AndThen<X, B> = arrow.data.AndThen.monad<X>().run {
  this@map.map<A, B>(arg1) as arrow.data.AndThen<X, B>
}

/**
 * @see [Applicative.ap]
 */
@JvmName("ap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <X, A, B> Kind<Kind<ForAndThen, X>, A>.ap(arg1: Kind<Kind<ForAndThen, X>, Function1<A, B>>): AndThen<X, B> = arrow.data.AndThen.monad<X>().run {
  this@ap.ap<A, B>(arg1) as arrow.data.AndThen<X, B>
}

@JvmName("flatten")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <X, A> Kind<Kind<ForAndThen, X>, Kind<Kind<ForAndThen, X>, A>>.flatten(): AndThen<X, A> = arrow.data.AndThen.monad<X>().run {
  this@flatten.flatten<A>() as arrow.data.AndThen<X, A>
}

@JvmName("followedBy")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <X, A, B> Kind<Kind<ForAndThen, X>, A>.followedBy(arg1: Kind<Kind<ForAndThen, X>, B>): AndThen<X, B> = arrow.data.AndThen.monad<X>().run {
  this@followedBy.followedBy<A, B>(arg1) as arrow.data.AndThen<X, B>
}

@JvmName("followedByEval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <X, A, B> Kind<Kind<ForAndThen, X>, A>.followedByEval(arg1: Eval<Kind<Kind<ForAndThen, X>, B>>): AndThen<X, B> = arrow.data.AndThen.monad<X>().run {
  this@followedByEval.followedByEval<A, B>(arg1) as arrow.data.AndThen<X, B>
}

@JvmName("effectM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <X, A, B> Kind<Kind<ForAndThen, X>, A>.effectM(arg1: Function1<A, Kind<Kind<ForAndThen, X>, B>>): AndThen<X, A> = arrow.data.AndThen.monad<X>().run {
  this@effectM.effectM<A, B>(arg1) as arrow.data.AndThen<X, A>
}

@JvmName("forEffect")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <X, A, B> Kind<Kind<ForAndThen, X>, A>.forEffect(arg1: Kind<Kind<ForAndThen, X>, B>): AndThen<X, A> = arrow.data.AndThen.monad<X>().run {
  this@forEffect.forEffect<A, B>(arg1) as arrow.data.AndThen<X, A>
}

@JvmName("forEffectEval")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <X, A, B> Kind<Kind<ForAndThen, X>, A>.forEffectEval(arg1: Eval<Kind<Kind<ForAndThen, X>, B>>): AndThen<X, A> = arrow.data.AndThen.monad<X>().run {
  this@forEffectEval.forEffectEval<A, B>(arg1) as arrow.data.AndThen<X, A>
}

@JvmName("mproduct")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <X, A, B> Kind<Kind<ForAndThen, X>, A>.mproduct(arg1: Function1<A, Kind<Kind<ForAndThen, X>, B>>): AndThen<X, Tuple2<A, B>> = arrow.data.AndThen.monad<X>().run {
  this@mproduct.mproduct<A, B>(arg1) as arrow.data.AndThen<X, arrow.core.Tuple2<A, B>>
}

@JvmName("ifM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <X, B> Kind<Kind<ForAndThen, X>, Boolean>.ifM(arg1: Function0<Kind<Kind<ForAndThen, X>, B>>, arg2: Function0<Kind<Kind<ForAndThen, X>, B>>): AndThen<X, B> = arrow.data.AndThen.monad<X>().run {
  this@ifM.ifM<B>(arg1, arg2) as arrow.data.AndThen<X, B>
}

@JvmName("selectM")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <X, A, B> Kind<Kind<ForAndThen, X>, Either<A, B>>.selectM(arg1: Kind<Kind<ForAndThen, X>, Function1<A, B>>): AndThen<X, B> = arrow.data.AndThen.monad<X>().run {
  this@selectM.selectM<A, B>(arg1) as arrow.data.AndThen<X, B>
}

@JvmName("select")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <X, A, B> Kind<Kind<ForAndThen, X>, Either<A, B>>.select(arg1: Kind<Kind<ForAndThen, X>, Function1<A, B>>): AndThen<X, B> = arrow.data.AndThen.monad<X>().run {
  this@select.select<A, B>(arg1) as arrow.data.AndThen<X, B>
}

/**
 * Entry point for monad bindings which enables for comprehension. The underlying implementation is based on coroutines.
 * A coroutine is initiated and suspended inside [MonadErrorContinuation] yielding to [Monad.flatMap]. Once all the flatMap binds are completed
 * the underlying monad is returned from the act of executing the coroutine
 */
@JvmName("binding")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <X, A> binding(arg0: suspend MonadContinuation<Kind<ForAndThen, X>, *>.() -> A): AndThen<X, A> = arrow.data.AndThen
   .monad<X>()
   .binding<A>(arg0) as arrow.data.AndThen<X, A>

/**
 * ank_macro_hierarchy(arrow.typeclasses.Monad)
 *
 * [Monad] abstract over the ability to declare sequential computations that are dependent in the order or
 * the results of previous computations.
 *
 * Given a type constructor [F] with a value of [A] we can compose multiple operations of type
 * `Kind<F, ?>` where `?` denotes a value being transformed.
 *
 * This is true for all type constructors that can support the [Monad] type class including and not limited to
 * [IO], [DeferredK], [ObservableK], [Option], [Either], [List], [Try] ...
 *
 * [The Monad Tutorial](https://arrow-kt.io/docs/patterns/monads/)
 *
 */
fun <X> Companion.monad(): AndThenMonad<X> = object : arrow.data.extensions.AndThenMonad<X> {  }