package arrow.data.extensions.coproduct.comonad

import arrow.Kind
import arrow.data.Coproduct
import arrow.data.Coproduct.Companion
import arrow.data.ForCoproduct
import arrow.data.extensions.CoproductComonad
import arrow.typeclasses.Comonad
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("coflatMap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.coflatMap(
    CF: Comonad<F>,
    CG: Comonad<G>,
    arg1: Function1<Kind<Kind<Kind<ForCoproduct, F>, G>, A>, B>
): Coproduct<F, G, B> = arrow.data.Coproduct.comonad<F, G>(CF, CG).run {
  this@coflatMap.coflatMap<A, B>(arg1) as arrow.data.Coproduct<F, G, B>
}

@JvmName("extract")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.extract(CF: Comonad<F>, CG: Comonad<G>): A = arrow.data.Coproduct.comonad<F, G>(CF, CG).run {
  this@extract.extract<A>() as A
}

@JvmName("duplicate")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.duplicate(CF: Comonad<F>, CG: Comonad<G>): Coproduct<F, G, Coproduct<F, G, A>> = arrow.data.Coproduct.comonad<F, G>(CF, CG).run {
  this@duplicate.duplicate<A>() as arrow.data.Coproduct<F, G, arrow.data.Coproduct<F, G, A>>
}

fun <F, G> Companion.comonad(CF: Comonad<F>, CG: Comonad<G>): CoproductComonad<F, G> = object : arrow.data.extensions.CoproductComonad<F, G> { override fun CF(): arrow.typeclasses.Comonad<F> = CF

  override fun CG(): arrow.typeclasses.Comonad<G> = CG }