package arrow.data.extensions.coproduct.contravariant

import arrow.Kind
import arrow.data.Coproduct
import arrow.data.Coproduct.Companion
import arrow.data.ForCoproduct
import arrow.data.extensions.CoproductContravariant
import arrow.typeclasses.Contravariant
import kotlin.Function1
import kotlin.Suppress
import kotlin.jvm.JvmName

@JvmName("contramap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.contramap(
    CF: Contravariant<F>,
    CG: Contravariant<G>,
    arg1: Function1<B, A>
): Coproduct<F, G, B> = arrow.data.Coproduct.contravariant<F, G>(CF, CG).run {
  this@contramap.contramap<A, B>(arg1) as arrow.data.Coproduct<F, G, B>
}

@JvmName("lift1")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> lift(
    CF: Contravariant<F>,
    CG: Contravariant<G>,
    arg0: Function1<A, B>
): Function1<Kind<Kind<Kind<ForCoproduct, F>, G>, B>, Kind<Kind<Kind<ForCoproduct, F>, G>, A>> = arrow.data.Coproduct
   .contravariant<F, G>(CF, CG)
   .lift<A, B>(arg0) as kotlin.Function1<arrow.Kind<arrow.Kind<arrow.Kind<arrow.data.ForCoproduct, F>, G>, B>, arrow.Kind<arrow.Kind<arrow.Kind<arrow.data.ForCoproduct, F>, G>, A>>

@JvmName("imap")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.imap(
    CF: Contravariant<F>,
    CG: Contravariant<G>,
    arg1: Function1<A, B>,
    arg2: Function1<B, A>
): Coproduct<F, G, B> = arrow.data.Coproduct.contravariant<F, G>(CF, CG).run {
  this@imap.imap<A, B>(arg1, arg2) as arrow.data.Coproduct<F, G, B>
}

@JvmName("narrow")
@Suppress(
        "UNCHECKED_CAST",
        "USELESS_CAST",
        "EXTENSION_SHADOWED_BY_MEMBER",
        "UNUSED_PARAMETER"
)
fun <F, G, A, B : A> Kind<Kind<Kind<ForCoproduct, F>, G>, A>.narrow(CF: Contravariant<F>, CG: Contravariant<G>): Coproduct<F, G, B> = arrow.data.Coproduct.contravariant<F, G>(CF, CG).run {
  this@narrow.narrow<A, B>() as arrow.data.Coproduct<F, G, B>
}

fun <F, G> Companion.contravariant(CF: Contravariant<F>, CG: Contravariant<G>): CoproductContravariant<F, G> = object : arrow.data.extensions.CoproductContravariant<F, G> { override fun CF(): arrow.typeclasses.Contravariant<F> = CF

  override fun CG(): arrow.typeclasses.Contravariant<G> = CG }